/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.HierarchyUtils;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXNavigationHierarchy;
import org.apache.myfaces.trinidad.event.RowDisclosureListener;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.RowKeySetTreeImpl;
import org.apache.myfaces.trinidad.model.TreeModel;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXPage
extends UIXNavigationHierarchy {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXNavigationHierarchy.TYPE);
    public static final PropertyKey ROW_DISCLOSURE_LISTENER_KEY = TYPE.registerKey("rowDisclosureListener", MethodBinding.class, 9);
    public static final PropertyKey DISCLOSED_ROW_KEYS_KEY = TYPE.registerKey("disclosedRowKeys", RowKeySet.class);
    public static final PropertyKey VALUE_KEY = TYPE.registerKey("value");
    public static final PropertyKey VAR_STATUS_KEY = TYPE.registerKey("varStatus", String.class, 1);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class);
    public static final String NODE_STAMP_FACET = "nodeStamp";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Page";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Page";

    public UIXPage() {
        super("org.apache.myfaces.trinidad.BasePage");
    }

    public void queueEvent(FacesEvent event) {
        TableUtils.__handleQueueEvent(this, event);
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        HierarchyUtils.__handleBroadcast(this, event, this.getDisclosedRowKeys(), this.getRowDisclosureListener());
        super.broadcast(event);
    }

    public CollectionModel createCollectionModel(CollectionModel current, Object value) {
        TreeModel model = (TreeModel)super.createCollectionModel(current, value);
        RowKeySet treeState = this.getDisclosedRowKeys();
        treeState.setCollectionModel(model);
        return model;
    }

    protected void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        Object oldPath = this.getRowKey();
        this.setRowKey(null);
        HierarchyUtils.__iterateOverTree(context, phaseId, this, this.getDisclosedRowKeys(), false);
        this.setRowKey(oldPath);
        TableUtils.__processChildren(context, this, phaseId);
        Map facets = this.getFacets();
        for (String facetKey : facets.keySet()) {
            if (NODE_STAMP_FACET.equals(facetKey)) continue;
            this.processComponent(context, (UIComponent)facets.get(facetKey), phaseId);
        }
    }

    void __encodeBegin(FacesContext context) throws IOException {
        HierarchyUtils.__handleEncodeBegin(this, this.getDisclosedRowKeys());
        super.__encodeBegin(context);
    }

    void __init() {
        super.__init();
        if (this.getDisclosedRowKeys() == null) {
            this.setDisclosedRowKeys(new RowKeySetTreeImpl());
        }
    }

    public final UIComponent getNodeStamp() {
        return this.getFacet(NODE_STAMP_FACET);
    }

    public final void setNodeStamp(UIComponent nodeStampFacet) {
        this.getFacets().put(NODE_STAMP_FACET, nodeStampFacet);
    }

    public final MethodBinding getRowDisclosureListener() {
        return (MethodBinding)this.getProperty(ROW_DISCLOSURE_LISTENER_KEY);
    }

    public final void setRowDisclosureListener(MethodBinding rowDisclosureListener) {
        this.setProperty(ROW_DISCLOSURE_LISTENER_KEY, rowDisclosureListener);
    }

    public final RowKeySet getDisclosedRowKeys() {
        return (RowKeySet)this.getProperty(DISCLOSED_ROW_KEYS_KEY);
    }

    public final void setDisclosedRowKeys(RowKeySet disclosedRowKeys) {
        this.setProperty(DISCLOSED_ROW_KEYS_KEY, disclosedRowKeys);
    }

    public final Object getValue() {
        return this.getProperty(VALUE_KEY);
    }

    public final void setValue(Object value) {
        this.setProperty(VALUE_KEY, value);
    }

    public final String getVarStatus() {
        return ComponentUtils.resolveString(this.getProperty(VAR_STATUS_KEY));
    }

    public final void setVarStatus(String varStatus) {
        this.setProperty(VAR_STATUS_KEY, varStatus);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY));
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void addRowDisclosureListener(RowDisclosureListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeRowDisclosureListener(RowDisclosureListener listener) {
        this.removeFacesListener(listener);
    }

    public final RowDisclosureListener[] getRowDisclosureListeners() {
        return (RowDisclosureListener[])this.getFacesListeners(RowDisclosureListener.class);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.Page";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXPage(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Page", "org.apache.myfaces.trinidad.BasePage");
    }
}

