/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.event.PollEvent;
import org.apache.myfaces.trinidad.event.PollListener;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXPoll
extends UIXComponentBase {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class);
    public static final PropertyKey POLL_LISTENER_KEY = TYPE.registerKey("pollListener", MethodBinding.class, 9);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Poll";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Poll";

    public UIXPoll() {
        super("org.apache.myfaces.trinidad.Poll");
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof PollEvent) {
            this.broadcastToMethodBinding(event, this.getPollListener());
        }
    }

    public void queueEvent(FacesEvent e) {
        if (e instanceof PollEvent && e.getSource() == this) {
            if (this.isImmediate()) {
                e.setPhaseId(PhaseId.ANY_PHASE);
            } else {
                e.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(e);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY));
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final MethodBinding getPollListener() {
        return (MethodBinding)this.getProperty(POLL_LISTENER_KEY);
    }

    public final void setPollListener(MethodBinding pollListener) {
        this.setProperty(POLL_LISTENER_KEY, pollListener);
    }

    public final void addPollListener(PollListener listener) {
        this.addFacesListener(listener);
    }

    public final void removePollListener(PollListener listener) {
        this.removeFacesListener(listener);
    }

    public final PollListener[] getPollListeners() {
        return (PollListener[])this.getFacesListeners(PollListener.class);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.Poll";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXPoll(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Poll", "org.apache.myfaces.trinidad.Poll");
    }
}

