/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.StampState;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXIterator;
import org.apache.myfaces.trinidad.event.RangeChangeEvent;
import org.apache.myfaces.trinidad.event.RangeChangeListener;
import org.apache.myfaces.trinidad.event.RowDisclosureEvent;
import org.apache.myfaces.trinidad.event.RowDisclosureListener;
import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.event.SelectionListener;
import org.apache.myfaces.trinidad.event.SortEvent;
import org.apache.myfaces.trinidad.event.SortListener;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.RowKeySetImpl;
import org.apache.myfaces.trinidad.model.SortCriterion;
import org.apache.myfaces.trinidad.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIXTable
extends UIXIterator
implements CollectionComponent,
NamingContainer {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXIterator.TYPE);
    public static final PropertyKey ROW_DISCLOSURE_LISTENER_KEY = TYPE.registerKey("rowDisclosureListener", MethodBinding.class, 9);
    public static final PropertyKey DISCLOSED_ROW_KEYS_KEY = TYPE.registerKey("disclosedRowKeys", RowKeySet.class);
    public static final PropertyKey SELECTION_LISTENER_KEY = TYPE.registerKey("selectionListener", MethodBinding.class, 9);
    public static final PropertyKey SELECTED_ROW_KEYS_KEY = TYPE.registerKey("selectedRowKeys", RowKeySet.class);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class);
    public static final PropertyKey SORT_LISTENER_KEY = TYPE.registerKey("sortListener", MethodBinding.class, 9);
    public static final PropertyKey RANGE_CHANGE_LISTENER_KEY = TYPE.registerKey("rangeChangeListener", MethodBinding.class, 9);
    public static final PropertyKey SHOW_ALL_KEY = TYPE.registerKey("showAll", Boolean.class, Boolean.FALSE);
    public static final String DETAIL_STAMP_FACET = "detailStamp";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Table";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Table";
    private transient List<SortCriterion> _sortCriteria = null;

    public UIXTable() {
        super("org.apache.myfaces.trinidad.Table");
    }

    @Override
    public void setSortCriteria(List<SortCriterion> criteria) {
        this._sortCriteria = criteria;
        super.setSortCriteria(criteria);
    }

    @Override
    public void queueEvent(FacesEvent event) {
        TableUtils.__handleQueueEvent(this, event);
        super.queueEvent(event);
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof RangeChangeEvent) {
            RangeChangeEvent rEvent = (RangeChangeEvent)event;
            int first = rEvent.getNewStart();
            this.setFirst(first);
            this.addAttributeChange("first", new Integer(first));
            if (first == 0 && rEvent.getNewEnd() == this.getRowCount()) {
                this.setShowAll(true);
                this.addAttributeChange("showAll", Boolean.TRUE);
            } else if (this.isShowAll()) {
                this.setShowAll(false);
                this.addAttributeChange("showAll", Boolean.FALSE);
            }
            this.clearCurrencyStringCache();
            this.broadcastToMethodBinding(event, this.getRangeChangeListener());
        } else if (event instanceof RowDisclosureEvent) {
            RowDisclosureEvent eEvent = (RowDisclosureEvent)event;
            RowKeySet set = this.getDisclosedRowKeys();
            set.addAll(eEvent.getAddedSet());
            set.removeAll(eEvent.getRemovedSet());
            this.broadcastToMethodBinding(event, this.getRowDisclosureListener());
        } else if (event instanceof SortEvent) {
            SortEvent sEvent = (SortEvent)event;
            this.setSortCriteria(sEvent.getSortCriteria());
            this.broadcastToMethodBinding(event, this.getSortListener());
        } else if (event instanceof SelectionEvent) {
            this.addAttributeChange("selectedRowKeys", this.getSelectedRowKeys());
            this.broadcastToMethodBinding(event, this.getSelectionListener());
        }
        super.broadcast(event);
    }

    @Override
    public Object saveState(FacesContext context) {
        Object o = super.saveState(context);
        if (o == null && (this._sortCriteria == null || this._sortCriteria.isEmpty())) {
            return null;
        }
        return new Object[]{o, this._sortCriteria};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        List criteria;
        Object[] array = (Object[])state;
        super.restoreState(context, array[0]);
        this._sortCriteria = criteria = (List)array[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSelectedRowData() {
        RowKeySet state = this.getSelectedRowKeys();
        Iterator keys = state.iterator();
        if (keys.hasNext()) {
            Object key = keys.next();
            CollectionModel model = this.getCollectionModel();
            Object old = model.getRowKey();
            try {
                model.setRowKey(key);
                Object object = model.getRowData();
                return object;
            }
            finally {
                model.setRowKey(old);
            }
        }
        return null;
    }

    @Override
    protected final void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        TableUtils.__processFacets(context, this, this, phaseId, DETAIL_STAMP_FACET);
        TableUtils.__processColumnFacets(context, this, this, phaseId);
        this._processStamps(context, phaseId);
    }

    @Override
    protected final List<UIComponent> getStamps() {
        List<UIComponent> children = super.getStamps();
        UIComponent detail = this.getDetailStamp();
        if (detail != null) {
            ArrayList<UIComponent> stamps = new ArrayList<UIComponent>(children.size() + 1);
            stamps.addAll(children);
            stamps.add(detail);
            return stamps;
        }
        return children;
    }

    @Override
    protected final Object saveStampState(FacesContext context, UIComponent stamp) {
        if (stamp instanceof UIXColumn) {
            return StampState.saveChildStampState(context, stamp, this);
        }
        return super.saveStampState(context, stamp);
    }

    @Override
    protected final void restoreStampState(FacesContext context, UIComponent stamp, Object stampState) {
        if (stamp instanceof UIXColumn) {
            StampState.restoreChildStampState(context, stamp, this, stampState);
        } else {
            super.restoreStampState(context, stamp, stampState);
        }
    }

    @Override
    protected final CollectionModel createCollectionModel(CollectionModel current, Object value) {
        CollectionModel model = super.createCollectionModel(current, value);
        this.getSelectedRowKeys().setCollectionModel(model);
        this.getDisclosedRowKeys().setCollectionModel(model);
        if (this._sortCriteria != null) {
            model.setSortCriteria(this._sortCriteria);
        }
        return model;
    }

    @Override
    Object __getMyStampState() {
        Object[] state = new Object[]{this._sortCriteria, super.__getMyStampState(), new Integer(this.getFirst()), this.isShowAll(), this.getSelectedRowKeys(), this.getDisclosedRowKeys()};
        return state;
    }

    @Override
    void __setMyStampState(Object stampState) {
        Object[] state = (Object[])stampState;
        this._sortCriteria = (List)state[0];
        super.__setMyStampState(state[1]);
        this.setFirst((Integer)state[2]);
        this.setShowAll(Boolean.TRUE == state[3]);
        this.setSelectedRowKeys((RowKeySet)state[4]);
        this.setDisclosedRowKeys((RowKeySet)state[5]);
    }

    private void _processStamps(FacesContext context, PhaseId phaseId) {
        CollectionModel tableData = this.getCollectionModel();
        if (tableData.getRowCount() != 0) {
            int startIndex = this.getFirst();
            int endIndex = this.isShowAll() ? this.getRowCount() - 1 : TableUtils.getLast(this);
            UIComponent detail = this.getDetailStamp();
            RowKeySet disclosureState = detail == null ? null : this.getDisclosedRowKeys();
            for (int i = startIndex; i <= endIndex; ++i) {
                this.setRowIndex(i);
                TableUtils.__processStampedChildren(context, this, phaseId);
                if (disclosureState == null || !disclosureState.isContained()) continue;
                assert (this.getRowIndex() == i);
                this.processComponent(context, detail, phaseId);
            }
            this.setRowIndex(-1);
        }
    }

    @Override
    void __init() {
        super.__init();
        if (this.getSelectedRowKeys() == null) {
            this.setSelectedRowKeys(new RowKeySetImpl());
        }
        if (this.getDisclosedRowKeys() == null) {
            this.setDisclosedRowKeys(new RowKeySetImpl());
        }
        this.setFirst(this.getFirst());
    }

    public final UIComponent getDetailStamp() {
        return this.getFacet(DETAIL_STAMP_FACET);
    }

    public final void setDetailStamp(UIComponent detailStampFacet) {
        this.getFacets().put(DETAIL_STAMP_FACET, detailStampFacet);
    }

    public final MethodBinding getRowDisclosureListener() {
        return (MethodBinding)this.getProperty(ROW_DISCLOSURE_LISTENER_KEY);
    }

    public final void setRowDisclosureListener(MethodBinding rowDisclosureListener) {
        this.setProperty(ROW_DISCLOSURE_LISTENER_KEY, rowDisclosureListener);
    }

    public final RowKeySet getDisclosedRowKeys() {
        return (RowKeySet)this.getProperty(DISCLOSED_ROW_KEYS_KEY);
    }

    public final void setDisclosedRowKeys(RowKeySet disclosedRowKeys) {
        this.setProperty(DISCLOSED_ROW_KEYS_KEY, disclosedRowKeys);
    }

    public final MethodBinding getSelectionListener() {
        return (MethodBinding)this.getProperty(SELECTION_LISTENER_KEY);
    }

    public final void setSelectionListener(MethodBinding selectionListener) {
        this.setProperty(SELECTION_LISTENER_KEY, selectionListener);
    }

    public final RowKeySet getSelectedRowKeys() {
        return (RowKeySet)this.getProperty(SELECTED_ROW_KEYS_KEY);
    }

    public final void setSelectedRowKeys(RowKeySet selectedRowKeys) {
        this.setProperty(SELECTED_ROW_KEYS_KEY, selectedRowKeys);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY));
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final MethodBinding getSortListener() {
        return (MethodBinding)this.getProperty(SORT_LISTENER_KEY);
    }

    public final void setSortListener(MethodBinding sortListener) {
        this.setProperty(SORT_LISTENER_KEY, sortListener);
    }

    public final MethodBinding getRangeChangeListener() {
        return (MethodBinding)this.getProperty(RANGE_CHANGE_LISTENER_KEY);
    }

    public final void setRangeChangeListener(MethodBinding rangeChangeListener) {
        this.setProperty(RANGE_CHANGE_LISTENER_KEY, rangeChangeListener);
    }

    public final boolean isShowAll() {
        return ComponentUtils.resolveBoolean(this.getProperty(SHOW_ALL_KEY), false);
    }

    public final void setShowAll(boolean showAll) {
        this.setProperty(SHOW_ALL_KEY, showAll ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void addRowDisclosureListener(RowDisclosureListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeRowDisclosureListener(RowDisclosureListener listener) {
        this.removeFacesListener(listener);
    }

    public final RowDisclosureListener[] getRowDisclosureListeners() {
        return (RowDisclosureListener[])this.getFacesListeners(RowDisclosureListener.class);
    }

    public final void addSelectionListener(SelectionListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeSelectionListener(SelectionListener listener) {
        this.removeFacesListener(listener);
    }

    public final SelectionListener[] getSelectionListeners() {
        return (SelectionListener[])this.getFacesListeners(SelectionListener.class);
    }

    public final void addRangeChangeListener(RangeChangeListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeRangeChangeListener(RangeChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public final RangeChangeListener[] getRangeChangeListeners() {
        return (RangeChangeListener[])this.getFacesListeners(RangeChangeListener.class);
    }

    public final void addSortListener(SortListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeSortListener(SortListener listener) {
        this.removeFacesListener(listener);
    }

    public final SortListener[] getSortListeners() {
        return (SortListener[])this.getFacesListeners(SortListener.class);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.Table";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXTable(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Table", "org.apache.myfaces.trinidad.Table");
    }
}

