/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.HierarchyUtils;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.event.FocusListener;
import org.apache.myfaces.trinidad.event.RowDisclosureListener;
import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.event.SelectionListener;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.RowKeySetTreeImpl;
import org.apache.myfaces.trinidad.model.TreeModel;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXTree
extends UIXHierarchy
implements NamingContainer {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXHierarchy.TYPE);
    public static final PropertyKey SELECTED_ROW_KEYS_KEY = TYPE.registerKey("selectedRowKeys", RowKeySet.class);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class);
    public static final PropertyKey ROW_DISCLOSURE_LISTENER_KEY = TYPE.registerKey("rowDisclosureListener", MethodBinding.class, 9);
    public static final PropertyKey DISCLOSED_ROW_KEYS_KEY = TYPE.registerKey("disclosedRowKeys", RowKeySet.class);
    public static final PropertyKey SELECTION_LISTENER_KEY = TYPE.registerKey("selectionListener", MethodBinding.class, 9);
    public static final PropertyKey VAR_STATUS_KEY = TYPE.registerKey("varStatus", String.class, 1);
    public static final PropertyKey VALUE_KEY = TYPE.registerKey("value");
    public static final PropertyKey FOCUS_ROW_KEY_KEY = TYPE.registerKey("focusRowKey");
    public static final PropertyKey FOCUS_LISTENER_KEY = TYPE.registerKey("focusListener", MethodBinding.class, 9);
    public static final String NODE_STAMP_FACET = "nodeStamp";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Tree";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Tree";

    public UIXTree() {
        super("org.apache.myfaces.trinidad.Tree");
    }

    public void queueEvent(FacesEvent event) {
        TableUtils.__handleQueueEvent(this, event);
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof SelectionEvent) {
            this.addAttributeChange("selectedRowKeys", this.getSelectedRowKeys());
            this.broadcastToMethodBinding(event, this.getSelectionListener());
        }
        HierarchyUtils.__handleBroadcast(this, event, this.getDisclosedRowKeys(), this.getRowDisclosureListener());
        super.broadcast(event);
    }

    public CollectionModel createCollectionModel(CollectionModel current, Object value) {
        TreeModel model = ModelUtils.toTreeModel(value);
        model.setRowKey(null);
        this.getDisclosedRowKeys().setCollectionModel(model);
        this.getSelectedRowKeys().setCollectionModel(model);
        return model;
    }

    protected void processFacetsAndChildren(FacesContext context, PhaseId phaseId) {
        Object oldPath = this.getRowKey();
        this.setRowKey(null);
        HierarchyUtils.__iterateOverTree(context, phaseId, this, this.getDisclosedRowKeys(), true);
        this.setRowKey(oldPath);
    }

    void __init() {
        super.__init();
        if (this.getDisclosedRowKeys() == null) {
            this.setDisclosedRowKeys(new RowKeySetTreeImpl());
        }
        if (this.getSelectedRowKeys() == null) {
            this.setSelectedRowKeys(new RowKeySetTreeImpl());
        }
    }

    public final UIComponent getNodeStamp() {
        return this.getFacet(NODE_STAMP_FACET);
    }

    public final void setNodeStamp(UIComponent nodeStampFacet) {
        this.getFacets().put(NODE_STAMP_FACET, nodeStampFacet);
    }

    public final RowKeySet getSelectedRowKeys() {
        return (RowKeySet)this.getProperty(SELECTED_ROW_KEYS_KEY);
    }

    public final void setSelectedRowKeys(RowKeySet selectedRowKeys) {
        this.setProperty(SELECTED_ROW_KEYS_KEY, selectedRowKeys);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY));
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final MethodBinding getRowDisclosureListener() {
        return (MethodBinding)this.getProperty(ROW_DISCLOSURE_LISTENER_KEY);
    }

    public final void setRowDisclosureListener(MethodBinding rowDisclosureListener) {
        this.setProperty(ROW_DISCLOSURE_LISTENER_KEY, rowDisclosureListener);
    }

    public final RowKeySet getDisclosedRowKeys() {
        return (RowKeySet)this.getProperty(DISCLOSED_ROW_KEYS_KEY);
    }

    public final void setDisclosedRowKeys(RowKeySet disclosedRowKeys) {
        this.setProperty(DISCLOSED_ROW_KEYS_KEY, disclosedRowKeys);
    }

    public final MethodBinding getSelectionListener() {
        return (MethodBinding)this.getProperty(SELECTION_LISTENER_KEY);
    }

    public final void setSelectionListener(MethodBinding selectionListener) {
        this.setProperty(SELECTION_LISTENER_KEY, selectionListener);
    }

    public final String getVarStatus() {
        return ComponentUtils.resolveString(this.getProperty(VAR_STATUS_KEY));
    }

    public final void setVarStatus(String varStatus) {
        this.setProperty(VAR_STATUS_KEY, varStatus);
    }

    public final Object getValue() {
        return this.getProperty(VALUE_KEY);
    }

    public final void setValue(Object value) {
        this.setProperty(VALUE_KEY, value);
    }

    public final Object getFocusRowKey() {
        return this.getProperty(FOCUS_ROW_KEY_KEY);
    }

    public final void setFocusRowKey(Object focusRowKey) {
        this.setProperty(FOCUS_ROW_KEY_KEY, focusRowKey);
    }

    public final MethodBinding getFocusListener() {
        return (MethodBinding)this.getProperty(FOCUS_LISTENER_KEY);
    }

    public final void setFocusListener(MethodBinding focusListener) {
        this.setProperty(FOCUS_LISTENER_KEY, focusListener);
    }

    public final void addRowDisclosureListener(RowDisclosureListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeRowDisclosureListener(RowDisclosureListener listener) {
        this.removeFacesListener(listener);
    }

    public final RowDisclosureListener[] getRowDisclosureListeners() {
        return (RowDisclosureListener[])this.getFacesListeners(RowDisclosureListener.class);
    }

    public final void addSelectionListener(SelectionListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeSelectionListener(SelectionListener listener) {
        this.removeFacesListener(listener);
    }

    public final SelectionListener[] getSelectionListeners() {
        return (SelectionListener[])this.getFacesListeners(SelectionListener.class);
    }

    public final void addFocusListener(FocusListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeFocusListener(FocusListener listener) {
        this.removeFacesListener(listener);
    }

    public final FocusListener[] getFocusListeners() {
        return (FocusListener[])this.getFacesListeners(FocusListener.class);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.Tree";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXTree(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Tree", "org.apache.myfaces.trinidad.Tree");
    }
}

