/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.context;

import java.awt.Color;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.config.RegionManager;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.DialogService;
import org.apache.myfaces.trinidad.context.PageFlowScopeProvider;
import org.apache.myfaces.trinidad.context.PageResolver;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.webapp.UploadedFileProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestContext {
    public static final String VARIABLE_NAME = "requestContext";
    private static final ThreadLocal<RequestContext> _CURRENT_CONTEXT = new ThreadLocal();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RequestContext.class);

    public static RequestContext getCurrentInstance() {
        return _CURRENT_CONTEXT.get();
    }

    protected RequestContext() {
    }

    public abstract Map<String, Object> getPageFlowScope();

    @Deprecated
    public final Map<String, Object> getProcessScope() {
        return this.getPageFlowScope();
    }

    public abstract void returnFromDialog(Object var1, Map<Object, Object> var2);

    public abstract DialogService getDialogService();

    public abstract void launchDialog(UIViewRoot var1, Map<String, Object> var2, UIComponent var3, boolean var4, Map<String, Object> var5);

    public abstract boolean isPostback();

    public abstract boolean isPartialRequest(FacesContext var1);

    public abstract boolean isDebugOutput();

    public abstract boolean isClientValidationDisabled();

    public abstract String getOutputMode();

    public abstract String getSkinFamily();

    public abstract Accessibility getAccessibilityMode();

    public abstract boolean isRightToLeft();

    public abstract Locale getFormattingLocale();

    public abstract char getNumberGroupingSeparator();

    public abstract char getDecimalSeparator();

    public abstract String getCurrencyCode();

    public abstract int getTwoDigitYearStart();

    public abstract String getOracleHelpServletUrl();

    public abstract Map<String, Object> getHelpTopic();

    public abstract Map<String, Object> getHelpSystem();

    public abstract TimeZone getTimeZone();

    public abstract ChangeManager getChangeManager();

    public abstract PageFlowScopeProvider getPageFlowScopeProvider();

    public abstract PageResolver getPageResolver();

    public abstract RegionManager getRegionManager();

    public abstract void addPartialTarget(UIComponent var1);

    public abstract void addPartialTriggerListeners(UIComponent var1, String[] var2);

    public abstract void partialUpdateNotify(UIComponent var1);

    public abstract UploadedFileProcessor getUploadedFileProcessor();

    public abstract Map<String, List<Color>> getColorPalette();

    public abstract Map<Object, Map<Object, String>> getFormatter();

    public abstract Agent getAgent();

    public abstract Object saveComponent(UIComponent var1);

    public abstract UIComponent restoreComponent(Object var1) throws ClassNotFoundException, InstantiationException, IllegalAccessException;

    public void release() {
        RequestContext o;
        if (_LOG.isFinest()) {
            _LOG.finest("RequestContext released.", new RuntimeException("This is not an error. This trace is for debugging."));
        }
        if ((o = _CURRENT_CONTEXT.get()) == null) {
            throw new IllegalStateException(RequestContext._addHelp("RequestContext was already released or had never been attached."));
        }
        if (o != this) {
            throw new IllegalStateException("Trying to release a different RequestContext than the current context.");
        }
        _CURRENT_CONTEXT.remove();
    }

    public void attach() {
        RequestContext o;
        if (_LOG.isFinest()) {
            _LOG.finest("RequestContext attached.", new RuntimeException("This is not an error. This trace is for debugging."));
        }
        if ((o = _CURRENT_CONTEXT.get()) != null) {
            throw new IllegalStateException(RequestContext._addHelp("Trying to attach RequestContext to a thread that already had one."));
        }
        _CURRENT_CONTEXT.set(this);
    }

    private static String _addHelp(String error) {
        if (!_LOG.isFinest()) {
            error = error + " To enable stack traces of each RequestContext attach/release call, enable Level.FINEST logging for the " + RequestContext.class;
        }
        return error;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Accessibility {
        DEFAULT("default"),
        INACCESSIBLE("inaccessible"),
        SCREEN_READER("screnReader");

        private final String _name;

        private Accessibility(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

