/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.convert;

import java.awt.Color;
import java.text.ParseException;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.convert.ColorFormat;
import org.apache.myfaces.trinidad.convert.ConverterUtils;
import org.apache.myfaces.trinidad.convert.RGBColorFormat;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;

public class ColorConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "org.apache.myfaces.trinidad.Color";
    public static final String CONVERT_MESSAGE_ID = "org.apache.myfaces.trinidad.convert.ColorConverter.CONVERT";
    private static final String TRANSPARENT = "org.apache.myfaces.trinidad.convert.ColorConverter.TRANSPARENT";
    public static final String[] DEFAULT_COLOR_FORMAT_PATTERNS = new String[]{"#RRGGBB", "r,g,b"};
    private static final Color _TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private boolean _isTransient;
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _TRANSPARENT_ALLOWED_KEY = _TYPE.registerKey("transparentAllowed", Boolean.class, Boolean.FALSE);
    private static final PropertyKey _PATTERNS_KEY = _TYPE.registerKey("patterns", String[].class, DEFAULT_COLOR_FORMAT_PATTERNS);
    private static final PropertyKey _CONVERT_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailConvert", String.class);
    private static final PropertyKey _HINT_FORMAT_KEY = _TYPE.registerKey("hintFormat", String.class);
    private FacesBean _facesBean = ConverterUtils.getFacesBean(_TYPE);

    public ColorConverter(String[] patterns, boolean allowsTransparent) {
        if (patterns == null) {
            this._facesBean.setProperty(_PATTERNS_KEY, DEFAULT_COLOR_FORMAT_PATTERNS);
        } else {
            this._facesBean.setProperty(_PATTERNS_KEY, patterns);
        }
        this.setTransparentAllowed(allowsTransparent);
    }

    public ColorConverter() {
        this(null, false);
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException("Supplied FacesContext or UIComponent is null");
        }
        if (value == null) {
            return null;
        }
        if (0 == (value = value.trim()).length()) {
            return null;
        }
        try {
            return this._parseString(context, value);
        }
        catch (ParseException pe) {
            throw new ConverterException(this._getConvertMessage(context, component, value, this.getPatterns()));
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException("FacesContext or UIComponent is null");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Color) {
            return this._formatObject(context, (Color)value);
        }
        throw new IllegalArgumentException("'value' is not of type java.awt.Color'");
    }

    public void setTransparentAllowed(boolean isTransparentAllowed) {
        Boolean isAllowed = isTransparentAllowed ? Boolean.TRUE : Boolean.FALSE;
        this._facesBean.setProperty(_TRANSPARENT_ALLOWED_KEY, isAllowed);
    }

    public void setPatterns(String[] patterns) throws IllegalArgumentException {
        if (null == patterns || patterns.length == 0) {
            throw new IllegalArgumentException("Patterns should contain atleast one value and cannot be null");
        }
        String[] newPatterns = new String[patterns.length];
        System.arraycopy(patterns, 0, newPatterns, 0, patterns.length);
        this._facesBean.setProperty(_PATTERNS_KEY, newPatterns);
    }

    public String[] getPatterns() {
        return ComponentUtils.resolveStringArray(this._facesBean.getProperty(_PATTERNS_KEY));
    }

    public boolean isTransparentAllowed() {
        return ComponentUtils.resolveBoolean(this._facesBean.getProperty(_TRANSPARENT_ALLOWED_KEY));
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColorConverter)) {
            return false;
        }
        ColorConverter other = (ColorConverter)obj;
        return this.isTransient() == other.isTransient() && this.isTransparentAllowed() == other.isTransparentAllowed() && this._isEqualPatterns(other.getPatterns()) && ConverterUtils.equals(this.getMessageDetailConvert(), other.getMessageDetailConvert());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.isTransient() ? 1 : 0);
        result = 37 * result + (this.isTransparentAllowed() ? 1 : 0);
        String[] patterns = this.getPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            result = 37 * result + patterns[i].hashCode();
        }
        String convMsgDet = this.getMessageDetailConvert();
        result = result * 37 + (convMsgDet == null ? 0 : convMsgDet.hashCode());
        return result;
    }

    public boolean isTransient() {
        return this._isTransient;
    }

    public void setTransient(boolean isTransient) {
        this._isTransient = isTransient;
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ConverterUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ConverterUtils.getValueBinding(this._facesBean, name);
    }

    public void setMessageDetailConvert(String convertMessageDetail) {
        this._facesBean.setProperty(_CONVERT_MESSAGE_DETAIL_KEY, convertMessageDetail);
    }

    public String getMessageDetailConvert() {
        return ComponentUtils.resolveString(this._facesBean.getProperty(_CONVERT_MESSAGE_DETAIL_KEY));
    }

    public void setHint(String hintFormat) {
        this._facesBean.setProperty(_HINT_FORMAT_KEY, hintFormat);
    }

    public String getHint() {
        Object obj = this._facesBean.getProperty(_HINT_FORMAT_KEY);
        return ComponentUtils.resolveString(obj);
    }

    protected String getTransparentString(FacesContext context) {
        String msg = MessageFactory.getString(context, TRANSPARENT);
        return msg;
    }

    private Object _parseString(FacesContext context, String colorString) throws ParseException {
        boolean isTrans = this.isTransparentAllowed();
        if (isTrans && colorString != null && colorString.equals(this.getTransparentString(context))) {
            return _TRANSPARENT_COLOR;
        }
        ParseException pe = null;
        String[] thePatterns = this.getPatterns();
        for (int i = 0; i < thePatterns.length; ++i) {
            try {
                Color value = this._getColorFormat(thePatterns[i]).parse(colorString);
                return value;
            }
            catch (ParseException e) {
                pe = e;
                continue;
            }
        }
        if (pe != null) {
            throw pe;
        }
        return null;
    }

    private String _formatObject(FacesContext context, Color color) {
        if (color != null) {
            boolean isTrans = this.isTransparentAllowed();
            if (isTrans && color.getAlpha() == 0) {
                return this.getTransparentString(context);
            }
            return this._getFormattingColorFormat().format(color);
        }
        return null;
    }

    private ColorFormat _getFormattingColorFormat() {
        return this._getColorFormat(this._getOutputPattern());
    }

    private ColorFormat _getColorFormat(String pattern) {
        return new RGBColorFormat(pattern);
    }

    private String _getOutputPattern() {
        String[] patterns = this.getPatterns();
        return patterns[0];
    }

    private Object _getRawConvertMessageDetail() {
        return this._facesBean.getRawProperty(_CONVERT_MESSAGE_DETAIL_KEY);
    }

    private boolean _isEqualPatterns(String[] patterns) {
        String[] thisPattern = this.getPatterns();
        if (null == thisPattern && null == patterns) {
            return true;
        }
        if (thisPattern == null && patterns != null || patterns == null && thisPattern != null || thisPattern.length != patterns.length) {
            return false;
        }
        for (int i = 0; i < thisPattern.length; ++i) {
            if (thisPattern[i].equals(patterns[i])) continue;
            return false;
        }
        return true;
    }

    private FacesMessage _getConvertMessage(FacesContext context, UIComponent component, String value, String[] patternsArray) {
        Object noMatchMsgDet = this._getRawConvertMessageDetail();
        Object label = ConverterUtils.getComponentLabel(component);
        StringBuffer patterns = new StringBuffer();
        for (int i = 0; i < patternsArray.length; ++i) {
            patterns.append(patternsArray[i]);
            patterns.append(' ');
        }
        Object[] params = new Object[]{label, value, patterns, null, null};
        FacesMessage msg = MessageFactory.getMessage(context, CONVERT_MESSAGE_ID, noMatchMsgDet, params, component);
        return msg;
    }
}

