/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.event;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.LaunchListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchEvent
extends FacesEvent {
    private UIViewRoot _viewRoot;
    private Map<String, Object> _dialogParameters;
    private Map<String, Object> _windowProperties;

    public LaunchEvent(UIComponent source, UIViewRoot viewRoot) {
        super(source);
        this._viewRoot = viewRoot;
        this._dialogParameters = new HashMap<String, Object>();
        this._windowProperties = new HashMap<String, Object>();
        this.setPhaseId(PhaseId.ANY_PHASE);
    }

    public void launchDialog(boolean useWindow) {
        RequestContext afContext = RequestContext.getCurrentInstance();
        afContext.launchDialog(this.getViewRoot(), this.getDialogParameters(), this.getComponent(), useWindow, this.getWindowProperties());
    }

    public UIViewRoot getViewRoot() {
        return this._viewRoot;
    }

    public Map<String, Object> getDialogParameters() {
        return this._dialogParameters;
    }

    public Map<String, Object> getWindowProperties() {
        return this._windowProperties;
    }

    public void processListener(FacesListener listener) {
        ((LaunchListener)listener).processLaunch(this);
    }

    public boolean isAppropriateListener(FacesListener listener) {
        return listener instanceof LaunchListener;
    }

    public int hashCode() {
        int result = this.getComponent() == null ? 0 : this.getComponent().hashCode();
        result = 37 * result + (this._viewRoot == null ? 0 : this._viewRoot.hashCode());
        result = 37 * result + ((Object)this._windowProperties).hashCode();
        result = 37 * result + ((Object)this._dialogParameters).hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LaunchEvent) {
            LaunchEvent that = (LaunchEvent)((Object)o);
            if (!this.getComponent().equals(that.getComponent())) {
                return false;
            }
            if (this._viewRoot == null ? that._viewRoot != null : !this._viewRoot.equals(that._viewRoot)) {
                return false;
            }
            if (!((Object)this._dialogParameters).equals(that._dialogParameters)) {
                return false;
            }
            return ((Object)this._windowProperties).equals(that._windowProperties);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getName());
        sb.append("[component=");
        sb.append(this.getComponent());
        sb.append(", viewRoot=");
        sb.append(this.getViewRoot());
        sb.append(", dialogParameters=");
        sb.append(this.getDialogParameters());
        sb.append(", windowProperties=");
        sb.append(this.getWindowProperties());
        sb.append(']');
        return sb.toString();
    }
}

