/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.util.ArrayList;
import java.util.List;
import javax.faces.el.PropertyResolver;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.SortCriterion;
import org.apache.myfaces.trinidad.model.SortableModel;
import org.apache.myfaces.trinidad.model.TreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildPropertyTreeModel
extends TreeModel {
    private final List<Node> _path = new ArrayList<Node>(5);
    private String _childProperty = null;
    private Object _wrappedData = null;

    public ChildPropertyTreeModel(Object instance, String childProperty) {
        this();
        this.setChildProperty(childProperty);
        this.setWrappedData(instance);
    }

    public ChildPropertyTreeModel() {
        Node root = new Node(null);
        this._path.add(root);
    }

    @Override
    public Object getRowKey() {
        int sz = this._path.size() - 1;
        Object lastRowkey = this._getRowKey();
        if (sz == 0 && lastRowkey == null) {
            return null;
        }
        ArrayList<Object> path = new ArrayList<Object>(sz + 1);
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                Node node = this._getNode(i);
                path.add(node.childModel.getRowKey());
            }
        }
        path.add(lastRowkey);
        return path;
    }

    @Override
    public void setRowKey(Object rowKey) {
        Node root = this._getNode(0);
        this._path.clear();
        this._path.add(root);
        List path = (List)rowKey;
        if (path == null || path.size() == 0) {
            this.setRowIndex(-1);
            return;
        }
        int lastIndex = path.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            Object pathKey = path.get(i);
            this._setRowKey(pathKey);
            this.enterContainer();
        }
        this._setRowKey(path.get(lastIndex));
    }

    @Override
    public Object getContainerRowKey(Object childKey) {
        List path = (List)childKey;
        if (path == null || path.size() <= 1) {
            return null;
        }
        return path.subList(0, path.size() - 1);
    }

    @Override
    public int getRowCount() {
        return this._getModel().getRowCount();
    }

    @Override
    public Object getRowData() {
        return this._getModel().getRowData();
    }

    @Override
    public boolean isRowAvailable() {
        return this._getModel().isRowAvailable();
    }

    @Override
    public boolean isContainer() {
        Object rowData = this.getRowData();
        Object value = this.getChildData(rowData);
        return value != null;
    }

    @Override
    public void enterContainer() {
        Object rowData = this.getRowData();
        if (rowData == null) {
            throw new IllegalStateException("rowData is null");
        }
        Node node = new Node(rowData);
        this._path.add(node);
    }

    @Override
    public void exitContainer() {
        int sz = this._path.size();
        if (sz <= 1) {
            throw new IllegalStateException("Cannot exit the root container");
        }
        this._path.remove(sz - 1);
    }

    public Object getWrappedData() {
        return this._wrappedData;
    }

    public void setWrappedData(Object data) {
        Node root = this._getNode(0);
        root.childModel = ModelUtils.toCollectionModel(data);
        this.setRowKey(null);
        this._wrappedData = data;
    }

    public final String getChildProperty() {
        return this._childProperty;
    }

    public final void setChildProperty(String childProperty) {
        this._childProperty = childProperty;
    }

    @Override
    public int getRowIndex() {
        return this._getModel().getRowIndex();
    }

    @Override
    public void setRowIndex(int rowIndex) {
        this._getModel().setRowIndex(rowIndex);
    }

    @Override
    public boolean isSortable(String property) {
        return this._getModel().isSortable(property);
    }

    @Override
    public List<SortCriterion> getSortCriteria() {
        return this._getModel().getSortCriteria();
    }

    @Override
    public void setSortCriteria(List<SortCriterion> criteria) {
        this._getModel().setSortCriteria(criteria);
    }

    protected Object getChildData(Object parentData) {
        String prop = this.getChildProperty();
        if (prop == null) {
            return null;
        }
        PropertyResolver resolver = SortableModel.__getPropertyResolver();
        return resolver.getValue(parentData, (Object)prop);
    }

    protected CollectionModel createChildModel(Object childData) {
        CollectionModel model = ModelUtils.toCollectionModel(childData);
        model.setRowIndex(-1);
        return model;
    }

    private Object _getRowKey() {
        return this._getModel().getRowKey();
    }

    private void _setRowKey(Object key) {
        this._getModel().setRowKey(key);
    }

    private Node _getCurrentNode() {
        return this._getNode(this._path.size() - 1);
    }

    private Node _getNode(int index) {
        return this._path.get(index);
    }

    private CollectionModel _getModel() {
        Node node = this._getCurrentNode();
        CollectionModel model = node.childModel;
        if (model == null) {
            Object value = this.getChildData(node.parentData);
            node.childModel = model = this.createChildModel(value);
        }
        return model;
    }

    private static final class Node {
        public final Object parentData;
        public CollectionModel childModel = null;

        public Node(Object parentData) {
            this.parentData = parentData;
        }
    }
}

