/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.model.DataModel;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.SortCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableModel
extends CollectionModel {
    private SortCriterion _sortCriterion = null;
    private DataModel _model = null;
    private Object _wrappedData = null;
    private IntList _sortedIndicesList = null;
    private IntList _baseIndicesList = null;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SortableModel.class);

    public SortableModel(Object model) {
        this.setWrappedData(model);
    }

    public SortableModel() {
    }

    @Override
    public Object getRowData() {
        return this._model.getRowData();
    }

    public Object getWrappedData() {
        return this._wrappedData;
    }

    @Override
    public boolean isRowAvailable() {
        return this._model.isRowAvailable();
    }

    public void setWrappedData(Object data) {
        this._baseIndicesList = null;
        this._model = ModelUtils.toDataModel(data);
        this._sortCriterion = null;
        this._sortedIndicesList = null;
        this._wrappedData = data;
    }

    @Override
    public int getRowCount() {
        return this._model.getRowCount();
    }

    @Override
    public void setRowIndex(int rowIndex) {
        int baseIndex = this._toBaseIndex(rowIndex);
        this._model.setRowIndex(baseIndex);
    }

    @Override
    public int getRowIndex() {
        int baseIndex = this._model.getRowIndex();
        return this._toSortedIndex(baseIndex);
    }

    @Override
    public Object getRowKey() {
        return this.isRowAvailable() ? Integer.valueOf(this._model.getRowIndex()) : null;
    }

    @Override
    public void setRowKey(Object key) {
        this._model.setRowIndex(this._toRowIndex(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSortable(String property) {
        int oldIndex = this._model.getRowIndex();
        try {
            this._model.setRowIndex(0);
            if (!this._model.isRowAvailable()) {
                boolean bl = false;
                return bl;
            }
            Object data = this._model.getRowData();
            try {
                PropertyResolver resolver = SortableModel.__getPropertyResolver();
                Object propertyValue = resolver.getValue(data, (Object)property);
                boolean bl = propertyValue instanceof Comparable || propertyValue == null;
                return bl;
            }
            catch (RuntimeException e) {
                _LOG.warning(e);
                boolean bl = false;
                this._model.setRowIndex(oldIndex);
                return bl;
            }
        }
        finally {
            this._model.setRowIndex(oldIndex);
        }
    }

    @Override
    public List<SortCriterion> getSortCriteria() {
        if (this._sortCriterion == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this._sortCriterion);
    }

    @Override
    public void setSortCriteria(List<SortCriterion> criteria) {
        if (criteria == null || criteria.isEmpty()) {
            this._sortCriterion = null;
            this._sortedIndicesList = null;
            this._baseIndicesList = null;
        } else {
            SortCriterion sc = criteria.get(0);
            if (this._sortCriterion == null || !this._sortCriterion.equals(sc)) {
                this._sortCriterion = sc;
                this._sort(this._sortCriterion.getProperty(), this._sortCriterion.isAscending());
            }
        }
    }

    public String toString() {
        return "SortableModel[" + this._model + "]";
    }

    private void _sort(String property, boolean isAscending) {
        int sz = this.getRowCount();
        if (this._baseIndicesList == null || this._baseIndicesList.size() != sz) {
            this._baseIndicesList = new IntList(sz);
        }
        int rowIndex = this._model.getRowIndex();
        this._model.setRowIndex(0);
        if (this._model.isRowAvailable()) {
            Comparator<Integer> comp = new Comp(SortableModel.__getPropertyResolver(), property);
            if (!isAscending) {
                comp = new Inverter<Integer>(comp);
            }
            Collections.sort(this._baseIndicesList, comp);
            this._sortedIndicesList = null;
        }
        this._model.setRowIndex(rowIndex);
    }

    private int _toSortedIndex(int baseIndex) {
        if (this._sortedIndicesList == null && this._baseIndicesList != null) {
            this._sortedIndicesList = (IntList)this._baseIndicesList.clone();
            for (int i = 0; i < this._baseIndicesList.size(); ++i) {
                Integer base = (Integer)this._baseIndicesList.get(i);
                this._sortedIndicesList.set(base, i);
            }
        }
        return this._convertIndex(baseIndex, this._sortedIndicesList);
    }

    private int _toBaseIndex(int sortedIndex) {
        return this._convertIndex(sortedIndex, this._baseIndicesList);
    }

    private int _convertIndex(int index, List<Integer> indices) {
        if (index < 0) {
            return index;
        }
        if (indices != null && indices.size() > index) {
            index = indices.get(index);
        }
        return index;
    }

    private int _toRowIndex(Object rowKey) {
        if (rowKey == null) {
            return -1;
        }
        try {
            return (Integer)rowKey;
        }
        catch (ClassCastException e) {
            _LOG.warning("Invalid rowkey:" + rowKey + " type:" + rowKey.getClass(), e);
            return -1;
        }
    }

    static PropertyResolver __getPropertyResolver() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return context.getApplication().getPropertyResolver();
        }
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        return factory.getApplication().getPropertyResolver();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Inverter<T>
    implements Comparator<T> {
        private final Comparator<T> _comp;

        public Inverter(Comparator<T> comp) {
            this._comp = comp;
        }

        @Override
        public int compare(T o1, T o2) {
            return this._comp.compare(o2, o1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Comp
    implements Comparator<Integer> {
        private final PropertyResolver _resolver;
        private final String _prop;

        public Comp(PropertyResolver resolver, String property) {
            this._resolver = resolver;
            this._prop = property;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            int index1 = o1;
            int index2 = o2;
            SortableModel.this._model.setRowIndex(index1);
            Object instance1 = SortableModel.this._model.getRowData();
            Object value1 = this._resolver.getValue(instance1, (Object)this._prop);
            SortableModel.this._model.setRowIndex(index2);
            Object instance2 = SortableModel.this._model.getRowData();
            Object value2 = this._resolver.getValue(instance2, (Object)this._prop);
            if (value1 == null) {
                return value2 == null ? 0 : -1;
            }
            if (value2 == null) {
                return 1;
            }
            if (value1 instanceof Comparable) {
                return ((Comparable)value1).compareTo(value2);
            }
            return value1.toString().compareTo(value2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntList
    extends ArrayList<Integer>
    implements Cloneable {
        public IntList(int size) {
            super(size);
            this._expandToSize(size);
        }

        private void _expandToSize(int desiredSize) {
            for (int i = 0; i < desiredSize; ++i) {
                this.add(i);
            }
        }
    }
}

