/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.render;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.render.RenderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreRenderer
extends Renderer {
    public static final char CHAR_UNDEFINED = '\uffff';
    public static final int NO_CHILD_INDEX = -1;

    protected CoreRenderer() {
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String toResourceUri(FacesContext fc, Object o) {
        if (o == null) {
            return null;
        }
        String uri = o.toString();
        if (uri.startsWith("//")) {
            return uri.substring(1);
        }
        return fc.getApplication().getViewHandler().getResourceURL(fc, uri);
    }

    public static String toActionUri(FacesContext fc, Object o) {
        if (o == null) {
            return null;
        }
        String uri = o.toString();
        if (uri.startsWith("//")) {
            return uri.substring(1);
        }
        return fc.getApplication().getViewHandler().getActionURL(fc, uri);
    }

    public static String toUri(Object o) {
        return CoreRenderer.toResourceUri(FacesContext.getCurrentInstance(), o);
    }

    public static int toInt(Object o) {
        return ((Number)o).intValue();
    }

    public static long toLong(Object o) {
        return ((Number)o).longValue();
    }

    public static char toChar(Object o) {
        if (o == null) {
            return '\uffff';
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        CharSequence cs = o instanceof CharSequence ? (CharSequence)o : o.toString();
        if (cs.length() == 0) {
            return '\uffff';
        }
        return cs.charAt(0);
    }

    public final void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!this.getRendersChildren()) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            if (arc == null) {
                throw new IllegalStateException("No RenderingContext");
            }
            FacesBean bean = this.getFacesBean(component);
            this.encodeBegin(context, arc, component, bean);
        }
    }

    public final void encodeChildren(FacesContext context, UIComponent component) {
    }

    public final void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        if (arc == null) {
            throw new IllegalStateException("No RenderingContext");
        }
        FacesBean bean = this.getFacesBean(component);
        if (this.getRendersChildren()) {
            this.encodeAll(context, arc, component, bean);
        } else {
            this.encodeEnd(context, arc, component, bean);
        }
    }

    protected void encodeBegin(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getRendersChildren()) {
            throw new IllegalStateException();
        }
    }

    protected void encodeEnd(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getRendersChildren()) {
            throw new IllegalStateException();
        }
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!this.getRendersChildren()) {
            throw new IllegalStateException();
        }
    }

    protected void encodeChild(FacesContext context, UIComponent child) throws IOException {
        assert (child.isRendered());
        child.encodeBegin(context);
        if (child.getRendersChildren()) {
            child.encodeChildren(context);
        } else if (child.getChildCount() > 0) {
            for (UIComponent subChild : child.getChildren()) {
                RenderUtils.encodeRecursive(context, subChild);
            }
        }
        child.encodeEnd(context);
    }

    protected void encodeAllChildren(FacesContext context, UIComponent component) throws IOException {
        int childCount = component.getChildCount();
        if (childCount == 0) {
            return;
        }
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            this.encodeChild(context, child);
        }
    }

    protected void delegateRenderer(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, CoreRenderer renderer) throws IOException {
        if (!renderer.getRendersChildren()) {
            throw new IllegalStateException();
        }
        renderer.encodeAll(context, arc, component, bean);
    }

    protected void delegateRendererBegin(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, CoreRenderer renderer) throws IOException {
        if (renderer.getRendersChildren()) {
            throw new IllegalStateException();
        }
        renderer.encodeBegin(context, arc, component, bean);
    }

    protected void delegateRendererEnd(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, CoreRenderer renderer) throws IOException {
        if (renderer.getRendersChildren()) {
            throw new IllegalStateException();
        }
        renderer.encodeEnd(context, arc, component, bean);
    }

    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeAttribute("id", (Object)clientId, "id");
        }
    }

    protected String getClientId(FacesContext context, UIComponent component) {
        return component.getClientId(context);
    }

    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        String id = component.getId();
        if (id == null) {
            return false;
        }
        return !id.startsWith("_id");
    }

    protected boolean skipDecode(FacesContext context) {
        return false;
    }

    protected FacesBean getFacesBean(UIComponent component) {
        return ((UIXComponent)component).getFacesBean();
    }

    protected static final Object getRenderingProperty(RenderingContext arc, Object key) {
        return arc.getProperties().get(key);
    }

    protected static final Object setRenderingProperty(RenderingContext arc, Object key, Object value) {
        return arc.getProperties().put(key, value);
    }

    public static UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = component.getFacet(name);
        if (facet == null || !facet.isRendered()) {
            return null;
        }
        return facet;
    }

    public static boolean hasRenderedChildren(UIComponent component) {
        int count = component.getChildCount();
        if (count == 0) {
            return false;
        }
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            return true;
        }
        return false;
    }

    public static int getRenderedChildCount(UIComponent component) {
        int count = component.getChildCount();
        if (count == 0) {
            return 0;
        }
        int total = 0;
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            ++total;
        }
        return total;
    }

    public static int getNextRenderedChildIndex(List<UIComponent> components, int afterChildIndex) {
        int childIndex = afterChildIndex + 1;
        ListIterator<UIComponent> iter = components.listIterator(childIndex);
        while (iter.hasNext()) {
            if (((UIComponent)iter.next()).isRendered()) {
                return childIndex;
            }
            ++childIndex;
        }
        return -1;
    }

    public static boolean isDesktop(RenderingContext arc) {
        return arc.getAgent().getType().equals(Agent.TYPE_DESKTOP);
    }

    public static boolean isPDA(RenderingContext arc) {
        return arc.getAgent().getType().equals(Agent.TYPE_PDA);
    }

    public static boolean isIE(RenderingContext arc) {
        return arc.getAgent().getAgentName().equals("ie");
    }

    public static boolean isGecko(RenderingContext arc) {
        return arc.getAgent().getAgentName().equals("gecko");
    }

    public static boolean isInaccessibleMode(RenderingContext arc) {
        return arc.getAccessibilityMode() == RequestContext.Accessibility.INACCESSIBLE;
    }

    public static boolean isScreenReaderMode(RenderingContext arc) {
        return arc.getAccessibilityMode() == RequestContext.Accessibility.SCREEN_READER;
    }

    protected void renderEncodedActionURI(FacesContext context, String name, Object value) throws IOException {
        if (value != null) {
            value = context.getExternalContext().encodeActionURL(value.toString());
            context.getResponseWriter().writeURIAttribute(name, value, null);
        }
    }

    protected void renderEncodedResourceURI(FacesContext context, String name, Object value) throws IOException {
        if (value != null) {
            value = context.getExternalContext().encodeResourceURL(value.toString());
            context.getResponseWriter().writeURIAttribute(name, value, null);
        }
    }

    public static void renderStyleClass(FacesContext context, RenderingContext arc, String styleClass) throws IOException {
        if (styleClass != null) {
            styleClass = arc.getStyleClass(styleClass);
            context.getResponseWriter().writeAttribute("class", (Object)styleClass, null);
        }
    }

    public static void renderStyleClasses(FacesContext context, RenderingContext arc, String[] styleClasses) throws IOException {
        int length = 0;
        for (int i = 0; i < styleClasses.length; ++i) {
            if (styleClasses[i] == null) continue;
            String styleClass = arc.getStyleClass(styleClasses[i]);
            if (styleClass != null) {
                length += styleClass.length() + 1;
            }
            styleClasses[i] = styleClass;
        }
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < styleClasses.length; ++i) {
            if (styleClasses[i] == null) continue;
            if (builder.length() != 0) {
                builder.append(' ');
            }
            builder.append(styleClasses[i]);
        }
        context.getResponseWriter().writeAttribute("class", (Object)builder.toString(), null);
    }
}

