/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.render;

import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.UIXForm;

public class RenderUtils {
    private RenderUtils() {
    }

    public static void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            component.encodeBegin(context);
            if (component.getRendersChildren()) {
                component.encodeChildren(context);
            } else if (component.getChildCount() > 0) {
                for (UIComponent child : component.getChildren()) {
                    RenderUtils.encodeRecursive(context, child);
                }
            }
            component.encodeEnd(context);
        }
    }

    public static String getFormId(FacesContext context, UIComponent component) {
        UIComponent form = null;
        while (component != null) {
            if (component instanceof UIForm || component instanceof UIXForm) {
                form = component;
                break;
            }
            component = component.getParent();
        }
        if (form == null) {
            return null;
        }
        return form.getClientId(context);
    }

    public static String getRelativeId(FacesContext context, UIComponent from, String relativeId) {
        if (relativeId == null || relativeId.length() == 0) {
            return null;
        }
        if (relativeId.charAt(0) == ':') {
            return relativeId.substring(1);
        }
        UIComponent parentNC = RenderUtils._getParentNamingContainer(from.getParent());
        if (parentNC == null) {
            return relativeId;
        }
        return parentNC.getClientId(context) + ':' + relativeId;
    }

    private static UIComponent _getParentNamingContainer(UIComponent from) {
        while (from != null) {
            if (from instanceof NamingContainer) {
                return from;
            }
            from = from.getParent();
        }
        return null;
    }
}

