/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.IOException;
import java.net.URL;
import org.apache.myfaces.trinidad.resource.ResourceLoader;

public class ClassLoaderResourceLoader
extends ResourceLoader {
    private final String _resourcePrefix;

    public ClassLoaderResourceLoader() {
        this((String)null);
    }

    public ClassLoaderResourceLoader(ResourceLoader parent) {
        this(null, parent);
    }

    public ClassLoaderResourceLoader(String rootPackage) {
        this._resourcePrefix = ClassLoaderResourceLoader._getResourcePrefix(rootPackage);
    }

    public ClassLoaderResourceLoader(String rootPackage, ResourceLoader parent) {
        super(parent);
        this._resourcePrefix = ClassLoaderResourceLoader._getResourcePrefix(rootPackage);
    }

    protected URL findResource(String path) throws IOException {
        if (this._resourcePrefix != null) {
            path = path.charAt(0) == '/' ? this._resourcePrefix + path : this._resourcePrefix + "/" + path;
        } else if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return this.getClassLoader().getResource(path);
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String _getResourcePrefix(String rootPackage) {
        if (rootPackage == null || rootPackage.length() == 0) {
            return null;
        }
        return rootPackage.replace('.', '/');
    }
}

