/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.myfaces.trinidad.resource.ResourceLoader;

public class DirectoryResourceLoader
extends ResourceLoader {
    private final File _directory;

    public DirectoryResourceLoader(File directory) {
        if (directory == null) {
            throw new NullPointerException();
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this._directory = directory;
    }

    public DirectoryResourceLoader(File directory, ResourceLoader parent) {
        super(parent);
        if (directory == null) {
            throw new NullPointerException();
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this._directory = directory;
    }

    protected URL findResource(String path) throws IOException {
        File file;
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        boolean isContained = this._directory.compareTo(file = new File(this._directory, path).getCanonicalFile()) <= 0;
        return isContained && file.exists() ? file.toURI().toURL() : null;
    }
}

