/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.trinidad.resource.ResourceLoader;

public class ProxyResourceLoader
extends ResourceLoader {
    public ProxyResourceLoader(ResourceLoader parent) {
        super(parent);
    }

    public URL getResource(String path) throws IOException {
        URL url = super.getResource(path);
        return url != null ? new URL("proxy", null, -1, url.toExternalForm(), new ProxyURLStreamHandler(url)) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ProxyURLConnection
    extends URLConnection {
        private final URLConnection _delegate;

        public ProxyURLConnection(URL url, URL proxied) throws IOException {
            super(url);
            this._delegate = proxied.openConnection();
        }

        @Override
        public void addRequestProperty(String key, String value) {
            this.getURLConnection().addRequestProperty(key, value);
        }

        @Override
        public void connect() throws IOException {
            this.getURLConnection().connect();
        }

        @Override
        public boolean getAllowUserInteraction() {
            return this.getURLConnection().getAllowUserInteraction();
        }

        @Override
        public Object getContent() throws IOException {
            return this.getURLConnection().getContent();
        }

        public Object getContent(Class[] classes) throws IOException {
            return this.getURLConnection().getContent(classes);
        }

        @Override
        public String getContentEncoding() {
            return this.getURLConnection().getContentEncoding();
        }

        @Override
        public int getContentLength() {
            return this.getURLConnection().getContentLength();
        }

        @Override
        public String getContentType() {
            return ProxyResourceLoader.this.getContentType(this.getURLConnection());
        }

        @Override
        public long getDate() {
            return this.getURLConnection().getDate();
        }

        @Override
        public boolean getDefaultUseCaches() {
            return this.getURLConnection().getDefaultUseCaches();
        }

        @Override
        public boolean getDoInput() {
            return this.getURLConnection().getDoInput();
        }

        @Override
        public boolean getDoOutput() {
            return this.getURLConnection().getDoOutput();
        }

        @Override
        public long getExpiration() {
            return this.getURLConnection().getExpiration();
        }

        @Override
        public String getHeaderField(int n) {
            return this.getURLConnection().getHeaderField(n);
        }

        @Override
        public String getHeaderField(String name) {
            return this.getURLConnection().getHeaderField(name);
        }

        @Override
        public long getHeaderFieldDate(String name, long Default) {
            return this.getURLConnection().getHeaderFieldDate(name, Default);
        }

        @Override
        public int getHeaderFieldInt(String name, int Default) {
            return this.getURLConnection().getHeaderFieldInt(name, Default);
        }

        @Override
        public String getHeaderFieldKey(int n) {
            return this.getURLConnection().getHeaderFieldKey(n);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return this.getURLConnection().getHeaderFields();
        }

        @Override
        public long getIfModifiedSince() {
            return this.getURLConnection().getIfModifiedSince();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.getURLConnection().getInputStream();
        }

        @Override
        public long getLastModified() {
            return this.getURLConnection().getLastModified();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.getURLConnection().getOutputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.getURLConnection().getPermission();
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            return this.getURLConnection().getRequestProperties();
        }

        @Override
        public String getRequestProperty(String key) {
            return this.getURLConnection().getRequestProperty(key);
        }

        @Override
        public boolean getUseCaches() {
            return this.getURLConnection().getUseCaches();
        }

        @Override
        public void setAllowUserInteraction(boolean allowuserinteraction) {
            this.getURLConnection().setAllowUserInteraction(allowuserinteraction);
        }

        @Override
        public void setDefaultUseCaches(boolean defaultusecaches) {
            this.getURLConnection().setDefaultUseCaches(defaultusecaches);
        }

        @Override
        public void setDoInput(boolean doinput) {
            this.getURLConnection().setDoInput(doinput);
        }

        @Override
        public void setDoOutput(boolean dooutput) {
            this.getURLConnection().setDoOutput(dooutput);
        }

        @Override
        public void setIfModifiedSince(long ifmodifiedsince) {
            this.getURLConnection().setIfModifiedSince(ifmodifiedsince);
        }

        @Override
        public void setRequestProperty(String key, String value) {
            this.getURLConnection().setRequestProperty(key, value);
        }

        @Override
        public void setUseCaches(boolean usecaches) {
            this.getURLConnection().setUseCaches(usecaches);
        }

        protected URLConnection getURLConnection() {
            return this._delegate;
        }
    }

    private class ProxyURLStreamHandler
    extends URLStreamHandler {
        private final URL _proxied;

        public ProxyURLStreamHandler(URL proxied) {
            this._proxied = proxied;
        }

        protected URLConnection openConnection(URL url) throws IOException {
            return new ProxyURLConnection(url, this._proxied);
        }
    }
}

