/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.myfaces.trinidad.resource.DynamicResourceLoader;
import org.apache.myfaces.trinidad.resource.ResourceLoader;

public abstract class StringContentResourceLoader
extends DynamicResourceLoader {
    public StringContentResourceLoader(String path) {
        super(path);
    }

    public StringContentResourceLoader(String path, ResourceLoader parent) {
        super(path, parent);
    }

    protected String getContentType(String path) {
        return "text";
    }

    protected abstract String getString(String var1) throws IOException;

    protected URL getURL(String path) throws IOException {
        return new URL("dynamic", null, -1, path, new StringContentURLStreamHandler(this.getString(path), this.getContentType(path)));
    }

    private class StringContentURLConnection
    extends URLConnection {
        private byte[] _buff;
        private String _contentType;

        public StringContentURLConnection(URL url, byte[] buff, String contentType) {
            super(url);
            this.connected = false;
            this._buff = buff;
            this._contentType = contentType;
        }

        public void connect() throws IOException {
            this.connected = true;
        }

        public String getContentEncoding() {
            return null;
        }

        public int getContentLength() {
            return this._buff.length;
        }

        public String getContentType() {
            return this._contentType;
        }

        public String getHeaderField(String name) {
            if ("content-encoding".equals(name)) {
                return this.getContentEncoding();
            }
            if ("content-length".equals(name)) {
                return String.valueOf(this.getContentLength());
            }
            if ("content-type".equals(name)) {
                return this.getContentType();
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this._buff);
        }
    }

    private class StringContentURLStreamHandler
    extends URLStreamHandler {
        private byte[] _buff;
        private String _contentType;

        public StringContentURLStreamHandler(String content, String contentType) {
            this._buff = content.getBytes();
            this._contentType = contentType;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new StringContentURLConnection(u, this._buff, this._contentType);
        }
    }
}

