/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ComponentUtils {
    private ComponentUtils() {
    }

    public static Object resolveObject(Object value, Object defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean resolveBoolean(Object value, boolean defaultValue) {
        if (defaultValue) {
            return !Boolean.FALSE.equals(value);
        }
        return Boolean.TRUE.equals(value);
    }

    public static boolean resolveBoolean(Object value) {
        return Boolean.TRUE.equals(value);
    }

    public static int resolveInteger(Object value) {
        return ComponentUtils.resolveInteger(value, 0);
    }

    public static int resolveInteger(Object value, int defaultValue) {
        return value != null ? ((Number)value).intValue() : defaultValue;
    }

    public static long resolveLong(Object value) {
        return ComponentUtils.resolveLong(value, 0L);
    }

    public static long resolveLong(Object value, long defaultValue) {
        return value != null ? ((Number)value).longValue() : defaultValue;
    }

    public static double resolveDouble(Object value) {
        return ComponentUtils.resolveDouble(value, 0.0);
    }

    public static double resolveDouble(Object value, double defaultValue) {
        return value != null ? ((Number)value).doubleValue() : defaultValue;
    }

    public static char resolveCharacter(Character value) {
        return ComponentUtils.resolveCharacter(value, '\u0000');
    }

    public static char resolveCharacter(Character value, char defaultValue) {
        return value != null ? value.charValue() : defaultValue;
    }

    public static String resolveString(Object value) {
        return value != null ? value.toString() : null;
    }

    public static String resolveString(Object value, String defaultValue) {
        return value != null ? value.toString() : defaultValue;
    }

    public static String[] resolveStringArray(Object value) {
        return ComponentUtils.resolveStringArray(value, null);
    }

    public static String[] resolveStringArray(Object value, String[] defaultValue) {
        return value != null ? (String[])value : defaultValue;
    }

    public static Date resolveDate(Object value) {
        return ComponentUtils.resolveDate(value, null);
    }

    public static Date resolveDate(Object value, Date defaultValue) {
        return value != null ? (Date)value : defaultValue;
    }

    public static TimeZone resolveTimeZone(Object value) {
        return ComponentUtils.resolveTimeZone(value, null);
    }

    public static TimeZone resolveTimeZone(Object value, TimeZone defaultValue) {
        return value != null ? (TimeZone)value : defaultValue;
    }

    public static Locale resolveLocale(Object value) {
        return ComponentUtils.resolveLocale(value, null);
    }

    public static Locale resolveLocale(Object value, Locale defaultValue) {
        return value != null ? (Locale)value : defaultValue;
    }

    public static Throwable unwrap(Throwable t) {
        Throwable unwrap;
        while ((unwrap = t.getCause()) != null) {
            t = unwrap;
        }
        return t;
    }
}

