/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.ErrorMessages;
import org.apache.myfaces.trinidad.util.FastMessageFormat;
import org.apache.myfaces.trinidad.util.LabeledFacesMessage;
import org.apache.myfaces.trinidad.util.LocaleUtils;

public class MessageFactory {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(MessageFactory.class);

    private MessageFactory() {
    }

    public static FacesMessage getMessage(Throwable error) {
        _LOG.fine(error);
        Throwable unwrap = ComponentUtils.unwrap(error);
        String detail = unwrap.getLocalizedMessage();
        if (detail == null) {
            detail = unwrap.getClass().getName();
            _LOG.warning(error);
        }
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, detail, detail);
        return message;
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object[] parameters) {
        return MessageFactory.getMessage(context, FacesMessage.SEVERITY_ERROR, messageId, parameters, null);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object[] parameters, UIComponent component) {
        return MessageFactory._createFacesMessage(context, FacesMessage.SEVERITY_ERROR, messageId, parameters, MessageFactory._getLabel(component));
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object[] parameters, Object label) {
        return MessageFactory._createFacesMessage(context, FacesMessage.SEVERITY_ERROR, messageId, parameters, label);
    }

    public static FacesMessage getMessage(FacesContext context, FacesMessage.Severity severity, String messageId, Object[] parameters) {
        return MessageFactory.getMessage(context, severity, messageId, parameters, null);
    }

    public static FacesMessage getMessage(FacesContext context, FacesMessage.Severity severity, String messageId, Object[] parameters, UIComponent component) {
        return MessageFactory._createFacesMessage(context, severity, messageId, parameters, MessageFactory._getLabel(component));
    }

    public static FacesMessage getMessage(FacesContext context, String messageId) {
        return MessageFactory.getMessage(context, messageId, (Object[])null, (UIComponent)null);
    }

    public static String getString(FacesContext context, String messageId) {
        return LocaleUtils.__getSummaryString(context, messageId);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, UIComponent component) {
        return MessageFactory.getMessage(context, messageId, (Object[])null, component);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object parameter, Object label) {
        return MessageFactory.getMessage(context, messageId, new Object[]{parameter}, label);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object parameter) {
        return MessageFactory.getMessage(context, messageId, new Object[]{parameter});
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object customMessagePattern, Object[] parameters) {
        return MessageFactory.getMessage(context, messageId, customMessagePattern, parameters, null);
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object customMessagePattern, Object[] parameters, UIComponent component) {
        return MessageFactory.getMessage(context, messageId, customMessagePattern, parameters, MessageFactory._getLabel(component));
    }

    public static FacesMessage getMessage(FacesContext context, String messageId, Object customMessagePattern, Object[] parameters, Object label) {
        if (null != customMessagePattern) {
            String summary = LocaleUtils.__getSummaryString(context, messageId);
            ErrorMessages msgs = MessageFactory._getErrorMessage(summary, customMessagePattern, parameters);
            return MessageFactory._createFacesMessage(FacesMessage.SEVERITY_ERROR, msgs, label);
        }
        return MessageFactory._createFacesMessage(context, FacesMessage.SEVERITY_ERROR, messageId, parameters, label);
    }

    private static FacesMessage _createFacesMessage(FacesContext context, FacesMessage.Severity severity, String messageId, Object[] parameters, Object label) {
        ErrorMessages errMsgs = LocaleUtils.__getErrorMessages(context, messageId);
        ErrorMessages formattedErrMsgs = MessageFactory._getBindingOrFormattedErrorMessages(errMsgs, parameters);
        return MessageFactory._createFacesMessage(severity, formattedErrMsgs, label);
    }

    private static FacesMessage _createFacesMessage(FacesMessage.Severity severity, ErrorMessages messageStrings, Object label) {
        if (messageStrings instanceof BindingErrorMessages) {
            return new BindingFacesMessage(severity, messageStrings, label);
        }
        String summary = messageStrings.getMessage();
        String detail = messageStrings.getDetailMessage();
        return new LabeledFacesMessage(severity, summary, detail, label);
    }

    private static Object[] _getProcessedBindings(FacesContext facesContext, Object[] parameters) {
        FacesContext context = facesContext;
        Object[] resolvedParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object o = parameters[i];
            if (o instanceof ValueBinding) {
                if (context == null) {
                    context = FacesContext.getCurrentInstance();
                }
                o = ((ValueBinding)o).getValue(context);
            }
            resolvedParameters[i] = o;
        }
        return resolvedParameters;
    }

    private static String _getFormattedString(String pattern, Object[] parameters) {
        if (parameters == null) {
            return pattern;
        }
        FastMessageFormat formatter = new FastMessageFormat(pattern);
        String fmtedMsgStr = formatter.format(parameters);
        return fmtedMsgStr;
    }

    private static boolean _containsBinding(Object[] parameters) {
        if (parameters == null) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!(parameters[i] instanceof ValueBinding)) continue;
            return true;
        }
        return false;
    }

    private static ErrorMessages _getErrorMessage(String summary, Object customMessagePattern, Object[] parameters) {
        MessageFactory._assertIsValidCustomMessageType(customMessagePattern);
        boolean isCustomMsgValueBound = customMessagePattern instanceof ValueBinding;
        boolean containsBinding = MessageFactory._containsBinding(parameters);
        if (isCustomMsgValueBound || containsBinding) {
            if (!isCustomMsgValueBound) {
                String customMesg = (String)customMessagePattern;
                return new BindingErrorMessages(summary, customMesg, parameters);
            }
            ValueBinding customMessage = (ValueBinding)customMessagePattern;
            return new CustomDetailErrorMessage(summary, customMessage, parameters, containsBinding);
        }
        String detailMsgPattern = (String)customMessagePattern;
        FormattedErrorMessages errorMsg = new FormattedErrorMessages(summary, detailMsgPattern, parameters);
        return errorMsg;
    }

    private static Object _getLabel(UIComponent component) {
        ValueBinding o = null;
        if (component != null && (o = (ValueBinding)component.getAttributes().get("label")) == null) {
            o = component.getValueBinding("label");
        }
        return o;
    }

    private static void _assertIsValidCustomMessageType(Object customMessagePattern) {
        if (!(customMessagePattern instanceof ValueBinding) && !(customMessagePattern instanceof String)) {
            throw new IllegalArgumentException("custom message should be of type ValueBinding or String");
        }
    }

    private static ErrorMessages _getBindingOrFormattedErrorMessages(ErrorMessages unFormattedErrorMessages, Object[] parameters) {
        if (!MessageFactory._containsBinding(parameters)) {
            return new FormattedErrorMessages(unFormattedErrorMessages.getMessage(), unFormattedErrorMessages.getDetailMessage(), parameters);
        }
        return new BindingErrorMessages(unFormattedErrorMessages.getMessage(), unFormattedErrorMessages.getDetailMessage(), parameters);
    }

    private static class FormattedErrorMessages
    extends ErrorMessages {
        Object[] _parameters;

        FormattedErrorMessages(String summary, String detail, Object[] parameters) {
            super(summary, detail);
            this._parameters = parameters;
        }

        public String getMessage() {
            return MessageFactory._getFormattedString(super.getMessage(), this._parameters);
        }

        public String getDetailMessage() {
            return MessageFactory._getFormattedString(super.getDetailMessage(), this._parameters);
        }
    }

    private static class CustomDetailErrorMessage
    extends BindingErrorMessages {
        private ValueBinding _customDetailErrorMessage;
        private boolean _hasBoundParameters;

        CustomDetailErrorMessage(String messageFormat, ValueBinding customDetailErrorMessage, Object[] parameters, boolean hasBoundParameters) {
            super(messageFormat, null, parameters);
            this._customDetailErrorMessage = customDetailErrorMessage;
            this._hasBoundParameters = hasBoundParameters;
        }

        public String getDetailMessage() {
            FacesContext context = FacesContext.getCurrentInstance();
            String detailMsgPattern = (String)this._customDetailErrorMessage.getValue(context);
            if (detailMsgPattern == null) {
                detailMsgPattern = this._customDetailErrorMessage.getExpressionString();
                detailMsgPattern = '\'' + detailMsgPattern + '\'';
            }
            Object[] params = super.getParameters();
            if (this._hasBoundParameters) {
                params = this.getResolvedParameters();
            }
            return MessageFactory._getFormattedString(detailMsgPattern, params);
        }
    }

    private static class BindingErrorMessages
    extends ErrorMessages {
        private Object[] _parameters;
        private Object[] _resolvedParameters;

        BindingErrorMessages(String messageFormat, String detailMessageFormat, Object[] parameters) {
            super(messageFormat, detailMessageFormat);
            this._parameters = parameters;
            if (parameters == null) {
                throw new NullPointerException();
            }
        }

        public String getMessage() {
            String pattern = super.getMessage();
            this._resolveBindings();
            return MessageFactory._getFormattedString(pattern, this._resolvedParameters);
        }

        public String getDetailMessage() {
            String pattern = super.getDetailMessage();
            this._resolveBindings();
            return MessageFactory._getFormattedString(pattern, this._resolvedParameters);
        }

        private void _resolveBindings() {
            if (this._resolvedParameters == null) {
                this._resolvedParameters = MessageFactory._getProcessedBindings(null, this._parameters);
            }
        }

        protected final Object[] getResolvedParameters() {
            this._resolveBindings();
            return this._resolvedParameters;
        }

        protected final Object[] getParameters() {
            return this._parameters;
        }
    }

    private static class BindingFacesMessage
    extends LabeledFacesMessage {
        private final ErrorMessages _messageStrings;

        public BindingFacesMessage(FacesMessage.Severity severity, ErrorMessages messageStrings, Object label) {
            super(severity, null, null, label);
            this._messageStrings = messageStrings;
        }

        public String getDetail() {
            return this._messageStrings.getDetailMessage();
        }

        public String getSummary() {
            return this._messageStrings.getMessage();
        }

        public void setDetail() {
            throw new UnsupportedOperationException();
        }

        public void setSummary() {
            throw new UnsupportedOperationException();
        }
    }
}

