/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.validator;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.model.DateListProvider;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidad.validator.ValidatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRestrictionValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "org.apache.myfaces.trinidad.DateRestriction";
    public static final String DAY_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DateRestrictionValidator.DAY";
    public static final String MONTH_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DateRestrictionValidator.MONTH";
    public static final String WEEKDAY_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DateRestrictionValidator.WEEKDAY";
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _INVALID_MONTHS = _TYPE.registerKey("invalidMonths", String[].class);
    private static final PropertyKey _INVALID_DAYS_OF_WEEK = _TYPE.registerKey("invalidDaysOfWeek", String[].class);
    private static final PropertyKey _INVALID_DAYS = _TYPE.registerKey("invalidDays", DateListProvider.class);
    private static final PropertyKey _INVALID_MONTHS_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailInvalidMonths", String.class);
    private static final PropertyKey _INVALID_DAYS_OF_WEEK_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailInvalidDaysOfWeek", String.class);
    private static final PropertyKey _INVALID_DAYS_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailInvalidDays", String.class);
    private static final PropertyKey _HINT_WEEK_KEY = _TYPE.registerKey("hintWeek", String.class);
    private static final PropertyKey _HINT_MONTH_KEY = _TYPE.registerKey("hintMonth", String.class);
    private FacesBean _facesBean = ValidatorUtils.getFacesBean(_TYPE);
    private boolean _transientValue = false;
    private Map<Integer, String> _dayMap = null;
    private Map<Integer, String> _monthMap = null;

    public DateRestrictionValidator() {
        this._initMaps();
    }

    public final String[] getInvalidMonths() {
        return (String[])this._facesBean.getProperty(_INVALID_MONTHS);
    }

    public final void setInvalidMonths(String[] invalidMonths) {
        this._facesBean.setProperty(_INVALID_MONTHS, invalidMonths);
    }

    public final String[] getInvalidDaysOfWeek() {
        return (String[])this._facesBean.getProperty(_INVALID_DAYS_OF_WEEK);
    }

    public final void setInvalidDaysOfWeek(String[] invalidDaysOfWeek) {
        this._facesBean.setProperty(_INVALID_DAYS_OF_WEEK, invalidDaysOfWeek);
    }

    public final DateListProvider getInvalidDays() {
        return (DateListProvider)this._facesBean.getProperty(_INVALID_DAYS);
    }

    public final void setInvalidDays(DateListProvider invalidDays) {
        this._facesBean.setProperty(_INVALID_DAYS, invalidDays);
    }

    public final String getMessageDetailInvalidMonths() {
        Object messageDetailInvalidMonths = this._facesBean.getProperty(_INVALID_MONTHS_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(messageDetailInvalidMonths);
    }

    public final void setMessageDetailInvalidMonths(String invalidMonths) {
        this._facesBean.setProperty(_INVALID_MONTHS_MESSAGE_DETAIL_KEY, invalidMonths);
    }

    public final String getMessageDetailInvalidDaysOfWeek() {
        Object messageDetailInvalidDaysOfWeek = this._facesBean.getProperty(_INVALID_DAYS_OF_WEEK_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(messageDetailInvalidDaysOfWeek);
    }

    public final void setMessageDetailInvalidDaysOfWeek(String invalidDaysOfWeek) {
        this._facesBean.setProperty(_INVALID_DAYS_OF_WEEK_MESSAGE_DETAIL_KEY, invalidDaysOfWeek);
    }

    public final String getMessageDetailInvalidDays() {
        Object messageDetailInvalidDays = this._facesBean.getProperty(_INVALID_DAYS_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(messageDetailInvalidDays);
    }

    public final void setMessageDetailInvalidDays(String invalidDays) {
        this._facesBean.setProperty(_INVALID_DAYS_MESSAGE_DETAIL_KEY, invalidDays);
    }

    public void setHintInvalidDaysOfWeek(String hintWeek) {
        this._facesBean.setProperty(_HINT_WEEK_KEY, hintWeek);
    }

    public String getHintInvalidDaysOfWeek() {
        Object obj = this._facesBean.getProperty(_HINT_WEEK_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintInvalidMonths(String hintMonth) {
        this._facesBean.setProperty(_HINT_MONTH_KEY, hintMonth);
    }

    public String getHintInvalidMonths() {
        Object obj = this._facesBean.getProperty(_HINT_MONTH_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException("FacesContext or Component is null");
        }
        if (value != null) {
            Calendar calendar = this.getCalendar();
            calendar.setTime(DateRestrictionValidator.getDateValue(value));
            Date convertedDate = calendar.getTime();
            String weekday = this._dayMap.get(calendar.get(7));
            if (this._getInvalidDaysOfWeek().contains(weekday)) {
                throw new ValidatorException(this._getWrongWeekDayMessage(context, component, value, weekday));
            }
            String month = this._monthMap.get(calendar.get(2));
            if (this._getInvalidMonths().contains(month)) {
                throw new ValidatorException(this._getWrongMonthMessage(context, component, value, month));
            }
            DateListProvider dlp = this.getInvalidDays();
            List<Date> dates = null;
            if (dlp != null) {
                dates = dlp.getDateList(context, calendar, calendar.getTime(), calendar.getTime());
            }
            if (dates != null) {
                for (Date date : dates) {
                    if (date.before(convertedDate) || date.after(convertedDate)) continue;
                    throw new ValidatorException(this._getWrongDayMessage(context, component, value, date));
                }
            }
        }
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public boolean isTransient() {
        return this._transientValue;
    }

    public void setTransient(boolean transientValue) {
        this._transientValue = transientValue;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ValidatorUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ValidatorUtils.getValueBinding(this._facesBean, name);
    }

    public boolean equals(Object o) {
        if (o instanceof DateRestrictionValidator) {
            DateRestrictionValidator that = (DateRestrictionValidator)o;
            if (this._transientValue == that._transientValue && ValidatorUtils.equals(this.getInvalidDays(), that.getInvalidDays()) && ValidatorUtils.equals(this.getInvalidDaysOfWeek(), that.getInvalidDaysOfWeek()) && ValidatorUtils.equals(this.getInvalidMonths(), that.getInvalidMonths()) && ValidatorUtils.equals(this.getMessageDetailInvalidDays(), that.getMessageDetailInvalidDays()) && ValidatorUtils.equals(this.getMessageDetailInvalidDaysOfWeek(), that.getMessageDetailInvalidDaysOfWeek()) && ValidatorUtils.equals(this.getMessageDetailInvalidMonths(), that.getMessageDetailInvalidMonths())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        DateListProvider days = this.getInvalidDays();
        String[] daysOfWeek = this.getInvalidDaysOfWeek();
        String[] month = this.getInvalidMonths();
        String msgDetDays = this.getMessageDetailInvalidDays();
        String msgDetDaysOfWeek = this.getMessageDetailInvalidDaysOfWeek();
        String msgDetMonth = this.getMessageDetailInvalidMonths();
        result = 37 * result + (days == null ? 0 : days.hashCode());
        result = 37 * result + (daysOfWeek == null ? 0 : daysOfWeek.hashCode());
        result = 37 * result + (month == null ? 0 : month.hashCode());
        result = 37 * result + (this._transientValue ? 0 : 1);
        result = 37 * result + (msgDetDays == null ? 0 : msgDetDays.hashCode());
        result = 37 * result + (msgDetDaysOfWeek == null ? 0 : msgDetDaysOfWeek.hashCode());
        result = 37 * result + (msgDetMonth == null ? 0 : msgDetMonth.hashCode());
        return result;
    }

    private Converter _getConverter(FacesContext context, UIComponent component) {
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null) {
            converter = context.getApplication().createConverter("javax.faces.DateTime");
        }
        assert (converter != null);
        return converter;
    }

    protected Calendar getCalendar() {
        TimeZone tz = null;
        RequestContext rctx = RequestContext.getCurrentInstance();
        tz = rctx != null ? rctx.getTimeZone() : TimeZone.getDefault();
        return Calendar.getInstance(tz);
    }

    protected static Date getDateValue(Object value) throws IllegalArgumentException {
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException("'value' is not of type java.util.Date");
    }

    private FacesMessage _getWrongWeekDayMessage(FacesContext context, UIComponent component, Object value, Object weekday) {
        Converter converter = this._getConverter(context, component);
        Object cValue = this._getConvertedValue(context, component, converter, value);
        Object cWeekday = this._getConvertedValue(context, component, converter, weekday);
        Object msg = this._getRawInvalidDaysOfWeekMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, cValue, cWeekday};
        return MessageFactory.getMessage(context, WEEKDAY_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawInvalidDaysOfWeekMessageDetail() {
        return this._facesBean.getRawProperty(_INVALID_DAYS_OF_WEEK_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getWrongMonthMessage(FacesContext context, UIComponent component, Object value, Object weekday) {
        Converter converter = this._getConverter(context, component);
        Object cValue = this._getConvertedValue(context, component, converter, value);
        Object cWeekday = this._getConvertedValue(context, component, converter, weekday);
        Object msg = this._getRawInvalidMonthMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, cValue, cWeekday};
        return MessageFactory.getMessage(context, MONTH_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawInvalidMonthMessageDetail() {
        return this._facesBean.getRawProperty(_INVALID_MONTHS_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getWrongDayMessage(FacesContext context, UIComponent component, Object value, Object day) {
        Converter converter = this._getConverter(context, component);
        Object cValue = this._getConvertedValue(context, component, converter, value);
        Object cDay = this._getConvertedValue(context, component, converter, day);
        Object msg = this._getRawInvalidDaysMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, cValue, cDay};
        return MessageFactory.getMessage(context, DAY_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawInvalidDaysMessageDetail() {
        return this._facesBean.getRawProperty(_INVALID_DAYS_MESSAGE_DETAIL_KEY);
    }

    private Object _getConvertedValue(FacesContext context, UIComponent component, Converter converter, Object value) {
        return converter.getAsString(context, component, value);
    }

    private final Set<String> _getInvalidMonths() {
        HashSet<String> monthSet = new HashSet<String>();
        String[] month = this.getInvalidMonths();
        if (month != null) {
            for (int i = 0; i < month.length; ++i) {
                monthSet.add(month[i].toLowerCase());
            }
        }
        return monthSet;
    }

    private final Set<String> _getInvalidDaysOfWeek() {
        HashSet<String> daysOfWeekSet = new HashSet<String>();
        String[] daysOfWeek = this.getInvalidDaysOfWeek();
        if (daysOfWeek != null) {
            for (int i = 0; i < daysOfWeek.length; ++i) {
                daysOfWeekSet.add(daysOfWeek[i].toLowerCase());
            }
        }
        return daysOfWeekSet;
    }

    private void _initMaps() {
        this._dayMap = new HashMap<Integer, String>();
        this._dayMap.put(1, "sun");
        this._dayMap.put(2, "mon");
        this._dayMap.put(3, "tue");
        this._dayMap.put(4, "wed");
        this._dayMap.put(5, "thu");
        this._dayMap.put(6, "fri");
        this._dayMap.put(7, "sat");
        this._monthMap = new HashMap<Integer, String>();
        this._monthMap.put(0, "jan");
        this._monthMap.put(1, "feb");
        this._monthMap.put(2, "mar");
        this._monthMap.put(3, "apr");
        this._monthMap.put(4, "may");
        this._monthMap.put(5, "jun");
        this._monthMap.put(6, "jul");
        this._monthMap.put(7, "aug");
        this._monthMap.put(8, "sep");
        this._monthMap.put(9, "oct");
        this._monthMap.put(10, "nov");
        this._monthMap.put(11, "dec");
    }
}

