/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.webapp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.CachingResourceLoader;
import org.apache.myfaces.trinidad.resource.DirectoryResourceLoader;
import org.apache.myfaces.trinidad.resource.ResourceLoader;
import org.apache.myfaces.trinidad.resource.ServletContextResourceLoader;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 4547362994406585148L;
    public static final String DEBUG_INIT_PARAM = "org.apache.myfaces.trinidad.resource.DEBUG";
    public static final long ONE_YEAR_MILLIS = 31363200000L;
    private static final Class[] _DECORATOR_SIGNATURE = new Class[]{ResourceLoader.class};
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ResourceServlet.class);
    private static final int _BUFFER_SIZE = 2048;
    private boolean _debug;
    private Map<String, ResourceLoader> _loaders;
    private FacesContextFactory _facesContextFactory;
    private Lifecycle _lifecycle;

    public void destroy() {
        this._loaders = null;
        this._facesContextFactory = null;
        this._lifecycle = null;
        super.destroy();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this._facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
        this._lifecycle = new _ResourceLifecycle();
        this._initDebug(config);
        this._loaders = new HashMap<String, ResourceLoader>();
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Configurator.disableConfiguratorServices(request);
        FacesContext context = this._facesContextFactory.getFacesContext((Object)this.getServletContext(), (Object)request, (Object)response, this._lifecycle);
        try {
            super.service(request, response);
        }
        catch (ServletException e) {
            _LOG.severe(e);
            throw e;
        }
        catch (IOException e) {
            if (!ResourceServlet._canIgnore(e)) {
                _LOG.severe(e);
            }
            throw e;
        }
        finally {
            context.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourcePath;
        ResourceLoader loader = this._getResourceLoader(request);
        URL url = loader.getResource(resourcePath = this.getResourcePath(request));
        if (url == null) {
            response.sendError(404);
            return;
        }
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(false);
        this._setHeaders(connection, response);
        InputStream in = connection.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        byte[] buffer = new byte[2048];
        try {
            ResourceServlet._pipeBytes(in, (OutputStream)out, buffer);
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            ResourceLoader loader = this._getResourceLoader(request);
            String resourcePath = this.getResourcePath(request);
            URL url = loader.getResource(resourcePath);
            if (url == null) {
                return super.getLastModified(request);
            }
            URLConnection connection = url.openConnection();
            connection.setDoInput(false);
            connection.setDoOutput(false);
            return connection.getLastModified();
        }
        catch (IOException e) {
            return super.getLastModified(request);
        }
    }

    protected String getResourcePath(HttpServletRequest request) {
        return request.getServletPath() + request.getPathInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceLoader _getResourceLoader(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        ResourceLoader loader = this._loaders.get(servletPath);
        if (loader == null) {
            try {
                String key = "META-INF/servlets/resources" + servletPath + ".resources";
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                URL url = cl.getResource(key);
                if (url != null) {
                    InputStreamReader r = new InputStreamReader(url.openStream());
                    BufferedReader br = new BufferedReader(r);
                    try {
                        String className = br.readLine().trim();
                        Class<?> clazz = cl.loadClass(className);
                        try {
                            Constructor<?> decorator = clazz.getConstructor(_DECORATOR_SIGNATURE);
                            ServletContext context = this.getServletContext();
                            File tempdir = (File)context.getAttribute("javax.servlet.context.tempdir");
                            DirectoryResourceLoader delegate = new DirectoryResourceLoader(tempdir);
                            loader = (ResourceLoader)decorator.newInstance(delegate);
                        }
                        catch (InvocationTargetException e) {
                            loader = (ResourceLoader)clazz.newInstance();
                        }
                        catch (NoSuchMethodException e) {
                            loader = (ResourceLoader)clazz.newInstance();
                        }
                    }
                    finally {
                        br.close();
                    }
                } else {
                    _LOG.warning("Unable to find ResourceLoader for ResourceServlet at servlet path:{0}\nCause: Could not find resource:{1}", new Object[]{servletPath, key});
                    loader = new ServletContextResourceLoader(this.getServletContext()){

                        public URL getResource(String path) throws IOException {
                            return super.getResource(path);
                        }
                    };
                }
                if (!this._debug) {
                    loader = new CachingResourceLoader(loader);
                }
            }
            catch (IllegalAccessException e) {
                loader = ResourceLoader.getNullResourceLoader();
            }
            catch (InstantiationException e) {
                loader = ResourceLoader.getNullResourceLoader();
            }
            catch (ClassNotFoundException e) {
                loader = ResourceLoader.getNullResourceLoader();
            }
            catch (IOException e) {
                loader = ResourceLoader.getNullResourceLoader();
            }
            this._loaders.put(servletPath, loader);
        }
        return loader;
    }

    private static void _pipeBytes(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int length;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
        }
    }

    private void _initDebug(ServletConfig config) {
        String debug = config.getInitParameter(DEBUG_INIT_PARAM);
        if (debug == null) {
            debug = config.getServletContext().getInitParameter(DEBUG_INIT_PARAM);
        }
        this._debug = "true".equalsIgnoreCase(debug);
        if (this._debug) {
            _LOG.info("Trinidad ResourceServlet is running in debug mode. Do not use in a production environment. See the org.apache.myfaces.trinidad.resource.DEBUG parameter in /WEB-INF/web.xml");
        }
    }

    private void _setHeaders(URLConnection connection, HttpServletResponse response) {
        long lastModified;
        String contentType = connection.getContentType();
        if (contentType == null || "content/unknown".equals(contentType)) {
            URL url = connection.getURL();
            String resourcePath = url.getPath();
            contentType = resourcePath.endsWith(".css") ? "text/css" : this.getServletContext().getMimeType(resourcePath);
        }
        response.setContentType(contentType);
        int contentLength = connection.getContentLength();
        if (contentLength >= 0) {
            response.setContentLength(contentLength);
        }
        if ((lastModified = connection.getLastModified()) >= 0L) {
            response.setDateHeader("Last-Modified", lastModified);
        }
        if (!this._debug) {
            response.setHeader("Cache-Control", "Public");
            long currentTime = System.currentTimeMillis();
            response.setDateHeader("Expires", currentTime + 31363200000L);
        }
    }

    private static boolean _canIgnore(Throwable t) {
        String message;
        if (t instanceof InterruptedIOException) {
            return true;
        }
        if (t instanceof SocketException) {
            return true;
        }
        return t instanceof IOException && (message = t.getMessage()) != null && (message.indexOf("Broken pipe") >= 0 || message.indexOf("abort") >= 0);
    }

    private class _ResourceLifecycle
    extends Lifecycle {
        private _ResourceLifecycle() {
        }

        public void execute(FacesContext p0) throws FacesException {
        }

        public PhaseListener[] getPhaseListeners() {
            return null;
        }

        public void removePhaseListener(PhaseListener p0) {
        }

        public void render(FacesContext p0) throws FacesException {
        }

        public void addPhaseListener(PhaseListener p0) {
        }
    }
}

