/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class TrinidadFilter
implements Filter {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TrinidadFilter.class);
    private Filter _proxied;

    public void init(FilterConfig filterConfig) throws ServletException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            _LOG.severe("Could not find context class loader.");
        } else {
            try {
                Class<?> proxiedClass = loader.loadClass("org.apache.myfaces.trinidadinternal.webapp.TrinidadFilterImpl");
                this._proxied = (Filter)proxiedClass.newInstance();
                this._proxied.init(filterConfig);
            }
            catch (ClassNotFoundException cnfe) {
                _LOG.severe(cnfe);
            }
            catch (IllegalAccessException iae) {
                _LOG.severe(iae);
            }
            catch (InstantiationException ie) {
                _LOG.severe(ie);
            }
            catch (RuntimeException e) {
                _LOG.severe(e);
                throw e;
            }
        }
    }

    public void destroy() {
        if (this._proxied != null) {
            this._proxied.destroy();
        }
        this._proxied = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this._proxied != null) {
            this._proxied.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }
}

