/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.webapp;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.change.AddComponentChange;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.AttributeChangeEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.webapp.ELContextTag;

public abstract class UIXComponentTag
extends UIComponentTag {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXComponentTag.class);
    private static DateFormat _ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private String _rendered;
    private String _id;
    private String _attributeChangeListener;
    private String _validationError;
    private ELContextTag _parentELContext;

    public void setId(String id) {
        this._id = id;
    }

    public void setRendered(String rendered) {
        this._rendered = rendered;
    }

    public void setAttributeChangeListener(String attributeChangeListener) {
        this._attributeChangeListener = attributeChangeListener;
    }

    public int doStartTag() throws JspException {
        String id;
        this._parentELContext = (ELContextTag)TagSupport.findAncestorWithClass((Tag)this, ELContextTag.class);
        String rendered = this._rendered;
        if (rendered != null) {
            if (this._parentELContext != null && UIXComponentTag.isValueReference((String)rendered)) {
                rendered = this._parentELContext.transformExpression(rendered);
            }
            super.setRendered(rendered);
        }
        if ((id = this._id) != null) {
            if (this._parentELContext != null) {
                id = this._parentELContext.transformId(id);
            }
            super.setId(id);
        }
        int retVal = super.doStartTag();
        if (this._validationError != null) {
            throw new JspException(this._validationError);
        }
        return retVal;
    }

    public int doEndTag() throws JspException {
        UIComponent component = this.getComponentInstance();
        if (this.isSuppressed()) {
            UIXComponentTag._applyChanges(this.getFacesContext(), component, this.getCreated());
        }
        return super.doEndTag();
    }

    protected void encodeBegin() throws IOException {
        UIComponent component = this.getComponentInstance();
        if (!this.isSuppressed()) {
            UIXComponentTag._applyChanges(this.getFacesContext(), component, this.getCreated());
        }
        super.encodeBegin();
    }

    protected final void setProperties(UIComponent component) {
        if (component instanceof UIViewRoot) {
            throw new IllegalStateException("<f:view> was not present on this page; tag " + (Object)((Object)this) + "encountered without an <f:view> being processed.");
        }
        super.setProperties(component);
        UIXComponent uixComponent = (UIXComponent)component;
        if (this._attributeChangeListener != null) {
            MethodBinding mb = this.createMethodBinding(this._attributeChangeListener, new Class[]{AttributeChangeEvent.class});
            uixComponent.setAttributeChangeListener(mb);
        }
        this.setProperties(uixComponent.getFacesBean());
    }

    protected void setProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            bean.setProperty(key, value);
        }
    }

    protected void setBooleanProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            bean.setProperty(key, Boolean.valueOf(value));
        }
    }

    protected void setNumberProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else if (value.indexOf(46) == -1) {
            bean.setProperty(key, Integer.valueOf(value));
        } else {
            bean.setProperty(key, Double.valueOf(value));
        }
    }

    protected void setIntegerProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            bean.setProperty(key, Integer.valueOf(value));
        }
    }

    protected void setCharacterProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else if (value.length() >= 1) {
            bean.setProperty(key, new Character(value.charAt(0)));
        }
    }

    protected void setLongProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            bean.setProperty(key, Long.valueOf(value));
        }
    }

    protected void setDoubleProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            bean.setProperty(key, Double.valueOf(value));
        }
    }

    protected void setFloatProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            bean.setProperty(key, Float.valueOf(value));
        }
    }

    protected void setStringArrayProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            bean.setProperty(key, UIXComponentTag._parseNameTokens(value));
        }
    }

    protected void setIntArrayProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            int[] ints;
            String[] strings = UIXComponentTag._parseNameTokens(value);
            if (strings != null) {
                try {
                    ints = new int[strings.length];
                    for (int i = 0; i < strings.length; ++i) {
                        int j;
                        ints[i] = j = Integer.parseInt(strings[i]);
                    }
                }
                catch (NumberFormatException e) {
                    _LOG.severe("Could not convert:" + value + " into int[]", e);
                    return;
                }
            } else {
                ints = null;
            }
            bean.setProperty(key, ints);
        }
    }

    protected void setDateProperty(FacesBean bean, PropertyKey key, String value) {
        if (value == null) {
            return;
        }
        if (UIXComponentTag.isValueReference((String)value)) {
            bean.setValueBinding(key, this.createValueBinding(value));
        } else {
            bean.setProperty(key, UIXComponentTag._parseISODate(value));
        }
    }

    protected final ValueBinding createValueBinding(String string) {
        if (this._parentELContext != null) {
            string = this._parentELContext.transformExpression(string);
        }
        return this.getFacesContext().getApplication().createValueBinding(string);
    }

    protected final MethodBinding createMethodBinding(String string, Class[] types) {
        if (this._parentELContext != null) {
            string = this._parentELContext.transformExpression(string);
        }
        return this.getFacesContext().getApplication().createMethodBinding(string, types);
    }

    protected void setProperties(FacesBean bean) {
    }

    protected void setValidationError(String validationError) {
        this._validationError = validationError;
    }

    private static final Date _parseISODate(String stringValue) {
        try {
            return _ISO_DATE_FORMAT.parse(stringValue);
        }
        catch (ParseException pe) {
            _LOG.info("Could not parse value {0} into a Date using pattern \"yyyy-MM-dd\";  ignoring.", stringValue);
            return null;
        }
    }

    private static final String[] _parseNameTokens(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(5);
        int length = stringValue.length();
        boolean inSpace = true;
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char ch = stringValue.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (inSpace) continue;
                list.add(stringValue.substring(start, i));
                inSpace = true;
                continue;
            }
            if (!inSpace) continue;
            start = i;
            inSpace = false;
        }
        if (!inSpace) {
            list.add(stringValue.substring(start));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private static void _applyChanges(FacesContext facesContext, UIComponent uiComponent, boolean isCreated) {
        RequestContext afc = RequestContext.getCurrentInstance();
        Iterator<ComponentChange> changeIter = afc.getChangeManager().getComponentChanges(facesContext, uiComponent);
        if (changeIter == null) {
            return;
        }
        while (changeIter.hasNext()) {
            UIComponent newAddedComponent;
            boolean isChangeApplicable;
            ComponentChange change = changeIter.next();
            boolean bl = isChangeApplicable = !(change instanceof AttributeComponentChange) || isCreated;
            if (isChangeApplicable) {
                change.changeComponent(uiComponent);
            }
            if (!(change instanceof AddComponentChange) || (newAddedComponent = ((AddComponentChange)change).getComponent()) == null) continue;
            UIXComponentTag._applyChanges(facesContext, newAddedComponent, true);
        }
    }
}

