/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.webapp;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.RequestStateMap;
import org.apache.myfaces.trinidadinternal.config.CheckSerializationConfigurator;
import org.apache.myfaces.trinidadinternal.config.GlobalConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.config.dispatch.DispatchResponseConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.config.dispatch.DispatchServletResponse;
import org.apache.myfaces.trinidadinternal.config.upload.FileUploadConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.config.upload.UploadRequestWrapper;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlHttpConfigurator;
import org.apache.myfaces.trinidadinternal.context.external.ServletExternalContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderKit;
import org.apache.myfaces.trinidadinternal.webapp.PseudoFacesContext;
import org.apache.myfaces.trinidadinternal.webapp.ReplaceParametersRequestWrapper;
import org.apache.myfaces.trinidadinternal.webapp.wrappers.BasicHTMLBrowserRequestWrapper;

public class TrinidadFilterImpl
implements Filter {
    private ServletContext _servletContext;
    private List<Filter> _filters = null;
    private static final String _LAUNCH_KEY = "_dlgDta";
    private static final String _IS_RETURNING_KEY = "org.apache.myfaces.trinidadinternal.webapp.AdfacesFilterImpl.IS_RETURNING";
    private static final String _FILTER_EXECUTED_KEY = "org.apache.myfaces.trinidadinternal.webapp.AdfacesFilterImpl.EXECUTED";
    private static final String _FORCE_PPR_DIALOG_RETURN = "org.apache.myfaces.trinidad.webapp.FORCE_XML_DIALOG_RETURN";
    private static ThreadLocal<PseudoFacesContext> _PSEUDO_FACES_CONTEXT = new ThreadLocal();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TrinidadFilterImpl.class);

    public static void verifyFilterIsInstalled(FacesContext context) {
        Object isInstalled = context.getExternalContext().getRequestMap().get(_FILTER_EXECUTED_KEY);
        if (!Boolean.TRUE.equals(isInstalled)) {
            _LOG.warning("REQUIRED_TRINIDADFILTER_NOT_INSTALLED");
        }
    }

    public static FacesContext getPseudoFacesContext() {
        return _PSEUDO_FACES_CONTEXT.get();
    }

    public static boolean isExecutingDialogReturn(FacesContext context) {
        return Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get(_IS_RETURNING_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        filterConfig = CheckSerializationConfigurator.getFilterConfig(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        this._filters = ClassLoaderUtils.getServices((String)TrinidadFilterImpl.class.getName());
        ServletExternalContext externalContext = new ServletExternalContext(this._servletContext, null, null);
        PseudoFacesContext facesContext = new PseudoFacesContext(externalContext);
        facesContext.setAsCurrentInstance();
        try {
            for (Filter f : this._filters) {
                f.init(filterConfig);
            }
        }
        finally {
            facesContext.release();
        }
    }

    public void destroy() {
        for (Filter f : this._filters) {
            f.destroy();
        }
        this._filters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Map<String, String[]> addedParams;
        if (!this._filters.isEmpty()) {
            chain = new FilterListChain(this._filters, chain);
        }
        request.setAttribute(_FILTER_EXECUTED_KEY, (Object)Boolean.TRUE);
        if (request instanceof HttpServletRequest) {
            request = CheckSerializationConfigurator.getHttpServletRequest(new ServletExternalContext(this._servletContext, (ServletRequest)request, response), (HttpServletRequest)request);
        }
        ServletExternalContext externalContext = new ServletExternalContext(this._getPotentiallyWrappedServletContext((ServletRequest)request), (ServletRequest)request, response);
        PseudoFacesContext facesContext = new PseudoFacesContext(externalContext);
        facesContext.setAsCurrentInstance();
        GlobalConfiguratorImpl config = GlobalConfiguratorImpl.getInstance();
        config.beginRequest(externalContext);
        String noJavaScript = request.getParameter("_noJavaScript");
        if (noJavaScript != null && "true".equals(noJavaScript)) {
            request = new BasicHTMLBrowserRequestWrapper((HttpServletRequest)request);
        }
        if ((addedParams = FileUploadConfiguratorImpl.getAddedParameters(externalContext)) != null) {
            FileUploadConfiguratorImpl.apply(externalContext);
            request = new UploadRequestWrapper((HttpServletRequest)request, addedParams);
        }
        facesContext.release();
        try {
            this._doFilterImpl((ServletRequest)request, response, chain);
        }
        catch (Throwable t) {
            boolean isPartialRequest = addedParams != null ? CoreRenderKit.isPartialRequest(addedParams) : CoreRenderKit.isPartialRequest(externalContext);
            if (isPartialRequest) {
                XmlHttpConfigurator.handleError(externalContext, t);
            } else {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof ServletException) {
                    throw (ServletException)t;
                }
                _LOG.severe(t);
            }
        }
        finally {
            config.endRequest(externalContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doFilterImpl(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletExternalContext ec = new ServletExternalContext(this._getPotentiallyWrappedServletContext(request), request, response);
        boolean isHttpReq = ExternalContextUtils.isHttpServletRequest((ExternalContext)ec);
        if (isHttpReq) {
            response = this._getResponse(ec);
            ec.setResponse(response);
        }
        PseudoFacesContext pfc = new PseudoFacesContext(ec);
        _PSEUDO_FACES_CONTEXT.set(pfc);
        try {
            if (isHttpReq) {
                request = this._getRequest(ec);
                ec.setRequest(request);
            }
            chain.doFilter(request, response);
            if (isHttpReq) {
                this._handleDialogReturn(ec);
            }
        }
        finally {
            _PSEUDO_FACES_CONTEXT.remove();
        }
    }

    private String _getKey(String uid) {
        return "_dlgDta_" + uid;
    }

    private ServletResponse _getResponse(ExternalContext ec) {
        DispatchServletResponse dispatch = new DispatchServletResponse(ec);
        DispatchResponseConfiguratorImpl.apply(ec);
        return dispatch;
    }

    private ServletRequest _getRequest(ExternalContext ec) {
        Map sessionMap;
        LaunchData data;
        String uid = (String)ec.getRequestParameterMap().get(_LAUNCH_KEY);
        if (uid != null && (data = (LaunchData)(sessionMap = ec.getSessionMap()).remove(this._getKey(uid))) != null) {
            Map requestMap = ec.getRequestMap();
            requestMap.put(_IS_RETURNING_KEY, Boolean.TRUE);
            UIViewRoot launchView = data.getLaunchView();
            if (launchView != null) {
                requestMap.put("org.apache.myfaces.trinidad.PageFlowSourceView", data.getLaunchView());
            }
            return new ReplaceParametersRequestWrapper((HttpServletRequest)ec.getRequest(), data.getLaunchParam());
        }
        return (ServletRequest)ec.getRequest();
    }

    private void _handleDialogReturn(ExternalContext ec) throws IOException {
        Map reqMap = ec.getRequestMap();
        if (Boolean.TRUE.equals(reqMap.get("org.apache.myfaces.trinidad.DialogReturn"))) {
            Map sessionMap = ec.getSessionMap();
            String uid = UUID.randomUUID().toString();
            LaunchData data = new LaunchData((UIViewRoot)reqMap.get("org.apache.myfaces.trinidad.PageFlowSourceView"), (Map)reqMap.get("org.apache.myfaces.trinidad.PageFlowSourceParameters"));
            sessionMap.put(this._getKey(uid), data);
            HttpServletRequest req = (HttpServletRequest)ec.getRequest();
            StringBuffer url = req.getRequestURL().append("?");
            String queryStr = req.getQueryString();
            if (queryStr != null && queryStr.trim().length() > 0) {
                url.append(queryStr).append("&");
            }
            url.append(_LAUNCH_KEY).append("=").append(uid);
            if (RequestContext.getCurrentInstance().isPartialRequest((FacesContext)_PSEUDO_FACES_CONTEXT.get()) || Boolean.TRUE.equals(RequestStateMap.getInstance((ExternalContext)ec).get((Object)_FORCE_PPR_DIALOG_RETURN))) {
                HttpServletResponse resp = (HttpServletResponse)ec.getResponse();
                XmlHttpConfigurator.sendXmlRedirect(resp.getWriter(), url.toString());
            } else {
                ec.redirect(url.toString());
            }
        }
    }

    private ServletContext _getPotentiallyWrappedServletContext(ServletRequest request) {
        HttpSession session;
        if (request instanceof HttpServletRequest && (session = ((HttpServletRequest)request).getSession(false)) != null) {
            return session.getServletContext();
        }
        return this._servletContext;
    }

    private static final class FilterListChain
    implements FilterChain {
        private final List<Filter> _filters;
        private final FilterChain _last;
        private final int _index;

        public FilterListChain(List<Filter> filters, FilterChain last) {
            this(filters, last, 0);
        }

        private FilterListChain(List<Filter> filters, FilterChain last, int index) {
            assert (index < filters.size());
            this._filters = filters;
            this._last = last;
            this._index = index;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            int nextIndex = this._index + 1;
            FilterChain next = nextIndex < this._filters.size() ? new FilterListChain(this._filters, this._last, nextIndex) : this._last;
            this._filters.get(this._index).doFilter(request, response, next);
        }
    }

    private static final class LaunchData
    implements Serializable {
        private UIViewRoot _launchView;
        private Map<String, String[]> _launchParam;
        private static final long serialVersionUID = 1L;

        public LaunchData(UIViewRoot launchView, Map<String, String[]> launchParam) {
            this._launchView = launchView;
            this._launchParam = launchParam != null ? launchParam : Collections.emptyMap();
        }

        private UIViewRoot getLaunchView() {
            return this._launchView;
        }

        private Map<String, String[]> getLaunchParam() {
            return this._launchParam;
        }
    }
}

