/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="build-mac", requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class BuildMacMojo
extends AbstractNbmMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File outputDirectory;
    @Parameter(property="netbeans.branding.token", required=true)
    protected String brandingToken;
    @Parameter(property="netbeans.mac.icon", required=false)
    private File macIconFile;
    @Parameter(property="netbeans.mac.info.plist", required=false)
    private File macInfoplistFile;
    @Parameter(property="netbeans.mac.launcher", required=false)
    private File macLauncherFile;
    @Parameter(property="netbeans.mac.zipbundle", defaultValue="false")
    private boolean macZipBundle;
    @Parameter(property="netbeans.mac.title", required=false)
    private String macAppTitle;
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"nbm-application".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only makes sense on project with 'nbm-application' packaging.");
        }
        try {
            File bundleDir = new File(this.outputDirectory, this.brandingToken + ".app");
            bundleDir.mkdirs();
            File contentsDir = new File(bundleDir, "Contents");
            contentsDir.mkdirs();
            File resourcesDir = new File(contentsDir, "Resources");
            resourcesDir.mkdirs();
            File appDir = new File(resourcesDir, this.brandingToken);
            appDir.mkdirs();
            File macOSDir = new File(contentsDir, "MacOS");
            macOSDir.mkdirs();
            File app = new File(this.outputDirectory, this.brandingToken);
            FileUtils.copyDirectoryStructure((File)app, (File)appDir);
            Files.delete(appDir.toPath().resolve("bin/" + this.brandingToken + ".exe"));
            Files.delete(appDir.toPath().resolve("bin/" + this.brandingToken + "64.exe"));
            this.copyIcon(resourcesDir);
            this.copyInfoPlist(contentsDir);
            this.copyLauncher(macOSDir);
            if (this.macZipBundle) {
                DefaultFileSet fileset = new DefaultFileSet(this.outputDirectory);
                fileset.setIncludes(new String[]{bundleDir.getName(), bundleDir.getName() + "/**"});
                ZipArchiver archiver = new ZipArchiver();
                archiver.addFileSet((FileSet)fileset);
                File zipFile = new File(this.outputDirectory, this.brandingToken + "-macOS.zip");
                archiver.setDestFile(zipFile);
                archiver.createArchive();
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Build macOS application bundle failed: " + ex, ex);
        }
    }

    void copyInfoPlist(File contentsDir) throws IOException, MojoExecutionException {
        Path infoplist = contentsDir.toPath().resolve("Info.plist");
        if (this.macAppTitle == null) {
            this.macAppTitle = this.brandingToken;
        }
        if (this.macInfoplistFile != null) {
            try (Stream<String> lines = Files.lines(this.macInfoplistFile.toPath());){
                String infoPListString = lines.map(s -> s.replace("${app.title}", this.macAppTitle)).map(s -> s.replace("${app.name}", this.brandingToken)).map(s -> s.replace("${app.version}", this.project.getVersion())).collect(Collectors.joining("\n"));
                Files.write(infoplist, infoPListString.getBytes(), new OpenOption[0]);
            }
        }
        URL harnessResourse = ((Object)((Object)this)).getClass().getClassLoader().getResource("harness");
        JarURLConnection jarConnection = (JarURLConnection)harnessResourse.openConnection();
        JarFile jarFile = jarConnection.getJarFile();
        JarEntry entry = jarFile.getJarEntry("harness/etc/Info.plist");
        if (entry == null) {
            throw new MojoExecutionException("macOS Info.plist not found in harness or via macInfoplistFile parameter");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry)));){
            String infoPListString = reader.lines().map(s -> s.replace("${app.title}", this.macAppTitle)).map(s -> s.replace("${app.name}", this.brandingToken)).map(s -> s.replace("${app.version}", this.project.getVersion())).collect(Collectors.joining("\n"));
            Files.write(infoplist, infoPListString.getBytes(), new OpenOption[0]);
        }
    }

    void copyIcon(File resourcesDir) throws IOException, MojoExecutionException {
        Path icnsPath = resourcesDir.toPath().resolve(this.brandingToken + ".icns");
        if (this.macIconFile != null) {
            FileUtils.copyFile((File)this.macIconFile, (File)icnsPath.toFile());
        } else {
            URL harnessResourse = ((Object)((Object)this)).getClass().getClassLoader().getResource("harness");
            JarURLConnection jarConnection = (JarURLConnection)harnessResourse.openConnection();
            JarFile jarFile = jarConnection.getJarFile();
            JarEntry entry = jarFile.getJarEntry("harness/etc/applicationIcon.icns");
            if (entry == null) {
                throw new MojoExecutionException("macOS icon not found in harness or via macIconFile parameter");
            }
            try (InputStream entryInputStream = jarFile.getInputStream(entry);){
                Files.copy(entryInputStream, icnsPath, StandardCopyOption.REPLACE_EXISTING);
            }
            this.getLog().info((CharSequence)"macOS icon not provided with macIconFile, using default icon.");
        }
    }

    void copyLauncher(File macOSDir) throws IOException, MojoExecutionException {
        Path launcherPath = macOSDir.toPath().resolve(this.brandingToken);
        if (this.macLauncherFile != null) {
            FileUtils.copyFile((File)this.macLauncherFile, (File)launcherPath.toFile());
        } else {
            URL harnessResourse = ((Object)((Object)this)).getClass().getClassLoader().getResource("harness");
            JarURLConnection jarConnection = (JarURLConnection)harnessResourse.openConnection();
            JarFile jarFile = jarConnection.getJarFile();
            JarEntry entry = jarFile.getJarEntry("harness/launchers/app-macOS");
            if (entry == null) {
                throw new MojoExecutionException("macOS launcher not found in harness or via macLauncherFile parameter");
            }
            try (InputStream entryInputStream = jarFile.getInputStream(entry);){
                Files.copy(entryInputStream, launcherPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        launcherPath.toFile().setExecutable(true);
    }
}

