/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.BreakIterator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.analyzer.DefaultClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.asm.ASMDependencyAnalyzer;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.apache.netbeans.nbm.AdaptNbVersion;
import org.apache.netbeans.nbm.CollectModuleLibrariesNodeVisitor;
import org.apache.netbeans.nbm.model.Dependency;
import org.apache.netbeans.nbm.model.NetBeansModule;
import org.apache.netbeans.nbm.utils.ExamineManifest;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="manifest", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class NetBeansManifestUpdateMojo
extends AbstractNbmMojo {
    @Parameter(defaultValue="${project.build.directory}/nbm", property="maven.nbm.buildDir")
    protected File nbmBuildDir;
    @Parameter(defaultValue="${basedir}/src/main/nbm/module.xml")
    protected File descriptor;
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;
    @Parameter(defaultValue="${basedir}/src/main/javahelp")
    protected File nbmJavahelpSource;
    @Parameter(required=true, defaultValue="${basedir}/src/main/nbm/manifest.mf")
    private File sourceManifestFile;
    @Parameter(required=true, readonly=true, defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF")
    private File targetManifestFile;
    @Parameter(property="maven.nbm.includeRuntimeModuleLibraries", defaultValue="false")
    private boolean includeRuntimeModuleLibraries;
    @Parameter(property="maven.nbm.verify", defaultValue="fail")
    private String verifyRuntime;
    private static final String FAIL = "fail";
    private static final String WARN = "warn";
    private static final String SKIP = "skip";
    @Parameter
    private List<String> publicPackages;
    @Parameter(defaultValue="false")
    private boolean useOSGiDependencies;
    @Parameter(defaultValue="${project.groupId}.${project.artifactId}")
    private String codeNameBase;
    @Parameter
    private Dependency[] moduleDependencies;
    @Parameter(defaultValue="normal")
    protected String moduleType;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector artifactCollector;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String packagesValue;
        Manifest manifest;
        ExamineManifest examinator;
        String moduleName;
        boolean eager;
        boolean autoload;
        NetBeansModule module;
        block49: {
            block48: {
                File nbmManifest;
                super.registerNbmAntTasks();
                if (this.descriptor != null && this.descriptor.exists()) {
                    module = this.readModuleDescriptor(this.descriptor);
                    this.getLog().warn((CharSequence)"descriptor parameter is deprecated, use equivalent mojo parameters instead.");
                } else {
                    module = this.createDefaultDescriptor(this.project, false);
                }
                String mtype = this.moduleType;
                if ("normal".equals(mtype) && module.getModuleType() != null) {
                    mtype = module.getModuleType();
                    this.getLog().warn((CharSequence)"moduleType in module descriptor is deprecated, use the plugin's parameter moduleType");
                }
                if (!("normal".equals(mtype) || "autoload".equals(mtype) || "eager".equals(mtype) || "disabled".equals(mtype))) {
                    this.getLog().error((CharSequence)"Only 'normal,autoload,eager,disabled' are allowed values in the moduleType parameter");
                }
                autoload = "autoload".equals(mtype);
                eager = "eager".equals(mtype);
                moduleName = this.codeNameBase;
                if (module.getCodeNameBase() != null) {
                    moduleName = module.getCodeNameBase();
                    this.getLog().warn((CharSequence)"codeNameBase in module descriptor is deprecated, use the plugin's parameter codeNameBase");
                }
                moduleName = moduleName.replaceAll("-", ".");
                File specialManifest = this.sourceManifestFile;
                File file = nbmManifest = module.getManifest() != null ? new File(this.project.getBasedir(), module.getManifest()) : null;
                if (nbmManifest != null && nbmManifest.exists()) {
                    specialManifest = nbmManifest;
                }
                examinator = new ExamineManifest(this.getLog());
                if (specialManifest != null && specialManifest.exists()) {
                    examinator.setManifestFile(specialManifest);
                    examinator.checkFile();
                }
                this.getLog().info((CharSequence)"NBM Plugin generates manifest");
                manifest = null;
                if (specialManifest == null || !specialManifest.exists()) break block48;
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader(new FileInputStream(specialManifest));
                    manifest = new Manifest((Reader)reader);
                }
                catch (IOException exc) {
                    manifest = new Manifest();
                    this.getLog().warn((CharSequence)("Error reading manifest at " + specialManifest), (Throwable)exc);
                    IOUtil.close((Reader)reader);
                }
                catch (ManifestException ex) {
                    this.getLog().warn((CharSequence)("Error reading manifest at " + specialManifest), (Throwable)ex);
                    manifest = new Manifest();
                    {
                        catch (Throwable throwable) {
                            IOUtil.close(reader);
                            throw throwable;
                        }
                    }
                    IOUtil.close((Reader)reader);
                }
                IOUtil.close((Reader)reader);
                break block49;
            }
            manifest = new Manifest();
        }
        Date date = new Date();
        String specVersion = AdaptNbVersion.adaptVersion(this.project.getVersion(), "spec", date);
        String implVersion = AdaptNbVersion.adaptVersion(this.project.getVersion(), "impl", date);
        Manifest.Section mainSection = manifest.getMainSection();
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Specification-Version", specVersion);
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Implementation-Version", implVersion);
        if (autoload || eager) {
            this.conditionallyAddAttribute(mainSection, "AutoUpdate-Show-In-Client", "false");
        }
        String timestamp = NetBeansManifestUpdateMojo.createTimestamp(date);
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Build-Version", timestamp);
        String projectCNB = this.conditionallyAddAttribute(mainSection, "OpenIDE-Module", moduleName);
        if (this.publicPackages != null && this.publicPackages.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String pub : this.publicPackages) {
                if (pub == null) continue;
                if (pub.endsWith(".**")) {
                    sb.append(pub);
                } else if (pub.endsWith(".*")) {
                    sb.append(pub).append("*");
                } else {
                    sb.append(pub).append(".*");
                }
                sb.append(", ");
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 2);
                packagesValue = sb.toString();
            } else {
                packagesValue = "-";
            }
        } else {
            packagesValue = "-";
        }
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Public-Packages", packagesValue);
        this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Requires", "org.openide.modules.ModuleFormat1");
        if (!examinator.isLocalized()) {
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Display-Category", this.project.getGroupId());
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Name", this.project.getName());
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Short-Description", NetBeansManifestUpdateMojo.shorten(this.project.getDescription()));
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Long-Description", this.project.getDescription());
        }
        this.getLog().debug((CharSequence)("module =" + module));
        String scope = this.includeRuntimeModuleLibraries ? "compile+runtime" : "compile";
        DefaultProjectBuildingRequest prjbr = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        prjbr.setProject(this.project);
        DependencyNode treeroot = this.createDependencyTree((ProjectBuildingRequest)prjbr, this.dependencyGraphBuilder, scope);
        HashMap<Artifact, ExamineManifest> examinerCache = new HashMap<Artifact, ExamineManifest>();
        List<Artifact> libArtifacts = NetBeansManifestUpdateMojo.getLibraryArtifacts(treeroot, module, this.project.getRuntimeArtifacts(), examinerCache, this.getLog(), this.useOSGiDependencies);
        List<AbstractNbmMojo.ModuleWrapper> moduleArtifacts = NetBeansManifestUpdateMojo.getModuleDependencyArtifacts(treeroot, module, this.moduleDependencies, this.project, examinerCache, libArtifacts, this.getLog(), this.useOSGiDependencies);
        StringBuilder classPath = new StringBuilder();
        StringBuilder mavenClassPath = new StringBuilder();
        String dependencies = "";
        String depSeparator = " ";
        for (Artifact a : libArtifacts) {
            if (classPath.length() > 0) {
                classPath.append(' ');
            }
            classPath.append(NetBeansManifestUpdateMojo.artifactToClassPathEntry(a, this.codeNameBase));
            if (mavenClassPath.length() > 0) {
                mavenClassPath.append(' ');
            }
            mavenClassPath.append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':').append(a.getBaseVersion());
            if (a.getClassifier() == null) continue;
            mavenClassPath.append(":").append(a.getClassifier());
        }
        for (AbstractNbmMojo.ModuleWrapper wr : moduleArtifacts) {
            if (wr.transitive) continue;
            Dependency dep = wr.dependency;
            Artifact artifact = wr.artifact;
            ExamineManifest depExaminator = (ExamineManifest)examinerCache.get(artifact);
            String type = dep.getType();
            String depToken = dep.getExplicitValue();
            if (depToken == null) {
                if ("loose".equals(type)) {
                    depToken = depExaminator.getModuleWithRelease();
                } else if ("spec".equals(type)) {
                    depToken = depExaminator.getModuleWithRelease() + " > " + (depExaminator.isNetBeansModule() ? depExaminator.getSpecVersion() : AdaptNbVersion.adaptVersion(depExaminator.getSpecVersion(), "spec", date));
                } else if ("impl".equals(type)) {
                    depToken = depExaminator.getModuleWithRelease() + " = " + (depExaminator.isNetBeansModule() ? depExaminator.getImplVersion() : AdaptNbVersion.adaptVersion(depExaminator.getImplVersion(), "impl", date));
                } else {
                    throw new MojoExecutionException("Wrong type of NetBeans dependency: " + type + " Allowed values are: loose, spec, impl.");
                }
            }
            if (depToken == null) {
                this.getLog().error((CharSequence)("Cannot properly resolve the NetBeans dependency for " + dep.getId()));
                continue;
            }
            dependencies = dependencies + depSeparator + depToken;
            depSeparator = ", ";
        }
        if (!this.verifyRuntime.equalsIgnoreCase(SKIP)) {
            try {
                this.checkModuleClassPath(treeroot, libArtifacts, examinerCache, moduleArtifacts, projectCNB);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error while checking runtime dependencies", (Exception)ex);
            }
        }
        if (this.nbmJavahelpSource.exists()) {
            String moduleJarName = NetBeansManifestUpdateMojo.stripVersionFromCodebaseName(moduleName).replace(".", "-");
            classPath.append(" docs/").append(moduleJarName).append(".jar");
        }
        if (classPath.length() > 0) {
            this.conditionallyAddAttribute(mainSection, "X-Class-Path", classPath.toString().trim());
        }
        if (mavenClassPath.length() > 0) {
            this.conditionallyAddAttribute(mainSection, "Maven-Class-Path", mavenClassPath.toString());
        }
        if (dependencies.length() > 0) {
            this.conditionallyAddAttribute(mainSection, "OpenIDE-Module-Module-Dependencies", dependencies);
        }
        PrintWriter writer = null;
        try {
            if (!this.targetManifestFile.exists()) {
                this.targetManifestFile.getParentFile().mkdirs();
                this.targetManifestFile.createNewFile();
            }
            writer = new PrintWriter(this.targetManifestFile, "UTF-8");
            manifest.write(writer);
        }
        catch (IOException ex) {
            try {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    static String artifactToClassPathEntry(Artifact a, String codenamebase) {
        return "ext/" + codenamebase + "/" + a.getGroupId().replace('.', '-') + "/" + a.getArtifactId() + (a.getClassifier() != null ? "-" + a.getClassifier() : "") + "." + a.getArtifactHandler().getExtension();
    }

    private static String createTimestamp(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = dateFormat.format(date);
        return timestamp;
    }

    static String stripVersionFromCodebaseName(String cnb) {
        String base = cnb;
        int index = base.indexOf(47);
        if (index > -1) {
            base = base.substring(0, index).trim();
        }
        return base;
    }

    String conditionallyAddAttribute(Manifest.Section section, String key, String value) {
        Manifest.Attribute attr = section.getAttribute(key);
        if (attr == null) {
            attr = new Manifest.Attribute();
            attr.setName(key);
            attr.setValue(value != null ? value.replaceAll("\\s+", " ").trim() : "<undefined>");
            try {
                section.addConfiguredAttribute(attr);
            }
            catch (ManifestException ex) {
                this.getLog().error((CharSequence)("Cannot update manifest (key=" + key + ")"));
                ex.printStackTrace();
            }
        }
        return attr.getValue();
    }

    static String shorten(String paragraph) {
        if (paragraph == null || paragraph.length() == 0) {
            return null;
        }
        BreakIterator breaker = BreakIterator.getSentenceInstance();
        breaker.setText(paragraph);
        return paragraph.substring(0, breaker.following(0)).trim();
    }

    private void checkModuleClassPath(DependencyNode treeroot, List<Artifact> libArtifacts, Map<Artifact, ExamineManifest> examinerCache, List<AbstractNbmMojo.ModuleWrapper> moduleArtifacts, String projectCodeNameBase) throws IOException, MojoExecutionException, MojoFailureException {
        Set<String> deps = this.buildProjectDependencyClasses(this.project, libArtifacts);
        deps.retainAll(this.allProjectClasses(this.project));
        Set<String> own = this.projectModuleOwnClasses(this.project, libArtifacts);
        deps.removeAll(own);
        CollectModuleLibrariesNodeVisitor visitor = new CollectModuleLibrariesNodeVisitor(this.project.getRuntimeArtifacts(), examinerCache, this.getLog(), treeroot, this.useOSGiDependencies);
        treeroot.accept((DependencyNodeVisitor)visitor);
        Map<String, List<Artifact>> modules = visitor.getDeclaredArtifacts();
        HashMap<Artifact, Set<String>> moduleAllClasses = new HashMap<Artifact, Set<String>>();
        for (AbstractNbmMojo.ModuleWrapper wr : moduleArtifacts) {
            if (!modules.containsKey(wr.artifact.getDependencyConflictId())) continue;
            ExamineManifest examineManifest = examinerCache.get(wr.artifact);
            List<Artifact> arts = modules.get(wr.artifact.getDependencyConflictId());
            Set<String>[] classes = this.visibleModuleClasses(arts, examineManifest, wr.dependency, projectCodeNameBase, false);
            deps.removeAll(classes[0]);
            moduleAllClasses.put(wr.artifact, classes[1]);
        }
        if (!deps.isEmpty()) {
            Map<String, List<Artifact>> transmodules = visitor.getTransitiveArtifacts();
            for (AbstractNbmMojo.ModuleWrapper moduleWrapper : moduleArtifacts) {
                if (!transmodules.containsKey(moduleWrapper.artifact.getDependencyConflictId())) continue;
                ExamineManifest man = examinerCache.get(moduleWrapper.artifact);
                List<Artifact> arts = transmodules.get(moduleWrapper.artifact.getDependencyConflictId());
                Set<String>[] classes = this.visibleModuleClasses(arts, man, moduleWrapper.dependency, projectCodeNameBase, true);
                classes[0].retainAll(deps);
                if (classes[0].size() > 0) {
                    String module = moduleWrapper.osgi ? "OSGi bundle" : "module";
                    this.getLog().error((CharSequence)("Project uses classes from transitive " + module + " " + moduleWrapper.artifact.getId() + " which will not be accessible at runtime."));
                    this.getLog().info((CharSequence)"To fix the problem, add this module as direct dependency. For OSGi bundles that are supposed to be wrapped in NetBeans modules, use the useOSGiDependencies=false parameter");
                    deps.removeAll(classes[0]);
                }
                classes[1].retainAll(deps);
                if (classes[1].size() <= 0) continue;
                this.getLog().info((CharSequence)("Private classes referenced in transitive module: " + Arrays.toString(classes[1].toArray())));
                this.getLog().error((CharSequence)("Project depends on packages not accessible at runtime in transitive module " + moduleWrapper.artifact.getId() + " which will not be accessible at runtime."));
                deps.removeAll(classes[1]);
            }
            for (Map.Entry entry : moduleAllClasses.entrySet()) {
                ArrayList<String> strs = new ArrayList<String>(deps);
                if (!deps.removeAll((Collection)entry.getValue())) continue;
                strs.retainAll((Collection)entry.getValue());
                this.getLog().info((CharSequence)("Private classes referenced in module: " + Arrays.toString(strs.toArray())));
                this.getLog().error((CharSequence)("Project depends on packages not accessible at runtime in module " + ((Artifact)entry.getKey()).getId()));
            }
            if (this.verifyRuntime.equalsIgnoreCase(FAIL)) {
                if (!deps.isEmpty()) {
                    throw new MojoFailureException("Uncategorized problems with NetBeans dependency verification (maybe MNBMODULE-102 or wrong maven dependency metadata). Supposedly external classes are used in the project's binaries but the classes are not found on classpath. Class usages: " + deps);
                }
                throw new MojoFailureException("See above for failures in runtime NetBeans dependencies verification.");
            }
        }
    }

    private Set<String> buildProjectDependencyClasses(MavenProject project, List<Artifact> libraries) throws IOException {
        HashSet<String> dependencyClasses = new HashSet<String>();
        String outputDirectory = project.getBuild().getOutputDirectory();
        dependencyClasses.addAll(this.buildDependencyClasses(outputDirectory));
        for (Artifact lib : libraries) {
            dependencyClasses.addAll(this.buildDependencyClasses(lib.getFile().getAbsolutePath()));
        }
        return dependencyClasses;
    }

    private Set<String> projectModuleOwnClasses(MavenProject project, List<Artifact> libraries) throws IOException {
        HashSet<String> projectClasses = new HashSet<String>();
        DefaultClassAnalyzer analyzer = new DefaultClassAnalyzer();
        String outputDirectory = project.getBuild().getOutputDirectory();
        URL fl = new File(outputDirectory).toURI().toURL();
        projectClasses.addAll(analyzer.analyze(fl));
        for (Artifact lib : libraries) {
            URL url = lib.getFile().toURI().toURL();
            projectClasses.addAll(analyzer.analyze(url));
        }
        return projectClasses;
    }

    private Set<String> allProjectClasses(MavenProject project) throws IOException {
        HashSet<String> projectClasses = new HashSet<String>();
        DefaultClassAnalyzer analyzer = new DefaultClassAnalyzer();
        String outputDirectory = project.getBuild().getOutputDirectory();
        URL fl = new File(outputDirectory).toURI().toURL();
        projectClasses.addAll(analyzer.analyze(fl));
        List libs = project.getRuntimeArtifacts();
        for (Artifact lib : libs) {
            URL url = lib.getFile().toURI().toURL();
            projectClasses.addAll(analyzer.analyze(url));
        }
        return projectClasses;
    }

    private Set<String>[] visibleModuleClasses(List<Artifact> moduleLibraries, ExamineManifest manifest, Dependency dep, String projectCodeNameBase, boolean transitive) throws IOException, MojoFailureException {
        HashSet moduleClasses = new HashSet();
        HashSet<String> visibleModuleClasses = new HashSet<String>();
        DefaultClassAnalyzer analyzer = new DefaultClassAnalyzer();
        String type = dep.getType();
        if (dep.getExplicitValue() != null && dep.getExplicitValue().contains("=")) {
            type = "impl";
        }
        if (type == null || "loose".equals(type)) {
            type = "spec";
        }
        for (Artifact lib : moduleLibraries) {
            URL url = lib.getFile().toURI().toURL();
            moduleClasses.addAll(analyzer.analyze(url));
        }
        if ("spec".equals(type)) {
            String cnb = NetBeansManifestUpdateMojo.stripVersionFromCodebaseName(projectCodeNameBase);
            if (!transitive && manifest.hasFriendPackages() && !manifest.getFriends().contains(cnb)) {
                String message = "Module has friend dependency on " + manifest.getModule() + " but is not listed as a friend.";
                if (this.verifyRuntime.equalsIgnoreCase(FAIL)) {
                    throw new MojoFailureException(message);
                }
                this.getLog().warn((CharSequence)message);
            }
            List<Pattern> compiled = NetBeansManifestUpdateMojo.createCompiledPatternList(manifest.getPackages());
            if (this.useOSGiDependencies && manifest.isOsgiBundle()) {
                compiled = Collections.singletonList(Pattern.compile("(.+)"));
            }
            block1: for (String clazz : moduleClasses) {
                for (Pattern patt : compiled) {
                    if (!patt.matcher(clazz).matches()) continue;
                    visibleModuleClasses.add(clazz);
                    continue block1;
                }
            }
        } else if ("impl".equals(type)) {
            visibleModuleClasses.addAll(moduleClasses);
        } else {
            throw new MojoFailureException("Wrong type of module dependency " + type);
        }
        return new Set[]{visibleModuleClasses, moduleClasses};
    }

    static List<Pattern> createCompiledPatternList(List<String> packages) {
        ArrayList<Pattern> toRet = new ArrayList<Pattern>();
        for (String token : packages) {
            String patt;
            if (token.endsWith(".**")) {
                patt = "^" + Pattern.quote(token.substring(0, token.length() - 2)) + "(.+)";
                toRet.add(0, Pattern.compile(patt));
                continue;
            }
            patt = "^" + Pattern.quote(token.substring(0, token.length() - 1)) + "([^\\.]+)";
            toRet.add(Pattern.compile(patt));
        }
        return toRet;
    }

    private Set<String> buildDependencyClasses(String path) throws IOException {
        URL url = new File(path).toURI().toURL();
        ASMDependencyAnalyzer dependencyAnalyzer = new ASMDependencyAnalyzer();
        return dependencyAnalyzer.analyze(url);
    }
}

