/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="run-ide", aggregator=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class RunNetBeansMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/netbeans_clusters")
    protected File clusterBuildDir;
    @Parameter(required=true, property="netbeans.installation")
    protected File netbeansInstallation;
    @Parameter(required=true, defaultValue="${project.build.directory}/userdir", property="netbeans.userdir")
    protected File netbeansUserdir;
    @Parameter(property="netbeans.run.params")
    protected String additionalArguments;
    @Parameter(property="netbeans.run.params.debug")
    protected String debugAdditionalArguments;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File exec;
        this.netbeansUserdir.mkdirs();
        ArrayList<File> clusters = new ArrayList<File>();
        if (!this.clusterBuildDir.exists() || this.clusterBuildDir.listFiles() == null) {
            throw new MojoExecutionException("No clusters to include in execution found. Please run the nbm:cluster or nbm:cluster-app goals before this one.");
        }
        File[] fls = this.clusterBuildDir.listFiles();
        for (int i = 0; i < fls.length; ++i) {
            if (!fls[i].isDirectory()) continue;
            clusters.add(fls[i]);
        }
        StringBuilder buff = new StringBuilder();
        for (File cluster : clusters) {
            buff.append(cluster.getAbsolutePath());
            buff.append(":");
        }
        if (buff.lastIndexOf(":") > -1) {
            buff.deleteCharAt(buff.lastIndexOf(":"));
        }
        this.getLog().debug((CharSequence)("cluster path:\n" + buff.toString()));
        File binDir = new File(this.netbeansInstallation, "bin");
        File[] execs = binDir.listFiles();
        String appName = null;
        if (execs != null) {
            for (File f : execs) {
                String name = f.getName();
                if (name.contains("_w.exe") || (name = name.replaceFirst("(64)?([.]exe)?$", "")).contains(".")) continue;
                if (appName == null) {
                    appName = name;
                    continue;
                }
                if (appName.equals(name)) continue;
                this.getLog().debug((CharSequence)("When examining executable names, found clashing results " + f.getName() + " " + appName));
            }
        }
        if (appName == null) {
            appName = "netbeans";
        }
        StringReader sr = new StringReader(appName + "_extraclusters=\"" + buff.toString() + "\"\nextraclusters=\"" + buff.toString() + "\"\nextra_clusters=\"" + buff.toString() + "\"");
        File etc = new File(this.netbeansUserdir, "etc");
        etc.mkdirs();
        File confFile = new File(etc, appName + ".conf");
        FileOutputStream conf = null;
        try {
            conf = new FileOutputStream(confFile);
            IOUtil.copy((Reader)sr, (OutputStream)conf);
        }
        catch (IOException ex) {
            try {
                throw new MojoExecutionException("Error writing " + confFile, (Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(conf);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)conf);
        if (this.getLog().isDebugEnabled()) {
            try (FileInputStream io = new FileInputStream(confFile);){
                this.getLog().debug((CharSequence)("Configuration file content:\n" + IOUtil.toString((InputStream)io)));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Error writing " + confFile, (Exception)ex);
            }
        }
        boolean windows = Os.isFamily((String)"windows");
        Commandline cmdLine = new Commandline();
        if (windows) {
            exec = new File(this.netbeansInstallation, "bin\\nb.exe");
            if (!exec.exists()) {
                File exec64;
                exec = new File(this.netbeansInstallation, "bin\\" + appName + ".exe");
                String jdkHome = System.getenv("JAVA_HOME");
                if (jdkHome != null && (new File(jdkHome, "jre\\lib\\amd64\\jvm.cfg").exists() || new File(jdkHome, "bin\\windowsaccessbridge-64.dll").exists()) && (exec64 = new File(this.netbeansInstallation, "bin\\" + appName + "64.exe")).isFile()) {
                    exec = exec64;
                }
                cmdLine.addArguments(new String[]{"--console", "suppress"});
            }
        } else {
            exec = new File(this.netbeansInstallation, "bin/" + appName);
        }
        cmdLine.setExecutable(exec.getAbsolutePath());
        try {
            String[] args = new String[]{"--userdir", this.netbeansUserdir.getAbsolutePath(), "-J-Dnetbeans.logger.console=true", "-J-ea"};
            cmdLine.addArguments(args);
            this.getLog().info((CharSequence)("Additional arguments=" + this.additionalArguments));
            cmdLine.addArguments(CommandLineUtils.translateCommandline((String)this.additionalArguments));
            cmdLine.addArguments(CommandLineUtils.translateCommandline((String)this.getDebugAdditionalArguments()));
            for (int i = 0; i < cmdLine.getArguments().length; ++i) {
                this.getLog().info((CharSequence)("      " + cmdLine.getArguments()[i]));
            }
            this.getLog().info((CharSequence)("Executing: " + cmdLine.toString()));
            StreamConsumer out = new StreamConsumer(){

                public void consumeLine(String line) {
                    RunNetBeansMojo.this.getLog().info((CharSequence)line);
                }
            };
            CommandLineUtils.executeCommandLine((Commandline)cmdLine, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed executing NetBeans", e);
        }
    }

    private String getDebugAdditionalArguments() {
        if ("true".equals(this.debugAdditionalArguments)) {
            return "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
        }
        return this.debugAdditionalArguments;
    }
}

