/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.IOException;
import java.security.KeyManagementException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.OperationNotSupportedException;
import org.apache.nifi.properties.NiFiPropertiesLoader;
import org.apache.nifi.provenance.CryptoUtils;
import org.apache.nifi.provenance.StaticKeyProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedKeyProvider
extends StaticKeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedKeyProvider.class);
    private String filepath;

    FileBasedKeyProvider(String location) throws KeyManagementException {
        this(location, FileBasedKeyProvider.getMasterKey());
    }

    FileBasedKeyProvider(String location, SecretKey masterKey) throws KeyManagementException {
        super(CryptoUtils.readKeys(location, masterKey));
        this.filepath = location;
    }

    private static SecretKey getMasterKey() throws KeyManagementException {
        try {
            String masterKeyHex = NiFiPropertiesLoader.extractKeyFromBootstrapFile();
            return new SecretKeySpec(Hex.decode((String)masterKeyHex), "AES");
        }
        catch (IOException e) {
            logger.error("Encountered an error: ", (Throwable)e);
            throw new KeyManagementException(e);
        }
    }

    @Override
    public boolean addKey(String keyId, SecretKey key) throws OperationNotSupportedException, KeyManagementException {
        throw new OperationNotSupportedException("This implementation does not allow adding keys. Modify the file backing this provider at " + this.filepath);
    }
}

