/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.naming.OperationNotSupportedException;
import org.apache.nifi.provenance.CryptoUtils;
import org.apache.nifi.provenance.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticKeyProvider
implements KeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(StaticKeyProvider.class);
    private Map<String, SecretKey> keys = new HashMap<String, SecretKey>();

    StaticKeyProvider(String keyId, String keyHex) throws KeyManagementException {
        this.keys.put(keyId, CryptoUtils.formKeyFromHex(keyHex));
    }

    StaticKeyProvider(Map<String, SecretKey> keys) throws KeyManagementException {
        this.keys.putAll(keys);
    }

    @Override
    public SecretKey getKey(String keyId) throws KeyManagementException {
        logger.debug("Attempting to get key: " + keyId);
        if (this.keyExists(keyId)) {
            return this.keys.get(keyId);
        }
        throw new KeyManagementException("No key available for " + keyId);
    }

    @Override
    public boolean keyExists(String keyId) {
        return this.keys.containsKey(keyId);
    }

    @Override
    public List<String> getAvailableKeyIds() {
        return new ArrayList<String>(this.keys.keySet());
    }

    @Override
    public boolean addKey(String keyId, SecretKey key) throws OperationNotSupportedException, KeyManagementException {
        throw new OperationNotSupportedException("This implementation does not allow adding keys");
    }
}

