/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.nifi.util.FlowFileUnpackager;
import org.apache.nifi.util.FlowFileUnpackagerV1;
import org.apache.nifi.util.FlowFileUnpackagerV2;
import org.apache.nifi.util.FlowFileUnpackagerV3;

public class Unpackage {
    private static void printUsage() {
        System.out.println("java " + Unpackage.class.getCanonicalName() + " <version> <input file 1> [<input file 2> <input file 3> ... <input file N>]");
        System.out.println("<version> : The version of the FlowFile Package format. Valid values are 1, 2, 3");
        System.out.println("<input file X> : The FlowFile package to unpack");
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            Unpackage.printUsage();
            return;
        }
        String version = args[0];
        int inputFileCount = 0;
        int outputFileCount = 0;
        for (int i = 1; i < args.length; ++i) {
            String filename = args[i];
            File inFile = new File(filename);
            if (inFile.isDirectory()) {
                System.out.println("WARNING: input file " + inFile + " is a directory; skipping");
                continue;
            }
            if (!inFile.exists() || !inFile.canRead()) {
                System.out.println("ERROR: unable to read file " + inFile);
                continue;
            }
            File outputDir = new File(inFile.getAbsolutePath() + ".unpacked");
            if (!outputDir.exists() && !outputDir.mkdir()) {
                System.out.println("ERROR: Unable to create directory " + outputDir);
                continue;
            }
            File tempFile = new File(outputDir, ".temp." + UUID.randomUUID().toString() + ".unpackage");
            ++inputFileCount;
            try (FileInputStream fis = new FileInputStream(inFile);
                 BufferedInputStream bufferedIn = new BufferedInputStream(fis);){
                FlowFileUnpackager unpackager = Unpackage.createUnpackager(version);
                while (unpackager.hasMoreData()) {
                    Map<String, String> attributes;
                    ++outputFileCount;
                    try (FileOutputStream fos = new FileOutputStream(tempFile);
                         BufferedOutputStream bufferedOut = new BufferedOutputStream(fos);){
                        attributes = unpackager.unpackageFlowFile(bufferedIn, bufferedOut);
                    }
                    String outputFilename = attributes.get("filename");
                    if (outputFilename == null) {
                        outputFilename = attributes.get("nf.file.name");
                    }
                    File outputFile = new File(outputDir, outputFilename);
                    tempFile.renameTo(outputFile);
                    File attributeFilename = new File(outputDir, outputFilename + ".attributes");
                    FileOutputStream fos = new FileOutputStream(attributeFilename);
                    Throwable throwable = null;
                    try {
                        BufferedOutputStream bufferedOut = new BufferedOutputStream(fos);
                        Throwable throwable2 = null;
                        try {
                            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                                bufferedOut.write((entry.getKey() + "=" + entry.getValue() + "\n").getBytes("UTF-8"));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (bufferedOut == null) continue;
                            if (throwable2 != null) {
                                try {
                                    bufferedOut.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            bufferedOut.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                continue;
            }
        }
        System.out.println("Unpacked " + inputFileCount + " packages into " + outputFileCount + " files");
    }

    public static FlowFileUnpackager createUnpackager(String version) {
        switch (version) {
            case "1": {
                return new FlowFileUnpackagerV1();
            }
            case "2": {
                return new FlowFileUnpackagerV2();
            }
            case "3": {
                return new FlowFileUnpackagerV3();
            }
        }
        System.out.println("ERROR: Invalid version: " + version + "; must be 1, 2, or 3");
        return null;
    }
}

