/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.util.CapturingLogger;
import org.apache.nifi.util.LogMessage;
import org.slf4j.LoggerFactory;

public class MockComponentLog
implements ComponentLog {
    private final CapturingLogger logger;
    private final Object component;

    public MockComponentLog(String componentId, Object component) {
        this.logger = new CapturingLogger(LoggerFactory.getLogger(component.getClass()));
        this.component = component;
    }

    public List<LogMessage> getTraceMessages() {
        return this.logger.getTraceMessages();
    }

    public List<LogMessage> getDebugMessages() {
        return this.logger.getDebugMessages();
    }

    public List<LogMessage> getInfoMessages() {
        return this.logger.getInfoMessages();
    }

    public List<LogMessage> getWarnMessages() {
        return this.logger.getWarnMessages();
    }

    public List<LogMessage> getErrorMessages() {
        return this.logger.getErrorMessages();
    }

    private Object[] addProcessor(Object[] originalArgs) {
        return this.prependToArgs(originalArgs, this.component);
    }

    private Object[] addProcessorAndThrowable(Object[] os, Throwable t) {
        Object[] modifiedArgs = new Object[os.length + 2];
        modifiedArgs[0] = this.component.toString();
        for (int i = 0; i < os.length; ++i) {
            modifiedArgs[i + 1] = os[i];
        }
        modifiedArgs[modifiedArgs.length - 1] = t.toString();
        return modifiedArgs;
    }

    private Object[] addProcessorAndThrowable(Object[] os, Throwable t, boolean appendThrowable) {
        if (!appendThrowable) {
            return this.addProcessorAndThrowable(os, t);
        }
        Object[] modifiedArgs = new Object[os.length + 3];
        modifiedArgs[0] = this.component.toString();
        for (int i = 0; i < os.length; ++i) {
            modifiedArgs[i + 1] = os[i];
        }
        modifiedArgs[modifiedArgs.length - 2] = t.toString();
        modifiedArgs[modifiedArgs.length - 1] = t;
        return modifiedArgs;
    }

    private Object[] prependToArgs(Object[] originalArgs, Object ... toAdd) {
        Object[] newArgs = new Object[originalArgs.length + toAdd.length];
        System.arraycopy(toAdd, 0, newArgs, 0, toAdd.length);
        System.arraycopy(originalArgs, 0, newArgs, toAdd.length, originalArgs.length);
        return newArgs;
    }

    private Object[] translateException(Object[] os) {
        if (os != null && os.length > 0 && os[os.length - 1] instanceof Throwable) {
            Object[] osCopy = new Object[os.length];
            osCopy[osCopy.length - 1] = os[os.length - 1].toString();
            System.arraycopy(os, 0, osCopy, 0, os.length - 1);
            return osCopy;
        }
        return os;
    }

    private boolean lastArgIsException(Object[] os) {
        return os != null && os.length > 0 && os[os.length - 1] instanceof Throwable;
    }

    public void warn(String msg, Throwable t) {
        this.warn("{} " + msg, new Object[]{this.component}, t);
    }

    public void warn(String msg, Object[] os) {
        if (this.lastArgIsException(os)) {
            this.warn(msg, this.translateException(os), (Throwable)os[os.length - 1]);
        } else {
            msg = "{} " + msg;
            os = this.addProcessor(os);
            this.logger.warn(msg, os);
        }
    }

    public void warn(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.warn(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.warn("", t);
        }
    }

    public void warn(String msg) {
        msg = "{} " + msg;
        this.logger.warn(msg, this.component);
    }

    public void trace(String msg, Throwable t) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.trace(msg, (Object)os, (Object)t);
    }

    public void trace(String msg, Object[] os) {
        msg = "{} " + msg;
        os = this.addProcessor(os);
        this.logger.trace(msg, os);
    }

    public void trace(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.trace(msg, os);
    }

    public void trace(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.trace(msg, os);
        this.logger.trace("", t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void info(String msg, Throwable t) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.info(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("", t);
        }
    }

    public void info(String msg, Object[] os) {
        msg = "{} " + msg;
        os = this.addProcessor(os);
        this.logger.info(msg, os);
    }

    public void info(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.info(msg, os);
    }

    public void info(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.info(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("", t);
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public void error(String msg, Throwable t) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.error(msg, (Object)os, t);
        if (this.logger.isDebugEnabled()) {
            this.logger.error("", t);
        }
    }

    public void error(String msg, Object[] os) {
        if (this.lastArgIsException(os)) {
            this.error(msg, this.translateException(os), (Throwable)os[os.length - 1]);
        } else {
            os = this.addProcessor(os);
            msg = "{} " + msg;
            this.logger.error(msg, os);
        }
    }

    public void error(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.error(msg, os);
    }

    public void error(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t, true);
        msg = "{} " + msg + ": {}";
        this.logger.error(msg, os);
    }

    public void debug(String msg, Throwable t) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.debug(msg, (Object)os, (Object)t);
    }

    public void debug(String msg, Object[] os) {
        os = this.addProcessor(os);
        msg = "{} " + msg;
        this.logger.debug(msg, os);
    }

    public void debug(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.debug(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("", t);
        }
    }

    public void debug(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.component};
        this.logger.debug(msg, os);
    }

    public void log(LogLevel level, String msg, Throwable t) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, t);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, t);
                break;
            }
            case INFO: {
                this.info(msg, t);
                break;
            }
            case TRACE: {
                this.trace(msg, t);
                break;
            }
            case WARN: {
                this.warn(msg, t);
            }
        }
    }

    public void log(LogLevel level, String msg, Object[] os) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, os);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, os);
                break;
            }
            case INFO: {
                this.info(msg, os);
                break;
            }
            case TRACE: {
                this.trace(msg, os);
                break;
            }
            case WARN: {
                this.warn(msg, os);
            }
        }
    }

    public void log(LogLevel level, String msg) {
        switch (level) {
            case DEBUG: {
                this.debug(msg);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg);
                break;
            }
            case INFO: {
                this.info(msg);
                break;
            }
            case TRACE: {
                this.trace(msg);
                break;
            }
            case WARN: {
                this.warn(msg);
            }
        }
    }

    public void log(LogLevel level, String msg, Object[] os, Throwable t) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, os, t);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, os, t);
                break;
            }
            case INFO: {
                this.info(msg, os, t);
                break;
            }
            case TRACE: {
                this.trace(msg, os, t);
                break;
            }
            case WARN: {
                this.warn(msg, os, t);
            }
        }
    }
}

