/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileAccessException;
import org.apache.nifi.processor.exception.FlowFileHandlingException;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.provenance.ProvenanceReporter;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.FlowFileValidator;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockFlowFileQueue;
import org.apache.nifi.util.MockProvenanceReporter;
import org.apache.nifi.util.SharedSessionState;
import org.junit.Assert;

public class MockProcessSession
implements ProcessSession {
    private final Map<Relationship, List<MockFlowFile>> transferMap = new ConcurrentHashMap<Relationship, List<MockFlowFile>>();
    private final MockFlowFileQueue processorQueue;
    private final Set<Long> beingProcessed = new HashSet<Long>();
    private final List<MockFlowFile> penalized = new ArrayList<MockFlowFile>();
    private final Processor processor;
    private final Map<Long, MockFlowFile> currentVersions = new HashMap<Long, MockFlowFile>();
    private final Map<Long, MockFlowFile> originalVersions = new HashMap<Long, MockFlowFile>();
    private final SharedSessionState sharedState;
    private final Map<String, Long> counterMap = new HashMap<String, Long>();
    private final Map<FlowFile, Integer> readRecursionSet = new HashMap<FlowFile, Integer>();
    private final Set<FlowFile> writeRecursionSet = new HashSet<FlowFile>();
    private final MockProvenanceReporter provenanceReporter;
    private final boolean enforceStreamsClosed;
    private final Map<FlowFile, InputStream> openInputStreams = new HashMap<FlowFile, InputStream>();
    private final Map<FlowFile, OutputStream> openOutputStreams = new HashMap<FlowFile, OutputStream>();
    private final StateManager stateManager;
    private final boolean allowSynchronousCommits;
    private boolean committed = false;
    private boolean rolledback = false;
    private final Set<Long> removedFlowFiles = new HashSet<Long>();
    private static final AtomicLong enqueuedIndex = new AtomicLong(0L);

    public MockProcessSession(SharedSessionState sharedState, Processor processor) {
        this(sharedState, processor, true, new MockStateManager(processor));
    }

    public MockProcessSession(SharedSessionState sharedState, Processor processor, StateManager stateManager) {
        this(sharedState, processor, true, stateManager);
    }

    public MockProcessSession(SharedSessionState sharedState, Processor processor, boolean enforceStreamsClosed, StateManager stateManager) {
        this(sharedState, processor, enforceStreamsClosed, stateManager, false);
    }

    public MockProcessSession(SharedSessionState sharedState, Processor processor, boolean enforceStreamsClosed, StateManager stateManager, boolean allowSynchronousCommits) {
        this.processor = processor;
        this.enforceStreamsClosed = enforceStreamsClosed;
        this.sharedState = sharedState;
        this.processorQueue = sharedState.getFlowFileQueue();
        this.provenanceReporter = new MockProvenanceReporter(this, sharedState, processor.getIdentifier(), processor.getClass().getSimpleName());
        this.stateManager = stateManager;
        this.allowSynchronousCommits = allowSynchronousCommits;
    }

    public void adjustCounter(String name, long delta, boolean immediate) {
        if (immediate) {
            this.sharedState.adjustCounter(name, delta);
            return;
        }
        Long counter = this.counterMap.get(name);
        if (counter == null) {
            counter = delta;
            this.counterMap.put(name, counter);
            return;
        }
        counter = counter + delta;
        this.counterMap.put(name, counter);
    }

    public void migrate(ProcessSession newOwner, Collection<FlowFile> flowFiles) {
        if (Objects.requireNonNull(newOwner) == this) {
            throw new IllegalArgumentException("Cannot migrate FlowFiles from a Process Session to itself");
        }
        if (flowFiles == null || flowFiles.isEmpty()) {
            throw new IllegalArgumentException("Must supply at least one FlowFile to migrate");
        }
        if (!(newOwner instanceof MockProcessSession)) {
            throw new IllegalArgumentException("Cannot migrate from a StandardProcessSession to a session of type " + newOwner.getClass());
        }
        this.migrate((MockProcessSession)newOwner, flowFiles);
    }

    private void migrate(MockProcessSession newOwner, Collection<MockFlowFile> flowFiles) {
        for (FlowFile flowFile : flowFiles) {
            if (this.openInputStreams.containsKey(flowFile)) {
                throw new IllegalStateException(flowFile + " cannot be migrated to a new Process Session because this session currently has an open InputStream for the FlowFile, created by calling ProcessSession.read(FlowFile)");
            }
            if (this.openOutputStreams.containsKey(flowFile)) {
                throw new IllegalStateException(flowFile + " cannot be migrated to a new Process Session because this session currently has an open OutputStream for the FlowFile, created by calling ProcessSession.write(FlowFile)");
            }
            if (this.readRecursionSet.containsKey(flowFile)) {
                throw new IllegalStateException(flowFile + " already in use for an active callback or InputStream created by ProcessSession.read(FlowFile) has not been closed");
            }
            if (this.writeRecursionSet.contains(flowFile)) {
                throw new IllegalStateException(flowFile + " already in use for an active callback or OutputStream created by ProcessSession.write(FlowFile) has not been closed");
            }
            FlowFile currentVersion = (FlowFile)this.currentVersions.get(flowFile.getId());
            if (currentVersion != null) continue;
            throw new FlowFileHandlingException(flowFile + " is not known in this session");
        }
        for (Map.Entry entry : this.transferMap.entrySet()) {
            Relationship relationship = (Relationship)entry.getKey();
            List transferredFlowFiles = (List)entry.getValue();
            for (MockFlowFile flowFile : flowFiles) {
                if (!transferredFlowFiles.remove(flowFile)) continue;
                newOwner.transferMap.computeIfAbsent(relationship, rel -> new ArrayList()).add(flowFile);
            }
        }
        for (MockFlowFile mockFlowFile : flowFiles) {
            if (this.beingProcessed.remove(mockFlowFile.getId())) {
                newOwner.beingProcessed.add(mockFlowFile.getId());
            }
            if (this.penalized.remove(mockFlowFile)) {
                newOwner.penalized.add(mockFlowFile);
            }
            if (this.currentVersions.containsKey(mockFlowFile.getId())) {
                newOwner.currentVersions.put(mockFlowFile.getId(), this.currentVersions.remove(mockFlowFile.getId()));
            }
            if (this.originalVersions.containsKey(mockFlowFile.getId())) {
                newOwner.originalVersions.put(mockFlowFile.getId(), this.originalVersions.remove(mockFlowFile.getId()));
            }
            if (!this.removedFlowFiles.remove(mockFlowFile.getId())) continue;
            newOwner.removedFlowFiles.add(mockFlowFile.getId());
        }
        Set<String> flowFileIds = flowFiles.stream().map(ff -> ff.getAttribute(CoreAttributes.UUID.key())).collect(Collectors.toSet());
        this.provenanceReporter.migrate(newOwner.provenanceReporter, flowFileIds);
    }

    public MockFlowFile clone(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        MockFlowFile newFlowFile = new MockFlowFile(this.sharedState.nextFlowFileId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        this.beingProcessed.add(newFlowFile.getId());
        return newFlowFile;
    }

    public MockFlowFile clone(FlowFile flowFile, long offset, long size) {
        if (offset + size > (flowFile = this.validateState((FlowFile)flowFile)).getSize()) {
            throw new FlowFileHandlingException("Specified offset of " + offset + " and size " + size + " exceeds size of " + flowFile.toString());
        }
        MockFlowFile newFlowFile = new MockFlowFile(this.sharedState.nextFlowFileId(), (FlowFile)flowFile);
        byte[] newContent = Arrays.copyOfRange(((MockFlowFile)flowFile).getData(), (int)offset, (int)(offset + size));
        newFlowFile.setData(newContent);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        this.beingProcessed.add(newFlowFile.getId());
        return newFlowFile;
    }

    private void closeStreams(Map<FlowFile, ? extends Closeable> streamMap, boolean enforceClosed) {
        HashMap<FlowFile, ? extends Closeable> openStreamCopy = new HashMap<FlowFile, Closeable>(streamMap);
        for (Map.Entry entry : openStreamCopy.entrySet()) {
            FlowFile flowFile = (FlowFile)entry.getKey();
            Closeable openStream = (Closeable)entry.getValue();
            try {
                openStream.close();
            }
            catch (IOException e) {
                throw new FlowFileAccessException("Failed to close stream for " + flowFile, (Throwable)e);
            }
            if (!enforceClosed) continue;
            throw new FlowFileHandlingException("Cannot commit session because the following streams were created via calls to ProcessSession.read(FlowFile) or ProcessSession.write(FlowFile) and never closed: " + streamMap);
        }
    }

    public void commit() {
        if (!this.allowSynchronousCommits) {
            throw new RuntimeException("As of version 1.14.0, ProcessSession.commit() should be avoided when possible. See JavaDocs for explanations. Instead, use commitAsync(), commitAsync(Runnable), or commitAsync(Runnable, Consumer<Throwable>). However, if this is not possible, ProcessSession.commit() may still be used, but this must be explicitly enabled by calling TestRunner.");
        }
        this.commitInternal();
    }

    private void commitInternal() {
        if (!this.beingProcessed.isEmpty()) {
            throw new FlowFileHandlingException("Cannot commit session because the following FlowFiles have not been removed or transferred: " + this.beingProcessed);
        }
        this.closeStreams(this.openInputStreams, this.enforceStreamsClosed);
        this.closeStreams(this.openOutputStreams, this.enforceStreamsClosed);
        this.committed = true;
        this.beingProcessed.clear();
        this.currentVersions.clear();
        this.originalVersions.clear();
        for (Map.Entry<String, Long> entry : this.counterMap.entrySet()) {
            this.sharedState.adjustCounter(entry.getKey(), entry.getValue());
        }
        this.sharedState.addProvenanceEvents(this.provenanceReporter.getEvents());
        this.provenanceReporter.clear();
        this.counterMap.clear();
    }

    public void commitAsync() {
        this.commitInternal();
    }

    public void commitAsync(Runnable onSuccess, Consumer<Throwable> onFailure) {
        try {
            this.commitInternal();
        }
        catch (Throwable t) {
            this.rollback();
            onFailure.accept(t);
            throw t;
        }
        onSuccess.run();
    }

    public void clearCommitted() {
        this.committed = false;
    }

    public void clearRollback() {
        this.rolledback = false;
    }

    public MockFlowFile create() {
        MockFlowFile flowFile = new MockFlowFile(this.sharedState.nextFlowFileId());
        this.currentVersions.put(flowFile.getId(), flowFile);
        this.beingProcessed.add(flowFile.getId());
        return flowFile;
    }

    public MockFlowFile create(FlowFile flowFile) {
        MockFlowFile newFlowFile = this.create();
        newFlowFile = (MockFlowFile)this.inheritAttributes(flowFile, (FlowFile)newFlowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        this.beingProcessed.add(newFlowFile.getId());
        return newFlowFile;
    }

    public MockFlowFile create(Collection<FlowFile> flowFiles) {
        MockFlowFile newFlowFile = this.create();
        newFlowFile = (MockFlowFile)this.inheritAttributes(flowFiles, (FlowFile)newFlowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        this.beingProcessed.add(newFlowFile.getId());
        return newFlowFile;
    }

    public void exportTo(FlowFile flowFile, OutputStream out) {
        if ((flowFile = this.validateState((FlowFile)flowFile)) == null || out == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        try {
            out.write(mock.getData());
        }
        catch (IOException e) {
            throw new FlowFileAccessException(e.toString(), (Throwable)e);
        }
    }

    public void exportTo(FlowFile flowFile, Path path, boolean append) {
        if ((flowFile = this.validateState((FlowFile)flowFile)) == null || path == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        StandardOpenOption mode = append ? StandardOpenOption.APPEND : StandardOpenOption.CREATE;
        try (OutputStream out = Files.newOutputStream(path, mode);){
            out.write(mock.getData());
        }
        catch (IOException e) {
            throw new FlowFileAccessException(e.toString(), (Throwable)e);
        }
    }

    public MockFlowFile get() {
        MockFlowFile flowFile = this.processorQueue.poll();
        if (flowFile != null) {
            this.beingProcessed.add(flowFile.getId());
            this.currentVersions.put(flowFile.getId(), flowFile);
            this.originalVersions.put(flowFile.getId(), flowFile);
        }
        return flowFile;
    }

    public List<FlowFile> get(int maxResults) {
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>(Math.min(500, maxResults));
        for (int i = 0; i < maxResults; ++i) {
            MockFlowFile nextFlowFile = this.get();
            if (nextFlowFile == null) {
                return flowFiles;
            }
            flowFiles.add((FlowFile)nextFlowFile);
        }
        return flowFiles;
    }

    public List<FlowFile> get(FlowFileFilter filter) {
        MockFlowFile flowFile;
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>();
        ArrayList<MockFlowFile> unselected = new ArrayList<MockFlowFile>();
        while ((flowFile = this.processorQueue.poll()) != null) {
            FlowFileFilter.FlowFileFilterResult filterResult = filter.filter((FlowFile)flowFile);
            if (filterResult.isAccept()) {
                flowFiles.add((FlowFile)flowFile);
                this.beingProcessed.add(flowFile.getId());
                this.currentVersions.put(flowFile.getId(), flowFile);
                this.originalVersions.put(flowFile.getId(), flowFile);
            } else {
                unselected.add(flowFile);
            }
            if (filterResult.isContinue()) continue;
            break;
        }
        this.processorQueue.addAll(unselected);
        return flowFiles;
    }

    public QueueSize getQueueSize() {
        return this.processorQueue.size();
    }

    public MockFlowFile importFrom(InputStream in, FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (in == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        try {
            byte[] data = this.readFully(in);
            newFlowFile.setData(data);
            return newFlowFile;
        }
        catch (IOException e) {
            throw new FlowFileAccessException(e.toString(), (Throwable)e);
        }
    }

    public MockFlowFile importFrom(Path path, boolean keepSourceFile, FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (path == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Files.copy(path, baos);
        }
        catch (IOException e) {
            throw new FlowFileAccessException(e.toString(), (Throwable)e);
        }
        newFlowFile.setData(baos.toByteArray());
        newFlowFile = this.putAttribute((FlowFile)newFlowFile, CoreAttributes.FILENAME.key(), path.getFileName().toString());
        return newFlowFile;
    }

    public MockFlowFile merge(Collection<FlowFile> sources, FlowFile destination) {
        sources = this.validateState(sources);
        destination = this.validateState((FlowFile)destination);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (FlowFile flowFile : sources) {
            MockFlowFile mock = (MockFlowFile)flowFile;
            byte[] data = mock.getData();
            try {
                baos.write(data);
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to write to BAOS");
            }
        }
        MockFlowFile newFlowFile = new MockFlowFile(destination.getId(), (FlowFile)destination);
        newFlowFile.setData(baos.toByteArray());
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        return newFlowFile;
    }

    public MockFlowFile putAllAttributes(FlowFile flowFile, Map<String, String> attrs) {
        Map<String, String> updatedAttributes;
        flowFile = this.validateState((FlowFile)flowFile);
        if (attrs == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot update attributes of a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        if (attrs.containsKey(CoreAttributes.UUID.key())) {
            updatedAttributes = new HashMap<String, String>(attrs);
            updatedAttributes.remove(CoreAttributes.UUID.key());
        } else {
            updatedAttributes = attrs;
        }
        newFlowFile.putAttributes(updatedAttributes);
        return newFlowFile;
    }

    public MockFlowFile putAttribute(FlowFile flowFile, String attrName, String attrValue) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (attrName == null || attrValue == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot update attributes of a flow file that I did not create");
        }
        if ("uuid".equals(attrName)) {
            Assert.fail((String)"Should not be attempting to set FlowFile UUID via putAttribute. This will be ignored in production");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, attrValue);
        newFlowFile.putAttributes(attrs);
        return newFlowFile;
    }

    public void read(FlowFile flowFile, InputStreamCallback callback) {
        this.read(flowFile, false, callback);
    }

    public void read(FlowFile flowFile, boolean allowSessionStreamManagement, InputStreamCallback callback) {
        if (callback == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!((flowFile = this.validateState((FlowFile)flowFile)) instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        ByteArrayInputStream bais = new ByteArrayInputStream(mock.getData());
        this.incrementReadCount((FlowFile)flowFile);
        try {
            callback.process((InputStream)bais);
            if (!allowSessionStreamManagement) {
                bais.close();
            }
        }
        catch (IOException e) {
            throw new ProcessException(e.toString(), (Throwable)e);
        }
        finally {
            this.decrementReadCount((FlowFile)flowFile);
        }
    }

    private void incrementReadCount(FlowFile flowFile) {
        this.readRecursionSet.compute(flowFile, (ff, count) -> count == null ? 1 : count + 1);
    }

    private void decrementReadCount(FlowFile flowFile) {
        Integer count = this.readRecursionSet.get(flowFile);
        if (count == null) {
            return;
        }
        int updatedCount = count - 1;
        if (updatedCount == 0) {
            this.readRecursionSet.remove(flowFile);
        } else {
            this.readRecursionSet.put(flowFile, updatedCount);
        }
    }

    public InputStream read(final FlowFile flowFile) {
        if (flowFile == null) {
            throw new IllegalArgumentException("FlowFile cannot be null");
        }
        final MockFlowFile mock = this.validateState(flowFile);
        final ByteArrayInputStream bais = new ByteArrayInputStream(mock.getData());
        this.incrementReadCount(flowFile);
        InputStream errorHandlingStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return bais.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return bais.read(b, off, len);
            }

            @Override
            public void close() throws IOException {
                MockProcessSession.this.decrementReadCount(flowFile);
                MockProcessSession.this.openInputStreams.remove(mock);
                bais.close();
            }

            @Override
            public void mark(int readlimit) {
                bais.mark(readlimit);
            }

            @Override
            public void reset() {
                bais.reset();
            }

            @Override
            public int available() throws IOException {
                return bais.available();
            }

            public String toString() {
                return "ErrorHandlingInputStream[flowFile=" + mock + "]";
            }
        };
        this.openInputStreams.put((FlowFile)mock, errorHandlingStream);
        return errorHandlingStream;
    }

    public void remove(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        Iterator<MockFlowFile> penalizedItr = this.penalized.iterator();
        while (penalizedItr.hasNext()) {
            MockFlowFile ff = penalizedItr.next();
            if (!Objects.equals(ff.getId(), flowFile.getId())) continue;
            penalizedItr.remove();
            this.penalized.remove(ff);
            break;
        }
        Iterator<Long> processedItr = this.beingProcessed.iterator();
        while (processedItr.hasNext()) {
            Long ffId = processedItr.next();
            if (ffId == null || !ffId.equals(flowFile.getId())) continue;
            processedItr.remove();
            this.beingProcessed.remove(ffId);
            this.removedFlowFiles.add(flowFile.getId());
            this.currentVersions.remove(ffId);
            return;
        }
        throw new ProcessException(flowFile + " not found in queue");
    }

    public void remove(Collection<FlowFile> flowFiles) {
        flowFiles = this.validateState(flowFiles);
        for (FlowFile flowFile : flowFiles) {
            this.remove(flowFile);
        }
    }

    public MockFlowFile removeAllAttributes(FlowFile flowFile, Set<String> attrNames) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (attrNames == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.removeAttributes(attrNames);
        return newFlowFile;
    }

    public MockFlowFile removeAllAttributes(FlowFile flowFile, Pattern keyPattern) {
        if ((flowFile = this.validateState((FlowFile)flowFile)) == null) {
            throw new IllegalArgumentException("flowFile cannot be null");
        }
        if (keyPattern == null) {
            return (MockFlowFile)flowFile;
        }
        HashSet<String> attrsToRemove = new HashSet<String>();
        for (String key : flowFile.getAttributes().keySet()) {
            if (!keyPattern.matcher(key).matches()) continue;
            attrsToRemove.add(key);
        }
        return this.removeAllAttributes((FlowFile)flowFile, (Set<String>)attrsToRemove);
    }

    public MockFlowFile removeAttribute(FlowFile flowFile, String attrName) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (attrName == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add(attrName);
        newFlowFile.removeAttributes(attrNames);
        return newFlowFile;
    }

    public void rollback() {
        this.rollback(false);
    }

    public void rollback(boolean penalize) {
        if (this.committed) {
            return;
        }
        this.closeStreams(this.openInputStreams, false);
        this.closeStreams(this.openOutputStreams, false);
        for (List<MockFlowFile> list : this.transferMap.values()) {
            for (MockFlowFile flowFile : list) {
                this.processorQueue.offer(flowFile);
                if (!penalize) continue;
                this.penalized.add(flowFile);
            }
        }
        for (Long flowFileId : this.beingProcessed) {
            MockFlowFile flowFile = this.originalVersions.get(flowFileId);
            if (flowFile == null) continue;
            this.processorQueue.offer(flowFile);
            if (!penalize) continue;
            this.penalized.add(flowFile);
        }
        this.rolledback = true;
        this.beingProcessed.clear();
        this.currentVersions.clear();
        this.originalVersions.clear();
        this.transferMap.clear();
        this.clearTransferState();
        if (!penalize) {
            this.penalized.clear();
        }
    }

    public void transfer(FlowFile flowFile) {
        if (!((flowFile = this.validateState((FlowFile)flowFile)) instanceof MockFlowFile)) {
            throw new IllegalArgumentException("I only accept MockFlowFile");
        }
        if (this.currentVersions.get(flowFile.getId()) != null && this.originalVersions.get(flowFile.getId()) == null) {
            throw new IllegalArgumentException("Cannot transfer FlowFiles that are created in this Session back to self");
        }
        MockFlowFile mockFlowFile = (MockFlowFile)flowFile;
        this.beingProcessed.remove(flowFile.getId());
        this.processorQueue.offer(mockFlowFile);
        this.updateLastQueuedDate(mockFlowFile);
    }

    private void updateLastQueuedDate(MockFlowFile mockFlowFile) {
        mockFlowFile.setLastEnqueuedDate(System.currentTimeMillis());
        mockFlowFile.setEnqueuedIndex(enqueuedIndex.incrementAndGet());
    }

    public void transfer(Collection<FlowFile> flowFiles) {
        for (FlowFile flowFile : flowFiles) {
            this.transfer(flowFile);
        }
    }

    public void transfer(FlowFile flowFile, Relationship relationship) {
        if (relationship == Relationship.SELF) {
            this.transfer((FlowFile)flowFile);
            return;
        }
        if (!this.processor.getRelationships().contains(relationship)) {
            throw new IllegalArgumentException("this relationship " + relationship.getName() + " is not known");
        }
        flowFile = this.validateState((FlowFile)flowFile);
        List list = this.transferMap.computeIfAbsent(relationship, r -> new ArrayList());
        this.beingProcessed.remove(flowFile.getId());
        list.add((MockFlowFile)flowFile);
        this.updateLastQueuedDate((MockFlowFile)flowFile);
    }

    public void transfer(Collection<FlowFile> flowFiles, Relationship relationship) {
        if (relationship == Relationship.SELF) {
            this.transfer(flowFiles);
            return;
        }
        for (FlowFile flowFile : flowFiles) {
            this.transfer(flowFile, relationship);
        }
    }

    public MockFlowFile write(FlowFile flowFile, OutputStreamCallback callback) {
        flowFile = this.validateState((FlowFile)flowFile);
        if (callback == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        MockFlowFile mock = (MockFlowFile)flowFile;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeRecursionSet.add((FlowFile)flowFile);
        try {
            callback.process((OutputStream)baos);
        }
        catch (IOException e) {
            throw new ProcessException(e.toString(), (Throwable)e);
        }
        finally {
            this.writeRecursionSet.remove(flowFile);
        }
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.setData(baos.toByteArray());
        return newFlowFile;
    }

    public OutputStream write(final FlowFile flowFile) {
        if (!(flowFile instanceof MockFlowFile)) {
            throw new IllegalArgumentException("Cannot export a flow file that I did not create");
        }
        final MockFlowFile mockFlowFile = this.validateState(flowFile);
        this.writeRecursionSet.add(flowFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                MockProcessSession.this.writeRecursionSet.remove(mockFlowFile);
                MockFlowFile newFlowFile = new MockFlowFile(mockFlowFile.getId(), flowFile);
                MockProcessSession.this.currentVersions.put(newFlowFile.getId(), newFlowFile);
                newFlowFile.setData(this.toByteArray());
            }
        };
        return baos;
    }

    public FlowFile append(FlowFile flowFile, OutputStreamCallback callback) {
        if (callback == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        MockFlowFile mock = this.validateState(flowFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(mock.getData());
            callback.process((OutputStream)baos);
        }
        catch (IOException e) {
            throw new ProcessException(e.toString(), (Throwable)e);
        }
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.setData(baos.toByteArray());
        return newFlowFile;
    }

    public MockFlowFile write(FlowFile flowFile, StreamCallback callback) {
        if (callback == null || flowFile == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        MockFlowFile mock = this.validateState(flowFile);
        ByteArrayInputStream in = new ByteArrayInputStream(mock.getData());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeRecursionSet.add(flowFile);
        try {
            callback.process((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new ProcessException(e.toString(), (Throwable)e);
        }
        finally {
            this.writeRecursionSet.remove(flowFile);
        }
        MockFlowFile newFlowFile = new MockFlowFile(mock.getId(), flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.setData(out.toByteArray());
        return newFlowFile;
    }

    private byte[] readFully(InputStream in) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((len = in.read(buffer)) >= 0) {
            baos.write(buffer, 0, len);
        }
        return baos.toByteArray();
    }

    public List<MockFlowFile> getFlowFilesForRelationship(Relationship relationship) {
        List<MockFlowFile> list = this.transferMap.get(relationship);
        if (list == null) {
            list = new ArrayList<MockFlowFile>();
        }
        return list;
    }

    public List<MockFlowFile> getPenalizedFlowFiles() {
        return this.penalized;
    }

    public List<MockFlowFile> getFlowFilesForRelationship(String relationship) {
        Relationship procRel = new Relationship.Builder().name(relationship).build();
        return this.getFlowFilesForRelationship(procRel);
    }

    public MockFlowFile createFlowFile(File file) throws IOException {
        return this.createFlowFile(Files.readAllBytes(file.toPath()));
    }

    public MockFlowFile createFlowFile(byte[] data) {
        MockFlowFile flowFile = this.create();
        flowFile.setData(data);
        return flowFile;
    }

    public MockFlowFile createFlowFile(byte[] data, Map<String, String> attrs) {
        MockFlowFile ff = this.createFlowFile(data);
        ff.putAttributes(attrs);
        return ff;
    }

    public MockFlowFile merge(Collection<FlowFile> sources, FlowFile destination, byte[] header, byte[] footer, byte[] demarcator) {
        sources = this.validateState(sources);
        destination = this.validateState((FlowFile)destination);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (header != null) {
                baos.write(header);
            }
            int count = 0;
            for (FlowFile flowFile : sources) {
                baos.write(((MockFlowFile)flowFile).getData());
                if (demarcator == null || ++count == sources.size()) continue;
                baos.write(demarcator);
            }
            if (footer != null) {
                baos.write(footer);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)"failed to write data to BAOS");
        }
        MockFlowFile newFlowFile = new MockFlowFile(destination.getId(), (FlowFile)destination);
        newFlowFile.setData(baos.toByteArray());
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        return newFlowFile;
    }

    private List<FlowFile> validateState(Collection<FlowFile> flowFiles) {
        return flowFiles.stream().map(ff -> this.validateState((FlowFile)ff)).collect(Collectors.toList());
    }

    private MockFlowFile validateState(FlowFile flowFile) {
        Objects.requireNonNull(flowFile);
        MockFlowFile currentVersion = this.currentVersions.get(flowFile.getId());
        if (currentVersion == null) {
            throw new FlowFileHandlingException(flowFile + " is not known in this session");
        }
        if (this.readRecursionSet.containsKey(flowFile)) {
            throw new IllegalStateException(flowFile + " already in use for an active callback or InputStream created by ProcessSession.read(FlowFile) has not been closed");
        }
        if (this.writeRecursionSet.contains(flowFile)) {
            throw new IllegalStateException(flowFile + " already in use for an active callback or OutputStream created by ProcessSession.write(FlowFile) has not been closed");
        }
        for (List<MockFlowFile> flowFiles : this.transferMap.values()) {
            if (!flowFiles.contains(flowFile)) continue;
            throw new IllegalStateException(flowFile + " has already been transferred");
        }
        return currentVersion;
    }

    private FlowFile inheritAttributes(FlowFile source, FlowFile destination) {
        if (source == null || destination == null || source == destination) {
            return destination;
        }
        MockFlowFile updated = this.putAllAttributes(destination, (Map<String, String>)source.getAttributes());
        this.getProvenanceReporter().fork(source, Collections.singletonList(updated));
        return updated;
    }

    private FlowFile inheritAttributes(Collection<FlowFile> sources, FlowFile destination) {
        StringBuilder parentUuidBuilder = new StringBuilder();
        int uuidsCaptured = 0;
        for (FlowFile source : sources) {
            if (source == destination) continue;
            String sourceUuid = source.getAttribute(CoreAttributes.UUID.key());
            if (sourceUuid != null && !sourceUuid.trim().isEmpty()) {
                ++uuidsCaptured;
                if (parentUuidBuilder.length() > 0) {
                    parentUuidBuilder.append(",");
                }
                parentUuidBuilder.append(sourceUuid);
            }
            if (uuidsCaptured <= 100) continue;
            break;
        }
        MockFlowFile updated = this.putAllAttributes(destination, MockProcessSession.intersectAttributes(sources));
        this.getProvenanceReporter().join(sources, (FlowFile)updated);
        return updated;
    }

    private static Map<String, String> intersectAttributes(Collection<FlowFile> flowFileList) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (flowFileList == null || flowFileList.isEmpty()) {
            return result;
        }
        if (flowFileList.size() == 1) {
            result.putAll(flowFileList.iterator().next().getAttributes());
        }
        Map firstMap = flowFileList.iterator().next().getAttributes();
        block0: for (Map.Entry mapEntry : firstMap.entrySet()) {
            String key = (String)mapEntry.getKey();
            String value = (String)mapEntry.getValue();
            for (FlowFile flowFile : flowFileList) {
                Map currMap = flowFile.getAttributes();
                String curVal = (String)currMap.get(key);
                if (curVal != null && curVal.equals(value)) continue;
                continue block0;
            }
            result.put(key, value);
        }
        return result;
    }

    public void assertCommitted() {
        Assert.assertTrue((String)"Session was not committed", (boolean)this.committed);
    }

    public void assertNotCommitted() {
        Assert.assertFalse((String)"Session was committed", (boolean)this.committed);
    }

    public void assertRolledBack() {
        Assert.assertTrue((String)"Session was not rolled back", (boolean)this.rolledback);
    }

    public void assertNotRolledBack() {
        Assert.assertFalse((String)"Session was rolled back", (boolean)this.rolledback);
    }

    public void assertTransferCount(Relationship relationship, int count) {
        int transferCount = this.getFlowFilesForRelationship(relationship).size();
        Assert.assertEquals((String)("Expected " + count + " FlowFiles to be transferred to " + relationship + " but actual transfer count was " + transferCount), (long)count, (long)transferCount);
    }

    public void assertTransferCount(String relationship, int count) {
        this.assertTransferCount(new Relationship.Builder().name(relationship).build(), count);
    }

    public void assertQueueEmpty() {
        Assert.assertTrue((String)("FlowFile Queue has " + this.processorQueue.size() + " items"), (boolean)this.processorQueue.isEmpty());
    }

    public void assertQueueNotEmpty() {
        Assert.assertFalse((String)"FlowFile Queue is empty", (boolean)this.processorQueue.isEmpty());
    }

    public void assertAllFlowFilesTransferred(String relationship) {
        this.assertAllFlowFilesTransferred(new Relationship.Builder().name(relationship).build());
    }

    public void assertAllFlowFilesTransferred(Relationship relationship) {
        for (Map.Entry<Relationship, List<MockFlowFile>> entry : this.transferMap.entrySet()) {
            Relationship rel = entry.getKey();
            List<MockFlowFile> flowFiles = entry.getValue();
            if (rel.equals((Object)relationship) || flowFiles == null || flowFiles.isEmpty()) continue;
            Assert.fail((String)("Expected all Transferred FlowFiles to go to " + relationship + " but " + flowFiles.size() + " were routed to " + rel));
        }
    }

    public void assertAllFlowFiles(FlowFileValidator validator) {
        for (Map.Entry<Relationship, List<MockFlowFile>> entry : this.transferMap.entrySet()) {
            List<MockFlowFile> flowFiles = entry.getValue();
            for (MockFlowFile mockFlowFile : flowFiles) {
                validator.assertFlowFile((FlowFile)mockFlowFile);
            }
        }
    }

    public void assertAllFlowFiles(Relationship relationship, FlowFileValidator validator) {
        for (Map.Entry<Relationship, List<MockFlowFile>> entry : this.transferMap.entrySet()) {
            List<MockFlowFile> flowFiles = entry.getValue();
            Relationship rel = entry.getKey();
            for (MockFlowFile mockFlowFile : flowFiles) {
                if (!rel.equals((Object)relationship)) continue;
                validator.assertFlowFile((FlowFile)mockFlowFile);
            }
        }
    }

    public void clearTransferState() {
        this.transferMap.clear();
    }

    public void assertAllFlowFilesTransferred(Relationship relationship, int count) {
        this.assertAllFlowFilesTransferred(relationship);
        this.assertTransferCount(relationship, count);
    }

    public void assertAllFlowFilesTransferred(String relationship, int count) {
        this.assertAllFlowFilesTransferred(new Relationship.Builder().name(relationship).build(), count);
    }

    public int getRemovedCount() {
        return this.removedFlowFiles.size();
    }

    public ProvenanceReporter getProvenanceReporter() {
        return this.provenanceReporter;
    }

    public void setState(Map<String, String> state, Scope scope) throws IOException {
        this.stateManager.setState(state, scope);
    }

    public StateMap getState(Scope scope) throws IOException {
        return this.stateManager.getState(scope);
    }

    public boolean replaceState(StateMap oldValue, Map<String, String> newValue, Scope scope) throws IOException {
        return this.stateManager.replace(oldValue, newValue, scope);
    }

    public void clearState(Scope scope) throws IOException {
        this.stateManager.clear(scope);
    }

    public MockFlowFile penalize(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        MockFlowFile mockFlowFile = (MockFlowFile)flowFile;
        MockFlowFile newFlowFile = new MockFlowFile(mockFlowFile.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.setPenalized(true);
        this.penalized.add(newFlowFile);
        return newFlowFile;
    }

    public MockFlowFile unpenalize(FlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        MockFlowFile newFlowFile = new MockFlowFile(flowFile.getId(), (FlowFile)flowFile);
        this.currentVersions.put(newFlowFile.getId(), newFlowFile);
        newFlowFile.setPenalized(false);
        this.penalized.remove(newFlowFile);
        return newFlowFile;
    }

    public byte[] getContentAsByteArray(MockFlowFile flowFile) {
        flowFile = this.validateState((FlowFile)flowFile);
        return flowFile.getData();
    }

    boolean isFlowFileKnown(FlowFile flowFile) {
        FlowFile curFlowFile = (FlowFile)this.currentVersions.get(flowFile.getId());
        if (curFlowFile == null) {
            return false;
        }
        String curUuid = curFlowFile.getAttribute(CoreAttributes.UUID.key());
        String providedUuid = curFlowFile.getAttribute(CoreAttributes.UUID.key());
        return curUuid.equals(providedUuid);
    }
}

