/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.validation.AbstractValidationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.parameter.StandardParameterTokenList;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.ControllerServiceConfiguration;
import org.apache.nifi.util.MockControllerServiceLookup;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.MockPropertyValue;

public class MockValidationContext
extends MockControllerServiceLookup
implements ValidationContext,
ControllerServiceLookup {
    private final MockProcessContext context;
    private final Map<String, Boolean> expressionLanguageSupported;
    private final StateManager stateManager;
    private final VariableRegistry variableRegistry;
    private final Map<PropertyDescriptor, PropertyConfiguration> properties;
    private volatile boolean validateExpressions = true;

    public MockValidationContext(MockProcessContext processContext) {
        this(processContext, null, VariableRegistry.EMPTY_REGISTRY);
    }

    public MockValidationContext(MockProcessContext processContext, StateManager stateManager, VariableRegistry variableRegistry) {
        this.context = processContext;
        this.stateManager = stateManager;
        this.variableRegistry = variableRegistry;
        Map<PropertyDescriptor, String> properties = processContext.getProperties();
        this.expressionLanguageSupported = new HashMap<String, Boolean>(properties.size());
        for (PropertyDescriptor descriptor : properties.keySet()) {
            this.expressionLanguageSupported.put(descriptor.getName(), descriptor.isExpressionLanguageSupported());
        }
        this.properties = MockValidationContext.createPropertyConfigurationMap(processContext);
    }

    private static Map<PropertyDescriptor, PropertyConfiguration> createPropertyConfigurationMap(MockProcessContext processContext) {
        HashMap<PropertyDescriptor, PropertyConfiguration> configurationMap = new HashMap<PropertyDescriptor, PropertyConfiguration>();
        for (Map.Entry<String, String> entry : processContext.getAllProperties().entrySet()) {
            PropertyDescriptor descriptor = processContext.getPropertyDescriptor(entry.getKey());
            StandardParameterTokenList tokenList = new StandardParameterTokenList(entry.getValue(), Collections.emptyList());
            List parameterReferences = Collections.emptyList();
            PropertyConfiguration configuration = new PropertyConfiguration(entry.getValue(), (ParameterTokenList)tokenList, parameterReferences);
            configurationMap.put(descriptor, configuration);
        }
        return configurationMap;
    }

    public void setValidateExpressions(boolean validate) {
        this.validateExpressions = validate;
    }

    @Override
    public ControllerService getControllerService(String identifier) {
        return this.context.getControllerService(identifier);
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new MockPropertyValue(rawValue, this, null, true, this.variableRegistry);
    }

    public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
        return new StandardExpressionLanguageCompiler(this.variableRegistry, ParameterLookup.EMPTY);
    }

    public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
        MockProcessContext serviceProcessContext = new MockProcessContext(controllerService, this.context, this.stateManager, this.variableRegistry);
        MockValidationContext serviceValidationContext = new MockValidationContext(serviceProcessContext, this.stateManager, this.variableRegistry);
        serviceValidationContext.setValidateExpressions(this.validateExpressions);
        return serviceValidationContext;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        return this.context.getPropertyWithoutValidatingExpressions(property);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.context.getProperties();
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getAnnotationData() {
        return this.context.getAnnotationData();
    }

    @Override
    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.context.getControllerServiceIdentifiers(serviceType);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    @Override
    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.context.isControllerServiceEnabled(serviceIdentifier);
    }

    @Override
    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.context.isControllerServiceEnabled(service);
    }

    @Override
    public String getControllerServiceName(String serviceIdentifier) {
        ControllerServiceConfiguration configuration = this.context.getConfiguration(serviceIdentifier);
        return configuration == null ? null : serviceIdentifier;
    }

    public boolean isValidationRequired(ControllerService service) {
        return true;
    }

    @Override
    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.context.isControllerServiceEnabling(serviceIdentifier);
    }

    public boolean isExpressionLanguagePresent(String value) {
        if (value == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)value);
        return elRanges != null && !elRanges.isEmpty();
    }

    public boolean isExpressionLanguageSupported(String propertyName) {
        Boolean supported = this.expressionLanguageSupported.get(propertyName);
        return Boolean.TRUE.equals(supported);
    }

    public String getProcessGroupIdentifier() {
        return "unit test";
    }

    public Collection<String> getReferencedParameters(String propertyName) {
        String rawPropertyValue = this.context.getProperty(propertyName).getValue();
        boolean elSupported = this.isExpressionLanguageSupported(propertyName);
        ExpressionLanguageAwareParameterParser parser = elSupported ? new ExpressionLanguageAwareParameterParser() : new ExpressionLanguageAgnosticParameterParser();
        List references = parser.parseTokens(rawPropertyValue).toReferenceList();
        return references.stream().map(ParameterReference::getParameterName).collect(Collectors.toList());
    }

    public boolean isParameterDefined(String parameterName) {
        return true;
    }

    public boolean isParameterSet(String parameterName) {
        return true;
    }

    public boolean isDependencySatisfied(PropertyDescriptor propertyDescriptor, Function<String, PropertyDescriptor> propertyDescriptorLookup) {
        AbstractValidationContext abstractValidationContext = new AbstractValidationContext(ParameterLookup.EMPTY, this.properties){

            public ControllerServiceLookup getControllerServiceLookup() {
                return null;
            }

            public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
                return null;
            }

            public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
                return null;
            }

            public PropertyValue newPropertyValue(String value) {
                return null;
            }

            public Map<PropertyDescriptor, String> getProperties() {
                return null;
            }

            public String getAnnotationData() {
                return null;
            }

            public boolean isValidationRequired(ControllerService service) {
                return false;
            }

            public boolean isExpressionLanguagePresent(String value) {
                return false;
            }

            public boolean isExpressionLanguageSupported(String propertyName) {
                return false;
            }

            public String getProcessGroupIdentifier() {
                return null;
            }

            public Collection<String> getReferencedParameters(String propertyName) {
                return null;
            }

            public boolean isParameterDefined(String parameterName) {
                return false;
            }

            public boolean isParameterSet(String parameterName) {
                return false;
            }

            public PropertyValue getProperty(PropertyDescriptor descriptor) {
                return null;
            }

            public Map<String, String> getAllProperties() {
                return null;
            }
        };
        return abstractValidationContext.isDependencySatisfied(propertyDescriptor, propertyDescriptorLookup);
    }
}

