/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.nifi.repository.schema.ByteArrayCache;
import org.apache.nifi.repository.schema.NamedValue;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRecordWriter {
    public static final int MAX_ALLOWED_UTF_LENGTH = 65535;
    private static final Logger logger = LoggerFactory.getLogger(SchemaRecordWriter.class);
    private static final int CACHE_BUFFER_SIZE = 65536;
    private static final ByteArrayCache byteArrayCache = new ByteArrayCache(32, 65536);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecord(Record record, OutputStream out) throws IOException {
        out.write(1);
        byte[] buffer = byteArrayCache.checkOut();
        try {
            this.writeRecordFields(record, out, buffer);
        }
        finally {
            byteArrayCache.checkIn(buffer);
        }
    }

    private void writeRecordFields(Record record, OutputStream out, byte[] buffer) throws IOException {
        this.writeRecordFields(record, record.getSchema(), out, buffer);
    }

    private void writeRecordFields(Record record, RecordSchema schema, OutputStream out, byte[] buffer) throws IOException {
        DataOutputStream dos = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        for (RecordField field : schema.getFields()) {
            Object value = record.getFieldValue(field);
            try {
                this.writeFieldRepetitionAndValue(field, value, dos, buffer);
            }
            catch (Exception e) {
                throw new IOException("Failed to write field '" + field.getFieldName() + "'", e);
            }
        }
    }

    private void writeFieldRepetitionAndValue(RecordField field, Object value, DataOutputStream dos, byte[] buffer) throws IOException {
        switch (field.getRepetition()) {
            case EXACTLY_ONE: {
                if (value == null) {
                    throw new IllegalArgumentException("Record does not have a value for the '" + field.getFieldName() + "' but the field is required");
                }
                this.writeFieldValue(field, value, dos, buffer);
                break;
            }
            case ZERO_OR_MORE: {
                if (value == null) {
                    dos.writeInt(0);
                    break;
                }
                if (!(value instanceof Collection)) {
                    throw new IllegalArgumentException("Record contains a value of type '" + value.getClass() + "' for the '" + field.getFieldName() + "' but expected a Collection because the Repetition for the field is " + (Object)((Object)field.getRepetition()));
                }
                Collection collection = (Collection)value;
                dos.writeInt(collection.size());
                for (Object fieldValue : collection) {
                    this.writeFieldValue(field, fieldValue, dos, buffer);
                }
                break;
            }
            case ZERO_OR_ONE: {
                if (value == null) {
                    dos.write(0);
                    break;
                }
                dos.write(1);
                this.writeFieldValue(field, value, dos, buffer);
            }
        }
    }

    private boolean allSingleByteInUtf8(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch >= '\u0001' && ch <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private void writeFieldValue(RecordField field, Object value, DataOutputStream out, byte[] buffer) throws IOException {
        switch (field.getFieldType()) {
            case BOOLEAN: {
                out.writeBoolean((Boolean)value);
                break;
            }
            case BYTE_ARRAY: {
                byte[] array = (byte[])value;
                out.writeInt(array.length);
                out.write(array);
                break;
            }
            case INT: {
                out.writeInt((Integer)value);
                break;
            }
            case LONG: {
                out.writeLong((Long)value);
                break;
            }
            case STRING: {
                this.writeUTFLimited(out, (String)value, field.getFieldName());
                break;
            }
            case LONG_STRING: {
                String string = (String)value;
                int length = string.length();
                if (length <= buffer.length && this.allSingleByteInUtf8(string)) {
                    out.writeInt(length);
                    for (int i = 0; i < length; ++i) {
                        char ch = string.charAt(i);
                        buffer[i] = (byte)ch;
                    }
                    out.write(buffer, 0, length);
                    break;
                }
                byte[] charArray = ((String)value).getBytes(StandardCharsets.UTF_8);
                out.writeInt(charArray.length);
                out.write(charArray);
                break;
            }
            case MAP: {
                Map map = (Map)value;
                out.writeInt(map.size());
                List<RecordField> subFields = field.getSubFields();
                RecordField keyField = subFields.get(0);
                RecordField valueField = subFields.get(1);
                for (Map.Entry entry : map.entrySet()) {
                    this.writeFieldRepetitionAndValue(keyField, entry.getKey(), out, buffer);
                    this.writeFieldRepetitionAndValue(valueField, entry.getValue(), out, buffer);
                }
                break;
            }
            case UNION: {
                NamedValue namedValue = (NamedValue)value;
                this.writeUTFLimited(out, namedValue.getName(), field.getFieldName());
                Record childRecord = (Record)namedValue.getValue();
                this.writeRecordFields(childRecord, out, buffer);
                break;
            }
            case COMPLEX: {
                Record record = (Record)value;
                this.writeRecordFields(record, out, buffer);
            }
        }
    }

    private void writeUTFLimited(DataOutputStream out, String utfString, String fieldName) throws IOException {
        try {
            out.writeUTF(utfString);
        }
        catch (UTFDataFormatException e) {
            String truncated = utfString.substring(0, SchemaRecordWriter.getCharsInUTF8Limit(utfString, 65535));
            logger.warn("Truncating repository record value for field '{}'!  Attempted to write {} chars that encode to a UTF8 byte length greater than supported maximum ({}), truncating to {} chars.", new Object[]{fieldName == null ? "" : fieldName, utfString.length(), 65535, truncated.length()});
            if (logger.isDebugEnabled()) {
                logger.warn("String value was:\n{}", (Object)truncated);
            }
            out.writeUTF(truncated);
        }
    }

    static int getCharsInUTF8Limit(String str, int utf8Limit) {
        int charsInOriginal = str.length();
        int bytesInUTF8 = 0;
        for (int i = 0; i < charsInOriginal; ++i) {
            char curr = str.charAt(i);
            bytesInUTF8 = curr < '\u0080' ? ++bytesInUTF8 : (curr < '\u0800' ? (bytesInUTF8 += 2) : (bytesInUTF8 += 3));
            if (bytesInUTF8 <= utf8Limit) continue;
            return i;
        }
        return charsInOriginal;
    }
}

