/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public enum KeyDerivationFunction {
    NIFI_LEGACY("NiFi Legacy KDF", "MD5 @ 1000 iterations"),
    OPENSSL_EVP_BYTES_TO_KEY("OpenSSL EVP_BytesToKey", "Single iteration MD5 compatible with PKCS#5 v1.5"),
    BCRYPT("Bcrypt", "Bcrypt with configurable work factor. See Admin Guide"),
    SCRYPT("Scrypt", "Scrypt with configurable cost parameters. See Admin Guide"),
    PBKDF2("PBKDF2", "PBKDF2 with configurable hash function and iteration count. See Admin Guide"),
    NONE("None", "The cipher is given a raw key conforming to the algorithm specifications");

    private final String name;
    private final String description;

    private KeyDerivationFunction(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isStrongKDF() {
        return this.name.equals(KeyDerivationFunction.BCRYPT.name) || this.name.equals(KeyDerivationFunction.SCRYPT.name) || this.name.equals(KeyDerivationFunction.PBKDF2.name);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("KDF Name", (Object)this.name);
        builder.append("Description", (Object)this.description);
        return builder.toString();
    }
}

