/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;

public class SocketChannelInputStream
extends InputStream {
    private static final long CHANNEL_EMPTY_WAIT_NANOS = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS);
    private final SocketChannel channel;
    private volatile int timeoutMillis = 30000;
    private final ByteBuffer oneByteBuffer = ByteBuffer.allocate(1);
    private Byte bufferedByte = null;

    public SocketChannelInputStream(SocketChannel socketChannel) throws IOException {
        socketChannel.configureBlocking(false);
        this.channel = socketChannel;
    }

    public void setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void consume() throws IOException {
        int bytesRead;
        this.channel.shutdownInput();
        byte[] b = new byte[4096];
        ByteBuffer buffer = ByteBuffer.wrap(b);
        do {
            bytesRead = this.channel.read(buffer);
            buffer.flip();
        } while (bytesRead > 0);
    }

    @Override
    public int read() throws IOException {
        int bytesRead;
        if (this.bufferedByte != null) {
            int retVal = this.bufferedByte & 0xFF;
            this.bufferedByte = null;
            return retVal;
        }
        this.oneByteBuffer.flip();
        this.oneByteBuffer.clear();
        long maxTime = System.currentTimeMillis() + (long)this.timeoutMillis;
        do {
            if ((bytesRead = this.channel.read(this.oneByteBuffer)) != 0) continue;
            if (System.currentTimeMillis() > maxTime) {
                throw new SocketTimeoutException("Timed out reading from socket");
            }
            try {
                TimeUnit.NANOSECONDS.sleep(CHANNEL_EMPTY_WAIT_NANOS);
            }
            catch (InterruptedException e) {
                this.close();
                Thread.currentThread().interrupt();
                throw new ClosedByInterruptException();
            }
        } while (bytesRead == 0);
        if (bytesRead == -1) {
            return -1;
        }
        this.oneByteBuffer.flip();
        return this.oneByteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (this.bufferedByte != null) {
            byte retVal = this.bufferedByte;
            this.bufferedByte = null;
            b[off] = retVal;
            return 1;
        }
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        long maxTime = System.currentTimeMillis() + (long)this.timeoutMillis;
        do {
            if ((bytesRead = this.channel.read(buffer)) != 0) continue;
            if (System.currentTimeMillis() > maxTime) {
                throw new SocketTimeoutException("Timed out reading from socket");
            }
            try {
                TimeUnit.NANOSECONDS.sleep(CHANNEL_EMPTY_WAIT_NANOS);
            }
            catch (InterruptedException e) {
                this.close();
                Thread.currentThread().interrupt();
                throw new ClosedByInterruptException();
            }
        } while (bytesRead == 0);
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        if (this.bufferedByte != null) {
            return 1;
        }
        this.isDataAvailable();
        return this.bufferedByte == null ? 0 : 1;
    }

    public boolean isDataAvailable() throws IOException {
        if (this.bufferedByte != null) {
            return true;
        }
        this.oneByteBuffer.flip();
        this.oneByteBuffer.clear();
        int bytesRead = this.channel.read(this.oneByteBuffer);
        if (bytesRead == -1) {
            throw new EOFException("Peer has closed the stream");
        }
        if (bytesRead > 0) {
            this.oneByteBuffer.flip();
            this.bufferedByte = this.oneByteBuffer.get();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

