/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.net.URI;
import java.util.Map;

public class ClientUtils {
    private final Client client;

    public ClientUtils(Client client) {
        this.client = client;
    }

    public ClientResponse get(URI uri) throws ClientHandlerException, UniformInterfaceException {
        return this.get(uri, null);
    }

    public ClientResponse get(URI uri, Map<String, String> queryParams) throws ClientHandlerException, UniformInterfaceException {
        WebResource webResource = this.client.resource(uri);
        if (queryParams != null) {
            for (Map.Entry<String, String> queryEntry : queryParams.entrySet()) {
                webResource = webResource.queryParam(queryEntry.getKey(), queryEntry.getValue());
            }
        }
        return (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
    }

    public ClientResponse post(URI uri, Object entity) throws ClientHandlerException, UniformInterfaceException {
        WebResource.Builder resourceBuilder = (WebResource.Builder)this.client.resource(uri).accept(new String[]{"application/json"}).type("application/json");
        if (entity != null) {
            resourceBuilder = (WebResource.Builder)resourceBuilder.entity(entity);
        }
        return (ClientResponse)resourceBuilder.post(ClientResponse.class);
    }

    public ClientResponse post(URI uri, Map<String, String> formData) throws ClientHandlerException, UniformInterfaceException {
        MultivaluedMapImpl entity = new MultivaluedMapImpl();
        for (String key : formData.keySet()) {
            entity.add(key, formData.get(key));
        }
        WebResource.Builder resourceBuilder = (WebResource.Builder)this.client.resource(uri).accept(new String[]{"application/json"}).type("application/x-www-form-urlencoded");
        if (!entity.isEmpty()) {
            resourceBuilder = (WebResource.Builder)resourceBuilder.entity((Object)entity);
        }
        return (ClientResponse)resourceBuilder.post(ClientResponse.class);
    }

    public ClientResponse head(URI uri) throws ClientHandlerException, UniformInterfaceException {
        WebResource webResource = this.client.resource(uri);
        return webResource.head();
    }
}

