/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.web.util.ObjectMapperResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebUtils {
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);
    static final ReadWriteLock lock = new ReentrantReadWriteLock();

    private WebUtils() {
    }

    public static Client createClient(ClientConfig config) {
        return WebUtils.createClientHelper(config, null);
    }

    public static Client createClient(ClientConfig config, SSLContext ctx) {
        return WebUtils.createClientHelper(config, ctx);
    }

    private static Client createClientHelper(ClientConfig config, SSLContext ctx) {
        ClientConfig finalConfig;
        Object object = finalConfig = config == null ? new DefaultClientConfig() : config;
        if (ctx != null && StringUtils.isBlank((CharSequence)((String)finalConfig.getProperty("com.sun.jersey.client.impl.urlconnection.httpsProperties")))) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession ssls) {
                    try {
                        for (Certificate peerCertificate : ssls.getPeerCertificates()) {
                            X509Certificate x509Cert;
                            List subjectAltNames;
                            if (!(peerCertificate instanceof X509Certificate) || !(subjectAltNames = CertificateUtils.getSubjectAlternativeNames((X509Certificate)(x509Cert = (X509Certificate)peerCertificate))).contains(hostname.toLowerCase())) continue;
                            return true;
                        }
                    }
                    catch (CertificateParsingException | SSLPeerUnverifiedException ex) {
                        logger.warn("Hostname Verification encountered exception verifying hostname due to: " + ex, (Throwable)ex);
                    }
                    return false;
                }
            };
            finalConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hostnameVerifier, ctx));
        }
        finalConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        finalConfig.getClasses().add(ObjectMapperResolver.class);
        return Client.create((ClientConfig)finalConfig);
    }
}

