/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class ClientUtils {
    private final Client client;

    public ClientUtils(Client client) {
        this.client = client;
    }

    public Response get(URI uri) {
        return this.get(uri, null);
    }

    public Response get(URI uri, Map<String, String> queryParams) {
        WebTarget webTarget = this.client.target(uri);
        if (queryParams != null) {
            for (Map.Entry<String, String> queryEntry : queryParams.entrySet()) {
                webTarget = webTarget.queryParam(queryEntry.getKey(), new Object[]{queryEntry.getValue()});
            }
        }
        return webTarget.request().accept(new String[]{"application/json"}).get();
    }

    public Response post(URI uri, Object entity) {
        Invocation.Builder builder = this.client.target(uri).request().accept(new String[]{"application/json"});
        return builder.post(Entity.json((Object)entity));
    }

    public Response post(URI uri, Map<String, String> formData) {
        MultivaluedHashMap entity = new MultivaluedHashMap();
        for (String key : formData.keySet()) {
            entity.add((Object)key, (Object)formData.get(key));
        }
        Invocation.Builder builder = this.client.target(uri).request().accept(new String[]{"application/json"});
        return builder.post(Entity.form((MultivaluedMap)entity));
    }

    public Response head(URI uri) {
        WebTarget webTarget = this.client.target(uri);
        return webTarget.request().head();
    }
}

