/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.web.util.ObjectMapperResolver;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebUtils {
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);
    static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final String PROXY_CONTEXT_PATH_HTTP_HEADER = "X-ProxyContextPath";
    private static final String FORWARDED_CONTEXT_HTTP_HEADER = "X-Forwarded-Context";

    private WebUtils() {
    }

    public static Client createClient(ClientConfig config) {
        return WebUtils.createClientHelper(config, null);
    }

    public static Client createClient(ClientConfig config, SSLContext ctx) {
        return WebUtils.createClientHelper(config, ctx);
    }

    private static Client createClientHelper(ClientConfig config, SSLContext ctx) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (config != null) {
            clientBuilder = clientBuilder.withConfig((Configuration)config);
        }
        if (ctx != null) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession ssls) {
                    try {
                        for (Certificate peerCertificate : ssls.getPeerCertificates()) {
                            X509Certificate x509Cert;
                            List subjectAltNames;
                            if (!(peerCertificate instanceof X509Certificate) || !(subjectAltNames = CertificateUtils.getSubjectAlternativeNames((X509Certificate)(x509Cert = (X509Certificate)peerCertificate))).contains(hostname.toLowerCase())) continue;
                            return true;
                        }
                    }
                    catch (CertificateParsingException | SSLPeerUnverifiedException ex) {
                        logger.warn("Hostname Verification encountered exception verifying hostname due to: " + ex, (Throwable)ex);
                    }
                    return false;
                }
            };
            clientBuilder = clientBuilder.sslContext(ctx).hostnameVerifier(hostnameVerifier);
        }
        clientBuilder = (ClientBuilder)((ClientBuilder)clientBuilder.register(ObjectMapperResolver.class)).register(JacksonJaxbJsonProvider.class);
        return clientBuilder.build();
    }

    public static String getResourcePath(URI uri, HttpServletRequest request, String whitelistedContextPaths) throws UriBuilderException {
        String resourcePath = uri.getPath();
        String determinedContextPath = WebUtils.determineContextPath(request);
        if (StringUtils.isNotBlank((CharSequence)(determinedContextPath = WebUtils.normalizeContextPath(determinedContextPath)))) {
            WebUtils.verifyContextPath(whitelistedContextPaths, determinedContextPath);
            resourcePath = determinedContextPath + resourcePath;
        }
        return resourcePath;
    }

    public static void verifyContextPath(String whitelistedContextPaths, String determinedContextPath) throws UriBuilderException {
        if (StringUtils.isBlank((CharSequence)determinedContextPath)) {
            return;
        }
        List<String> individualContextPaths = Arrays.asList(StringUtils.split((String)whitelistedContextPaths, (String)","));
        if (!individualContextPaths.contains(determinedContextPath)) {
            String msg = "The provided context path [" + determinedContextPath + "] was not whitelisted [" + whitelistedContextPaths + "]";
            logger.error(msg);
            throw new UriBuilderException(msg);
        }
    }

    public static String normalizeContextPath(String determinedContextPath) {
        if (StringUtils.isNotBlank((CharSequence)determinedContextPath)) {
            if (!determinedContextPath.startsWith("/")) {
                determinedContextPath = "/" + determinedContextPath;
            }
            if (determinedContextPath.endsWith("/")) {
                determinedContextPath = determinedContextPath.substring(0, determinedContextPath.length() - 1);
            }
            return determinedContextPath;
        }
        return "";
    }

    public static String determineContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String proxyContextPath = request.getHeader(PROXY_CONTEXT_PATH_HTTP_HEADER);
        String forwardedContext = request.getHeader(FORWARDED_CONTEXT_HTTP_HEADER);
        logger.debug("Context path: " + contextPath);
        String determinedContextPath = "";
        if (WebUtils.anyNotBlank(proxyContextPath, forwardedContext)) {
            logger.debug(String.format("On the request, the following context paths were parsed from headers:\n\t X-ProxyContextPath: %s\n\tX-Forwarded-Context: %s", proxyContextPath, forwardedContext));
            determinedContextPath = StringUtils.isNotBlank((CharSequence)proxyContextPath) ? proxyContextPath : forwardedContext;
        }
        logger.debug("Determined context path: " + determinedContextPath);
        return determinedContextPath;
    }

    private static boolean anyNotBlank(String ... strings) {
        for (String s : strings) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            return true;
        }
        return false;
    }
}

