/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.bucket.BucketItemType;
import org.apache.nifi.registry.flow.VersionedFlow;

public class BucketItemDeserializer
extends StdDeserializer<BucketItem[]> {
    public BucketItemDeserializer() {
        super(BucketItem[].class);
    }

    public BucketItem[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode arrayNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayList<VersionedFlow> bucketItems = new ArrayList<VersionedFlow>();
        Iterator nodeIter = arrayNode.elements();
        block5: while (nodeIter.hasNext()) {
            BucketItemType bucketItemType;
            JsonNode node = (JsonNode)nodeIter.next();
            String type = node.get("type").asText();
            if (StringUtils.isBlank((CharSequence)type)) {
                throw new IllegalStateException("BucketItem type cannot be null or blank");
            }
            try {
                bucketItemType = BucketItemType.valueOf((String)type);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unknown type for BucketItem: " + type, e);
            }
            switch (bucketItemType) {
                case Flow: {
                    VersionedFlow versionedFlow = (VersionedFlow)jsonParser.getCodec().treeToValue((TreeNode)node, VersionedFlow.class);
                    bucketItems.add(versionedFlow);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown type for BucketItem");
        }
        return bucketItems.toArray(new BucketItem[bucketItems.size()]);
    }
}

