/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.client.response;

import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;
import org.apache.oltu.oauth2.common.token.OAuthToken;
import org.apache.oltu.oauth2.common.utils.JSONUtils;

public class OAuthJSONAccessTokenResponse
extends OAuthAccessTokenResponse {
    @Override
    public String getAccessToken() {
        return this.getParam("access_token");
    }

    @Override
    public Long getExpiresIn() {
        String value = this.getParam("expires_in");
        return value == null ? null : Long.valueOf(value);
    }

    @Override
    public String getScope() {
        return this.getParam("scope");
    }

    @Override
    public OAuthToken getOAuthToken() {
        return new BasicOAuthToken(this.getAccessToken(), this.getExpiresIn(), this.getRefreshToken(), this.getScope());
    }

    @Override
    public String getRefreshToken() {
        return this.getParam("refresh_token");
    }

    @Override
    protected void setBody(String body) throws OAuthProblemException {
        try {
            this.body = body;
            this.parameters = JSONUtils.parseJSON(body);
        }
        catch (Throwable e) {
            throw OAuthProblemException.error("unsupported_response_type", "Invalid response! Response body is not application/json encoded");
        }
    }

    @Override
    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    protected void setResponseCode(int code) {
        this.responseCode = code;
    }
}

