/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.PojoConfiguration;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.Service;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.jpa.unit.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.SuperProperties;
import org.apache.xbean.finder.IAnnotationFinder;

public class AppModule
implements DeploymentModule {
    public static final boolean DELEGATE_FIRST_DEFAULT = SystemInstance.get().getOptions().get("openejb.classloader.delegate-first", ParentClassLoaderFinder.Helper.get() != ClassLoader.getSystemClassLoader());
    private final Properties properties = new SuperProperties().caseInsensitive(true);
    private final Application application;
    private final ValidationContext validation;
    private final List<URL> additionalLibraries = new ArrayList<URL>();
    private final List<ConnectorModule> connectorModules = new ArrayList<ConnectorModule>();
    private final List<WebModule> webModules = new ArrayList<WebModule>();
    private final List<ClientModule> clientModules = new ArrayList<ClientModule>();
    private final List<EjbModule> ejbModules = new ArrayList<EjbModule>();
    private final List<PersistenceModule> persistenceModules = new ArrayList<PersistenceModule>();
    private final Map<String, TransactionType> txTypeByUnit = new HashMap<String, TransactionType>();
    private final Collection<Resource> resources = new HashSet<Resource>();
    private final Collection<Service> services = new HashSet<Service>();
    private final ClassLoader classLoader;
    private EntityMappings cmpMappings;
    private final Map<String, Object> altDDs = new HashMap<String, Object>();
    private final Set<String> watchedResources = new TreeSet<String>();
    private final boolean standaloneModule;
    private boolean delegateFirst = DELEGATE_FIRST_DEFAULT;
    private final Set<String> additionalLibMbeans = new TreeSet<String>();
    private final Collection<String> jaxRsProviders = new TreeSet<String>();
    private final Map<String, PojoConfiguration> pojoConfigurations = new HashMap<String, PojoConfiguration>();
    private IAnnotationFinder earLibFinder;
    private DeploymentModule.ID id;
    private boolean webapp;

    public AppModule(ClassLoader classLoader, String jarLocation) {
        this(classLoader, jarLocation, null, false);
    }

    public <T extends DeploymentModule> AppModule(T ... modules) {
        T firstModule = modules[0];
        this.standaloneModule = true;
        this.classLoader = firstModule.getClassLoader();
        this.application = new Application(firstModule.getModuleId());
        this.id = new DeploymentModule.ID(null, (NamedModule)this.application, null, firstModule.getFile(), firstModule.getModuleUri(), this);
        this.validation = new ValidationContext(this);
        for (T module : modules) {
            Class<?> type = module.getClass();
            if (type == EjbModule.class) {
                this.getEjbModules().add((EjbModule)module);
                continue;
            }
            if (type == ClientModule.class) {
                this.getClientModules().add((ClientModule)module);
                continue;
            }
            if (type == ConnectorModule.class) {
                this.getConnectorModules().add((ConnectorModule)module);
                continue;
            }
            if (type == WebModule.class) {
                this.getWebModules().add((WebModule)module);
                continue;
            }
            if (type == PersistenceModule.class) {
                this.addPersistenceModule((PersistenceModule)module);
                continue;
            }
            throw new IllegalArgumentException("Unknown module type: " + type.getName());
        }
    }

    public boolean isDelegateFirst() {
        return this.delegateFirst;
    }

    public void setDelegateFirst(boolean delegateFirst) {
        this.delegateFirst = delegateFirst;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public AppModule appModule() {
        return this;
    }

    public AppModule(ClassLoader classLoader, String jarLocation, Application application, boolean standaloneModule) {
        this.classLoader = classLoader;
        this.application = application;
        File file = jarLocation == null ? null : new File(jarLocation);
        this.id = new DeploymentModule.ID(null, (NamedModule)application, null, file, null, this);
        this.validation = new ValidationContext(this);
        this.standaloneModule = standaloneModule;
    }

    public Set<String> getAdditionalLibMbeans() {
        return this.additionalLibMbeans;
    }

    @Override
    public boolean isStandaloneModule() {
        return this.standaloneModule;
    }

    @Override
    public void setStandaloneModule(boolean isStandalone) {
    }

    @Override
    public ValidationContext getValidation() {
        return this.validation;
    }

    public boolean hasWarnings() {
        if (this.validation.hasWarnings()) {
            return true;
        }
        for (EjbModule ejbModule : this.ejbModules) {
            if (!ejbModule.getValidation().hasWarnings()) continue;
            return true;
        }
        for (ClientModule clientModule : this.clientModules) {
            if (!clientModule.getValidation().hasWarnings()) continue;
            return true;
        }
        for (ConnectorModule connectorModule : this.connectorModules) {
            if (!connectorModule.getValidation().hasWarnings()) continue;
            return true;
        }
        for (WebModule webModule : this.webModules) {
            if (!webModule.getValidation().hasWarnings()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFailures() {
        if (this.validation.hasFailures()) {
            return true;
        }
        for (EjbModule ejbModule : this.ejbModules) {
            if (!ejbModule.getValidation().hasFailures()) continue;
            return true;
        }
        for (ClientModule clientModule : this.clientModules) {
            if (!clientModule.getValidation().hasFailures()) continue;
            return true;
        }
        for (ConnectorModule connectorModule : this.connectorModules) {
            if (!connectorModule.getValidation().hasFailures()) continue;
            return true;
        }
        for (WebModule webModule : this.webModules) {
            if (!webModule.getValidation().hasFailures()) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        if (this.validation.hasErrors()) {
            return true;
        }
        for (EjbModule ejbModule : this.ejbModules) {
            if (!ejbModule.getValidation().hasErrors()) continue;
            return true;
        }
        for (ClientModule clientModule : this.clientModules) {
            if (!clientModule.getValidation().hasErrors()) continue;
            return true;
        }
        for (ConnectorModule connectorModule : this.connectorModules) {
            if (!connectorModule.getValidation().hasErrors()) continue;
            return true;
        }
        for (WebModule webModule : this.webModules) {
            if (!webModule.getValidation().hasErrors()) continue;
            return true;
        }
        return false;
    }

    public List<ValidationContext> getValidationContexts() {
        ArrayList<ValidationContext> contexts = new ArrayList<ValidationContext>();
        contexts.add(this.getValidation());
        for (EjbModule ejbModule : this.ejbModules) {
            contexts.add(ejbModule.getValidation());
        }
        for (ClientModule clientModule : this.clientModules) {
            contexts.add(clientModule.getValidation());
        }
        for (ConnectorModule connectorModule : this.connectorModules) {
            contexts.add(connectorModule.getValidation());
        }
        for (WebModule webModule : this.webModules) {
            contexts.add(webModule.getValidation());
        }
        return contexts;
    }

    @Override
    public String getJarLocation() {
        return this.id.getLocation() != null ? this.id.getLocation().getAbsolutePath() : null;
    }

    public void setModuleId(String moduleId) {
        this.id = new DeploymentModule.ID(null, (NamedModule)this.application, moduleId, this.id.getLocation(), this.id.getUri(), this);
    }

    @Override
    public String getModuleId() {
        return this.id.getName();
    }

    @Override
    public File getFile() {
        return this.id.getLocation();
    }

    @Override
    public URI getModuleUri() {
        return this.id.getUri();
    }

    @Override
    public Map<String, Object> getAltDDs() {
        return this.altDDs;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Application getApplication() {
        return this.application;
    }

    public List<ClientModule> getClientModules() {
        return this.clientModules;
    }

    public List<EjbModule> getEjbModules() {
        return this.ejbModules;
    }

    public List<PersistenceModule> getPersistenceModules() {
        return this.persistenceModules;
    }

    public List<URL> getAdditionalLibraries() {
        return this.additionalLibraries;
    }

    public EntityMappings getCmpMappings() {
        return this.cmpMappings;
    }

    public void setCmpMappings(EntityMappings cmpMappings) {
        this.cmpMappings = cmpMappings;
    }

    public List<ConnectorModule> getConnectorModules() {
        return this.connectorModules;
    }

    public List<WebModule> getWebModules() {
        return this.webModules;
    }

    @Override
    public Set<String> getWatchedResources() {
        return this.watchedResources;
    }

    public Collection<Resource> getResources() {
        return this.resources;
    }

    public Collection<Service> getServices() {
        return this.services;
    }

    public Collection<DeploymentModule> getDeploymentModule() {
        ArrayList<DeploymentModule> modules = new ArrayList<DeploymentModule>();
        modules.addAll(this.ejbModules);
        modules.addAll(this.webModules);
        modules.addAll(this.connectorModules);
        modules.addAll(this.clientModules);
        return modules;
    }

    public String toString() {
        return "AppModule{moduleId='" + this.id.getName() + '\'' + '}';
    }

    public void setStandloneWebModule() {
        this.webapp = true;
    }

    public boolean isWebapp() {
        return this.webapp;
    }

    public Collection<String> getJaxRsProviders() {
        return this.jaxRsProviders;
    }

    public void addPersistenceModule(PersistenceModule root) {
        this.persistenceModules.add(root);
        Persistence persistence = root.getPersistence();
        for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
            this.txTypeByUnit.put(unit.getName(), unit.getTransactionType());
        }
    }

    public void addPersistenceModules(Collection<PersistenceModule> roots) {
        for (PersistenceModule root : roots) {
            this.addPersistenceModule(root);
        }
    }

    public TransactionType getTransactionType(String unit) {
        if ((unit == null || unit.isEmpty()) && this.txTypeByUnit.size() == 1) {
            return this.txTypeByUnit.values().iterator().next();
        }
        TransactionType type = this.txTypeByUnit.get(unit);
        if (type == null) {
            type = TransactionType.JTA;
        }
        return type;
    }

    public Map<String, PojoConfiguration> getPojoConfigurations() {
        return this.pojoConfigurations;
    }

    public IAnnotationFinder getEarLibFinder() {
        return this.earLibFinder;
    }

    public void setEarLibFinder(IAnnotationFinder earLibFinder) {
        this.earLibFinder = earLibFinder;
    }
}

