/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.openejb.EnvProps;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.UrlComparator;

public class ConfUtils {
    public static URL getConfResource(String name) {
        URL resource = ConfUtils.getResource(name);
        if (!EnvProps.extractConfigurationFiles()) {
            return resource;
        }
        try {
            File loginConfig = ConfUtils.install(resource, name);
            if (loginConfig != null) {
                resource = loginConfig.toURI().toURL();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resource;
    }

    public static URL getResource(String name) {
        Enumeration<URL> resources = null;
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources(name);
        }
        catch (IOException e) {
            return Thread.currentThread().getContextClassLoader().getResource(name);
        }
        URL resource = ConfUtils.select(resources);
        return resource;
    }

    private static URL select(Enumeration<URL> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<URL> urls = Collections.list(enumeration);
        if (urls.size() == 0) {
            return null;
        }
        if (urls.size() == 1) {
            return urls.get(0);
        }
        Collections.sort(urls, new UrlComparator(SystemInstance.get().getBase().getDirectory()));
        return urls.get(0);
    }

    public static File install(String source, String name) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL resource = cl.getResource(source);
        return ConfUtils.install(resource, name, false);
    }

    public static File install(URL resource, String name) throws IOException {
        return ConfUtils.install(resource, name, false);
    }

    public static File install(URL resource, String name, boolean overwrite) throws IOException {
        if (resource == null) {
            return null;
        }
        SystemInstance system = SystemInstance.get();
        File conf = system.getConf(null);
        if (conf != null && !conf.exists()) {
            return null;
        }
        File file = new File(conf, name);
        if (file.exists() && !overwrite) {
            return file;
        }
        IO.copy(IO.read(resource), file);
        return file;
    }
}

