/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HTTPMethodSpec {
    private static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"};
    private static final int[] HTTP_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64};
    static final int NA = 0;
    static final int INTEGRAL = 1;
    static final int CONFIDENTIAL = 2;
    static final int NONE = 3;
    private final int mask;
    private final String[] extensionMethods;
    private final boolean isExcluded;
    private final int transport;
    private String actions;
    private static final String[] NO_METHODS = new String[0];
    private static final Pattern TOKEN_PATTERN = Pattern.compile("[!-~&&[^\\(\\)\\<\\>@,;:\\\\\"/\\[\\]\\?=\\{\\}]]*");

    public HTTPMethodSpec(String[] HTTPMethods) {
        this(HTTPMethods, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPMethodSpec(String name, boolean parseTransportType) {
        if (parseTransportType) {
            if (name == null || name.length() == 0) {
                this.transport = 3;
            } else {
                String[] tokens = name.split(":", 2);
                if (tokens.length == 2) {
                    if (tokens[1].equals("NONE")) {
                        this.transport = 3;
                    } else if (tokens[1].equals("INTEGRAL")) {
                        this.transport = 1;
                    } else {
                        if (!tokens[1].equals("CONFIDENTIAL")) throw new IllegalArgumentException("Invalid transportType: " + tokens[1]);
                        this.transport = 2;
                    }
                } else {
                    this.transport = 3;
                }
                name = tokens[0];
            }
        } else {
            this.transport = 0;
        }
        if (name == null || name.length() == 0) {
            this.mask = 0;
            this.extensionMethods = NO_METHODS;
            this.isExcluded = true;
            return;
        } else {
            ArrayList<String> extensions = null;
            this.isExcluded = name.charAt(0) == '!';
            if (this.isExcluded) {
                name = name.substring(1);
            }
            int tmpMask = 0;
            if (name.length() > 0) {
                String[] methods = name.split(",", -1);
                for (int i = 0; i < methods.length; ++i) {
                    boolean found = false;
                    for (int j = 0; j < HTTP_METHODS.length; ++j) {
                        if (!methods[i].equals(HTTP_METHODS[j])) continue;
                        tmpMask |= HTTP_MASKS[j];
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.checkToken(methods[i]);
                    if (extensions == null) {
                        extensions = new ArrayList<String>(methods.length);
                    }
                    this.add(extensions, methods[i]);
                }
            }
            this.mask = tmpMask;
            this.extensionMethods = extensions == null ? NO_METHODS : extensions.toArray(new String[extensions.size()]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPMethodSpec(String[] HTTPMethods, String transport) {
        boolean parseTransportType;
        boolean bl = parseTransportType = transport != null;
        if (HTTPMethods == null || HTTPMethods.length == 0) {
            this.mask = 0;
            this.extensionMethods = NO_METHODS;
            this.isExcluded = true;
        } else {
            int tmpMask = 0;
            this.isExcluded = false;
            ArrayList<String> extensions = null;
            for (int i = 0; i < HTTPMethods.length; ++i) {
                boolean found = false;
                for (int j = 0; j < HTTP_METHODS.length; ++j) {
                    if (!HTTPMethods[i].equals(HTTP_METHODS[j])) continue;
                    tmpMask |= HTTP_MASKS[j];
                    found = true;
                    break;
                }
                if (found) continue;
                this.checkToken(HTTPMethods[i]);
                if (extensions == null) {
                    extensions = new ArrayList<String>(HTTPMethods.length);
                }
                this.add(extensions, HTTPMethods[i]);
            }
            this.mask = tmpMask;
            this.extensionMethods = extensions == null ? NO_METHODS : extensions.toArray(new String[extensions.size()]);
        }
        if (parseTransportType) {
            if (transport.length() == 0 || transport.equals("NONE")) {
                this.transport = 3;
                return;
            } else if (transport.equals("INTEGRAL")) {
                this.transport = 1;
                return;
            } else {
                if (!transport.equals("CONFIDENTIAL")) throw new IllegalArgumentException("Invalid transport");
                this.transport = 2;
            }
            return;
        } else {
            this.transport = 0;
        }
    }

    public HTTPMethodSpec(String singleMethod, int transport) {
        int tmpMask = 0;
        for (int j = 0; j < HTTP_METHODS.length; ++j) {
            if (!HTTP_METHODS[j].equals(singleMethod)) continue;
            tmpMask = HTTP_MASKS[j];
            break;
        }
        if (tmpMask == 0) {
            this.checkToken(singleMethod);
            this.extensionMethods = new String[]{singleMethod};
        } else {
            this.extensionMethods = NO_METHODS;
        }
        this.mask = tmpMask;
        this.isExcluded = false;
        this.transport = transport;
    }

    private void checkToken(String method) {
        if (!TOKEN_PATTERN.matcher(method).matches()) {
            throw new IllegalArgumentException("Invalid HTTPMethodSpec");
        }
    }

    private void add(ArrayList<String> extensions, String httpMethod) {
        for (int i = 0; i < extensions.size(); ++i) {
            String existingMethod = extensions.get(i);
            int compare = existingMethod.compareTo(httpMethod);
            if (compare == 0) {
                return;
            }
            if (compare <= 0) continue;
            extensions.add(i, httpMethod);
            return;
        }
        extensions.add(httpMethod);
    }

    public boolean equals(HTTPMethodSpec o) {
        return this.mask == o.mask && this.transport == o.transport && this.isExcluded == o.isExcluded && Arrays.equals(this.extensionMethods, o.extensionMethods);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getActions() {
        StringBuilder buffer;
        if (this.actions != null) return this.actions;
        if (this.isAllHttpActions()) {
            if (!this.hasTransportGuarantee()) return "";
            buffer = new StringBuilder();
        } else {
            buffer = new StringBuilder();
            if (this.isExcluded) {
                buffer.append("!");
            }
            boolean first = true;
            for (int i = 0; i < HTTP_MASKS.length; ++i) {
                if ((this.mask & HTTP_MASKS[i]) <= 0) continue;
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(HTTP_METHODS[i]);
            }
            for (String method : this.extensionMethods) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(method);
            }
        }
        if (this.hasTransportGuarantee()) {
            if (this.transport == 1) {
                buffer.append(":INTEGRAL");
            } else if (this.transport == 2) {
                buffer.append(":CONFIDENTIAL");
            }
        }
        this.actions = buffer.toString();
        return this.actions;
    }

    private boolean isAllHttpActions() {
        return this.isExcluded && this.mask == 0 && this.extensionMethods.length == 0;
    }

    private boolean hasTransportGuarantee() {
        return this.transport != 0 && this.transport != 3;
    }

    public int hashCode() {
        return this.mask ^ this.transport << 8 ^ (this.isExcluded ? 0 : 512);
    }

    public String toString() {
        return this.getActions();
    }

    public boolean implies(HTTPMethodSpec p) {
        if ((this.transport & p.transport) != p.transport) {
            return false;
        }
        if (this.isExcluded) {
            if (p.isExcluded) {
                return (this.mask & p.mask) == this.mask && this.contains(p.extensionMethods, this.extensionMethods);
            }
            return (this.mask & p.mask) == 0 && this.isDisjoint(this.extensionMethods, p.extensionMethods);
        }
        if (p.isExcluded) {
            return false;
        }
        return (this.mask & p.mask) == p.mask && this.contains(this.extensionMethods, p.extensionMethods);
    }

    private boolean isDisjoint(String[] a, String[] b) {
        int start = 0;
        block0: for (int i = 0; i < a.length; ++i) {
            String s = a[i];
            for (int j = start; j < b.length; ++j) {
                String s1 = b[j];
                int compare = s.compareTo(s1);
                if (compare == 0) {
                    return false;
                }
                if (compare >= 0) continue;
                start = j;
                continue block0;
            }
        }
        return true;
    }

    private boolean contains(String[] set, String[] subset) {
        int start = 0;
        for (int i = 0; i < subset.length; ++i) {
            boolean found = false;
            String s = subset[i];
            for (int j = start; j < set.length; ++j) {
                String s1 = set[j];
                int compare = s.compareTo(s1);
                if (compare == 0) {
                    found = true;
                    start = j + 1;
                    break;
                }
                if (compare >= 0) continue;
                return false;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

