/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.util.HttpUtil;
import org.apache.openejb.server.rest.RsRegistry;
import org.apache.openejb.server.rest.RsServlet;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.environment.Hosts;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatRsRegistry
implements RsRegistry {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, TomcatRsRegistry.class);
    private final Hosts hosts;
    private List<Connector> connectors;
    private final Map<String, HttpListener> listeners = new TreeMap<String, HttpListener>();

    public TomcatRsRegistry() {
        for (Service service : TomcatHelper.getServer().findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            this.connectors = Arrays.asList(service.findConnectors());
            break;
        }
        this.hosts = (Hosts)SystemInstance.get().getComponent(Hosts.class);
    }

    public RsRegistry.AddressInfo createRsHttpListener(String webContext, HttpListener listener, ClassLoader classLoader, String completePath, String virtualHost, String auth, String realm) {
        String path = webContext;
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        Context context = null;
        Host host = virtualHost == null ? this.hosts.getDefault() : this.hosts.get(virtualHost);
        if (host == null) {
            for (Host h : this.hosts) {
                context = TomcatRsRegistry.findContext((Container)h, webContext);
                if (context == null) continue;
                host = h;
                if (classLoader == null || !classLoader.equals(context.getLoader().getClassLoader())) continue;
                break;
            }
            if (host == null) {
                throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matching Host entry in the server.xml?");
            }
        } else {
            context = TomcatRsRegistry.findContext((Container)host, webContext);
        }
        if (context == null) {
            throw new IllegalStateException("Invalid context '" + webContext + "'.  Cannot find context in host " + host.getName());
        }
        Wrapper wrapper = context.createWrapper();
        String name = "rest_" + listener.hashCode();
        wrapper.setName(name);
        wrapper.setServletClass(RsServlet.class.getName());
        wrapper.setAsyncSupported(true);
        String mapping = completePath;
        if (!completePath.endsWith("/*")) {
            if (completePath.endsWith("*")) {
                mapping = completePath.substring(0, completePath.length() - 1);
            }
            mapping = mapping + "/*";
        }
        context.addChild((Container)wrapper);
        wrapper.addMapping(TomcatRsRegistry.removeWebContext(webContext, mapping));
        context.addServletMapping(mapping, name);
        String listenerId = wrapper.getName() + RsServlet.class.getName() + listener.hashCode();
        wrapper.addInitParameter(HttpListener.class.getName(), listenerId);
        context.getServletContext().setAttribute(listenerId, (Object)listener);
        path = TomcatRsRegistry.address(this.connectors, host.getName(), webContext);
        String key = TomcatRsRegistry.address(this.connectors, host.getName(), completePath);
        this.listeners.put(key, listener);
        return new RsRegistry.AddressInfo(path, key);
    }

    private static Context findContext(Container host, String webContext) {
        Context webapp = (Context)Context.class.cast(host.findChild(webContext));
        if (webapp == null && "/".equals(webContext)) {
            webapp = (Context)Context.class.cast(host.findChild(""));
        }
        return webapp;
    }

    private static String removeWebContext(String webContext, String completePath) {
        if (webContext == null) {
            return completePath;
        }
        return completePath.substring(webContext.length());
    }

    private static String address(Collection<Connector> connectors, String host, String path) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Connector connector : connectors) {
            URI address;
            try {
                address = new URI(connector.getScheme(), null, host, connector.getPort(), path, null, null);
            }
            catch (Exception e) {
                LOGGER.error("can't add container for path " + path, (Throwable)e);
                continue;
            }
            addresses.add(address.toString());
        }
        return HttpUtil.selectSingleAddress(addresses);
    }

    public HttpListener removeListener(String completePath) {
        String path;
        if (completePath != null && this.listeners.containsKey(path = !(path = completePath).startsWith("/") && !path.startsWith("http://") && !path.startsWith("https://") ? "/" + path : completePath)) {
            return this.listeners.remove(path);
        }
        return null;
    }
}

