/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.realm;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.util.LifecycleBase;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.realm.LowTypedRealm;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.ietf.jgss.GSSContext;

public class LazyRealm
extends LifecycleBase
implements Realm {
    private String realmClass;
    private String properties;
    private boolean cdi;
    private volatile Realm delegate;
    private Context container;
    private CreationalContext<Object> creationalContext;

    public void setRealmClass(String realmClass) {
        this.realmClass = realmClass;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setCdi(boolean cdi) {
        this.cdi = cdi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Realm instance() {
        if (this.delegate == null) {
            LazyRealm lazyRealm = this;
            synchronized (lazyRealm) {
                if (this.delegate == null) {
                    Object instance;
                    Class<?> clazz;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (this.container != null && this.container.getLoader() != null && this.container.getLoader().getClassLoader() != null) {
                        cl = this.container.getLoader().getClassLoader();
                    }
                    try {
                        clazz = cl.loadClass(this.realmClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new TomEERuntimeException(e);
                    }
                    if (!this.cdi) {
                        try {
                            ObjectRecipe recipe = new ObjectRecipe(clazz);
                            recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                            recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                            recipe.allow(Option.FIELD_INJECTION);
                            recipe.allow(Option.PRIVATE_PROPERTIES);
                            if (this.properties != null) {
                                Properties props = new PropertiesAdapter().unmarshal(this.properties.trim().replaceAll("\\p{Space}*(\\p{Alnum}*)=", "\n$1="));
                                recipe.setAllProperties((Map)props);
                            }
                            instance = recipe.create();
                        }
                        catch (Exception e) {
                            throw new TomEERuntimeException(e);
                        }
                    } else {
                        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
                        if (webBeansContext == null) {
                            return null;
                        }
                        BeanManagerImpl bm = webBeansContext.getBeanManagerImpl();
                        Set beans = bm.getBeans(clazz, new Annotation[0]);
                        Bean bean = bm.resolve(beans);
                        this.creationalContext = bm.createCreationalContext(null);
                        instance = bm.getReference(bean, clazz, this.creationalContext);
                    }
                    if (instance == null) {
                        throw new TomEERuntimeException("realm can't be retrieved from cdi");
                    }
                    this.delegate = instance instanceof Realm ? (Realm)instance : new LowTypedRealm(instance);
                    this.delegate.setContainer((Container)this.container);
                }
            }
        }
        return this.delegate;
    }

    protected void initInternal() throws LifecycleException {
        Realm r = this.instance();
        if (r != null && Lifecycle.class.isInstance(r)) {
            ((Lifecycle)Lifecycle.class.cast(r)).init();
        }
    }

    protected void startInternal() throws LifecycleException {
        Realm r = this.instance();
        if (r != null && Lifecycle.class.isInstance(r)) {
            ((Lifecycle)Lifecycle.class.cast(r)).start();
        }
        this.setState(LifecycleState.STARTING);
    }

    protected void stopInternal() throws LifecycleException {
        Realm r = this.instance();
        if (r != null && Lifecycle.class.isInstance(r)) {
            ((Lifecycle)Lifecycle.class.cast(r)).stop();
        }
        this.setState(LifecycleState.STOPPING);
    }

    protected void destroyInternal() throws LifecycleException {
        Realm r = this.instance();
        if (r != null && Lifecycle.class.isInstance(r)) {
            ((Lifecycle)Lifecycle.class.cast(r)).destroy();
        }
    }

    public Container getContainer() {
        if (this.delegate != null) {
            return this.delegate.getContainer();
        }
        return this.container;
    }

    public void setContainer(Container container) {
        container.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                if ("before_stop".equals(event.getType()) && LazyRealm.this.creationalContext != null) {
                    LazyRealm.this.creationalContext.release();
                }
            }
        });
        if (this.delegate != null) {
            this.delegate.setContainer(container);
        } else {
            this.container = (Context)Context.class.cast(container);
        }
    }

    public String getInfo() {
        Realm instance = this.instance();
        if (instance == null) {
            return ((Object)((Object)this)).getClass().getName() + "/1.0";
        }
        return this.instance().getInfo();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Realm instance = this.instance();
        if (instance == null) {
            return;
        }
        instance.addPropertyChangeListener(listener);
    }

    public Principal authenticate(String username, String credentials) {
        return this.instance().authenticate(username, credentials);
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return this.instance().authenticate(username, digest, nonce, nc, cnonce, qop, realm, md5a2);
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCreds) {
        return this.instance().authenticate(gssContext, storeCreds);
    }

    public Principal authenticate(X509Certificate[] certs) {
        return this.instance().authenticate(certs);
    }

    public void backgroundProcess() {
        this.instance().backgroundProcess();
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        return this.instance().findSecurityConstraints(request, context);
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] securityConstraints, Context context) throws IOException {
        return this.instance().hasResourcePermission(request, response, securityConstraints, context);
    }

    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        return this.instance().hasRole(wrapper, principal, role);
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] securityConstraints) throws IOException {
        return this.instance().hasUserDataPermission(request, response, securityConstraints);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Realm instance = this.instance();
        if (instance == null) {
            return;
        }
        instance.removePropertyChangeListener(listener);
    }
}

