/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.security.cache.ReplayCacheFactory;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.cache.ReplayCache;

public final class WSS4JUtils {
    public static final String UNSUPPORTED_TOKEN_ERR = "An unsupported token was provided";
    public static final String UNSUPPORTED_ALGORITHM_ERR = "An unsupported signature or encryption algorithm was used";
    public static final String INVALID_SECURITY_ERR = "An error was discovered processing the <wsse:Security> header.";
    public static final String INVALID_SECURITY_TOKEN_ERR = "An invalid security token was provided";
    public static final String FAILED_AUTHENTICATION_ERR = "The security token could not be authenticated or authorized";
    public static final String FAILED_CHECK_ERR = "The signature or decryption was invalid";
    public static final String SECURITY_TOKEN_UNAVAILABLE_ERR = "Referenced security token could not be retrieved";
    public static final String MESSAGE_EXPIRED_ERR = "The message has expired";

    private WSS4JUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplayCache getReplayCache(SoapMessage message, String booleanKey, String instanceKey) {
        boolean specified = false;
        Object o = message.getContextualProperty(booleanKey);
        if (o != null) {
            if (!MessageUtils.isTrue((Object)o)) {
                return null;
            }
            specified = true;
        }
        if (!specified && MessageUtils.isRequestor((Message)message)) {
            return null;
        }
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        if (ep != null && ep.getEndpointInfo() != null) {
            EndpointInfo info;
            EndpointInfo endpointInfo = info = ep.getEndpointInfo();
            synchronized (endpointInfo) {
                ReplayCache replayCache = (ReplayCache)message.getContextualProperty(instanceKey);
                if (replayCache == null) {
                    replayCache = (ReplayCache)info.getProperty(instanceKey);
                }
                if (replayCache == null) {
                    ReplayCacheFactory replayCacheFactory = ReplayCacheFactory.newInstance();
                    String cacheKey = instanceKey;
                    if (info.getName() != null) {
                        cacheKey = cacheKey + "-" + info.getName().toString();
                    }
                    replayCache = replayCacheFactory.newReplayCache(cacheKey, (Message)message);
                    info.setProperty(instanceKey, (Object)replayCache);
                }
                return replayCache;
            }
        }
        return null;
    }

    public static String getSafeExceptionMessage(WSSecurityException ex) {
        if (ex.getMessage() != null && ex.getMessage().contains("replay attack")) {
            return ex.getMessage();
        }
        String errorMessage = null;
        QName faultCode = ex.getFaultCode();
        errorMessage = WSConstants.UNSUPPORTED_SECURITY_TOKEN.equals(faultCode) ? UNSUPPORTED_TOKEN_ERR : (WSConstants.UNSUPPORTED_ALGORITHM.equals(faultCode) ? UNSUPPORTED_ALGORITHM_ERR : (WSConstants.INVALID_SECURITY.equals(faultCode) ? INVALID_SECURITY_ERR : (WSConstants.INVALID_SECURITY_TOKEN.equals(faultCode) ? INVALID_SECURITY_TOKEN_ERR : (WSConstants.FAILED_AUTHENTICATION.equals(faultCode) ? FAILED_AUTHENTICATION_ERR : (WSConstants.FAILED_CHECK.equals(faultCode) ? FAILED_CHECK_ERR : (WSConstants.SECURITY_TOKEN_UNAVAILABLE.equals(faultCode) ? SECURITY_TOKEN_UNAVAILABLE_ERR : (WSConstants.MESSAGE_EXPIRED.equals(faultCode) ? MESSAGE_EXPIRED_ERR : INVALID_SECURITY_ERR)))))));
        return errorMessage;
    }
}

