/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.BeansInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.classloader.ClassLoaderComparator;
import org.apache.openejb.util.classloader.DefaultClassLoaderComparator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;

public class CdiScanner
implements ScannerService {
    public static final String OPENEJB_CDI_FILTER_CLASSLOADER = "openejb.cdi.filter.classloader";
    public static final ThreadLocal<Collection<String>> ADDITIONAL_CLASSES = new ThreadLocal();
    private static final Map<String, Collection<String>> CONTAINER_CLASSES = new HashMap<String, Collection<String>>();
    private ClassLoader containerLoader;
    private final Set<Class<?>> classes = new HashSet();

    public void init(Object object) {
        if (!StartupObject.class.isInstance(object)) {
            return;
        }
        this.containerLoader = ParentClassLoaderFinder.Helper.get();
        StartupObject startupObject = (StartupObject)StartupObject.class.cast(object);
        AppInfo appInfo = startupObject.getAppInfo();
        ClassLoader classLoader = startupObject.getClassLoader();
        ClassLoaderComparator comparator = classLoader instanceof ClassLoaderComparator ? (ClassLoaderComparator)((Object)classLoader) : new DefaultClassLoaderComparator(classLoader);
        WebBeansContext webBeansContext = startupObject.getWebBeansContext();
        AlternativesManager alternativesManager = webBeansContext.getAlternativesManager();
        DecoratorsManager decoratorsManager = webBeansContext.getDecoratorsManager();
        InterceptorsManager interceptorsManager = webBeansContext.getInterceptorsManager();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            Class clazz;
            BeansInfo beans = ejbJar.beans;
            if (beans == null || "false".equalsIgnoreCase(ejbJar.properties.getProperty("openejb.cdi.activated")) || (!startupObject.isFromWebApp() ? ejbJar.webapp && !appInfo.webAppAlone : !ejbJar.moduleId.equals(startupObject.getWebContext().getId()))) continue;
            StringBuilder errors = new StringBuilder("You must not declare the same class multiple times in the beans.xml: ");
            if (this.addErrors(errors, "alternative classes", beans.duplicatedAlternativeClasses) || this.addErrors(errors, "alternative stereotypes", beans.duplicatedAlternativeStereotypes) || this.addErrors(errors, "decorators", beans.duplicatedDecorators) || this.addErrors(errors, "interceptors", beans.duplicatedInterceptors)) {
                throw new WebBeansConfigurationException(errors.toString());
            }
            beans.duplicatedAlternativeStereotypes.clear();
            beans.duplicatedAlternativeClasses.clear();
            beans.duplicatedDecorators.clear();
            beans.duplicatedInterceptors.clear();
            for (String className : beans.interceptors) {
                clazz = this.load(PropertyPlaceHolderHelper.simpleValue(className), classLoader);
                if (clazz != null) {
                    if (interceptorsManager.isInterceptorClassEnabled(clazz)) continue;
                    interceptorsManager.addEnabledInterceptorClass(clazz);
                    this.classes.add(clazz);
                    continue;
                }
                if (!CdiScanner.shouldThrowCouldNotLoadException(startupObject)) continue;
                throw new WebBeansConfigurationException("Could not load interceptor class: " + className);
            }
            for (String className : beans.decorators) {
                clazz = this.load(PropertyPlaceHolderHelper.simpleValue(className), classLoader);
                if (clazz != null) {
                    if (decoratorsManager.isDecoratorEnabled(clazz)) continue;
                    decoratorsManager.addEnabledDecorator(clazz);
                    this.classes.add(clazz);
                    continue;
                }
                if (!CdiScanner.shouldThrowCouldNotLoadException(startupObject)) continue;
                throw new WebBeansConfigurationException("Could not load decorator class: " + className);
            }
            for (String className : beans.alternativeStereotypes) {
                clazz = this.load(PropertyPlaceHolderHelper.simpleValue(className), classLoader);
                if (clazz != null) {
                    alternativesManager.addStereoTypeAlternative(clazz, null, null);
                    this.classes.add(clazz);
                    continue;
                }
                if (!CdiScanner.shouldThrowCouldNotLoadException(startupObject)) continue;
                throw new WebBeansConfigurationException("Could not load alternativeStereotype class: " + className);
            }
            for (String className : beans.alternativeClasses) {
                clazz = this.load(PropertyPlaceHolderHelper.simpleValue(className), classLoader);
                if (clazz != null) {
                    alternativesManager.addClazzAlternative(clazz, null, null);
                    this.classes.add(clazz);
                    continue;
                }
                if (!CdiScanner.shouldThrowCouldNotLoadException(startupObject)) continue;
                throw new WebBeansConfigurationException("Could not load alternative class: " + className);
            }
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            boolean filterByClassLoader = "true".equals(ejbJar.properties.getProperty(OPENEJB_CDI_FILTER_CLASSLOADER, SystemInstance.get().getProperty(OPENEJB_CDI_FILTER_CLASSLOADER, "true")));
            Iterator<String> it = beans.managedClasses.iterator();
            while (it.hasNext()) {
                this.process(classLoader, it, startupObject, comparator, scl, filterByClassLoader);
            }
            Collection<String> otherClasses = ADDITIONAL_CLASSES.get();
            if (otherClasses != null) {
                Iterator<String> it2 = otherClasses.iterator();
                while (it2.hasNext()) {
                    this.process(classLoader, it2, startupObject, comparator, scl, filterByClassLoader);
                }
            }
            if (startupObject.getBeanContexts() != null) {
                for (BeanContext bc : startupObject.getBeanContexts()) {
                    Class load;
                    String name = bc.getBeanClass().getName();
                    if (BeanContext.Comp.class.getName().equals(name) || (load = this.load(name, classLoader)) == null || this.classes.contains(load)) continue;
                    this.classes.add(load);
                }
            }
            this.addContainerCdiClasses(classLoader, appInfo);
        }
    }

    private void addContainerCdiClasses(ClassLoader loader, AppInfo app) {
        if (!"true".equalsIgnoreCase(app.properties.getProperty("CdiContainer", "true"))) {
            return;
        }
        this.addContainerClasses(app.properties, loader, "BVal");
    }

    private void addContainerClasses(Properties appProps, ClassLoader loader, String key) {
        if (!"true".equalsIgnoreCase(appProps.getProperty("CdiContainer." + key, "true"))) {
            return;
        }
        for (String clazz : CONTAINER_CLASSES.get(key)) {
            try {
                this.classes.add(loader.loadClass(clazz));
            }
            catch (Throwable throwable) {}
        }
    }

    private static boolean shouldThrowCouldNotLoadException(StartupObject startupObject) {
        AppInfo appInfo = startupObject.getAppInfo();
        return appInfo.webAppAlone || appInfo.webApps.size() == 0 || startupObject.isFromWebApp();
    }

    private void process(ClassLoader classLoader, Iterator<String> it, StartupObject startupObject, ClassLoaderComparator comparator, ClassLoader scl, boolean filterByClassLoader) {
        String className = it.next();
        Class clazz = this.load(className, classLoader);
        if (clazz == null) {
            return;
        }
        boolean isNotEarWebApp = startupObject.getWebContext() == null;
        ClassLoader cl = clazz.getClassLoader();
        if (!filterByClassLoader || comparator.isSame(cl) || (cl.equals(scl) || cl == this.containerLoader) && isNotEarWebApp) {
            this.classes.add(clazz);
        } else {
            it.remove();
        }
    }

    private boolean addErrors(StringBuilder errors, String msg, List<String> list) {
        if (!list.isEmpty()) {
            errors.append("[ ").append(msg).append(" --> ");
            for (String s : list) {
                errors.append(s).append(" ");
            }
            errors.append("]");
            return true;
        }
        return false;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return false;
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }

    private Class load(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public void scan() {
    }

    public Set<URL> getBeanXmls() {
        return Collections.emptySet();
    }

    public Set<Class<?>> getBeanClasses() {
        return this.classes;
    }

    public void release() {
        this.classes.clear();
    }

    static {
        Properties props = new Properties();
        try {
            props.load(CdiScanner.class.getResourceAsStream("/container-cdi-classes.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String key : props.stringPropertyNames()) {
            HashSet set = new HashSet();
            CONTAINER_CLASSES.put(key, set);
            Collections.addAll(set, props.getProperty(key).split(","));
        }
    }
}

