/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.ConfigUtils;
import org.apache.openejb.config.sys.ConnectionManager;
import org.apache.openejb.config.sys.Connector;
import org.apache.openejb.config.sys.Container;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JSonConfigReader;
import org.apache.openejb.config.sys.JndiProvider;
import org.apache.openejb.config.sys.ListAdapter;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.openejb.config.sys.ProxyFactory;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.SaxOpenejb;
import org.apache.openejb.config.sys.SecurityService;
import org.apache.openejb.config.sys.Service;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.config.sys.ServicesJar;
import org.apache.openejb.config.sys.Tomee;
import org.apache.openejb.config.sys.TransactionManager;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Saxs;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class JaxbOpenejb {
    public static final ThreadLocal<Set<String>> currentPublicId = new ThreadLocal();
    private static Map<Class, JAXBContext> jaxbContexts = new HashMap<Class, JAXBContext>();

    public static <T> T create(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (type == ConnectionManager.class) {
            return (T)JaxbOpenejb.createConnectionManager();
        }
        if (type == Connector.class) {
            return (T)JaxbOpenejb.createConnector();
        }
        if (type == Container.class) {
            return (T)JaxbOpenejb.createContainer();
        }
        if (type == Deployments.class) {
            return (T)JaxbOpenejb.createDeployments();
        }
        if (type == JndiProvider.class) {
            return (T)JaxbOpenejb.createJndiProvider();
        }
        if (type == Openejb.class) {
            return (T)JaxbOpenejb.createOpenejb();
        }
        if (type == ProxyFactory.class) {
            return (T)JaxbOpenejb.createProxyFactory();
        }
        if (type == Resource.class) {
            return (T)JaxbOpenejb.createResource();
        }
        if (type == SecurityService.class) {
            return (T)JaxbOpenejb.createSecurityService();
        }
        if (type == ServiceProvider.class) {
            return (T)JaxbOpenejb.createServiceProvider();
        }
        if (type == ServicesJar.class) {
            return (T)JaxbOpenejb.createServicesJar();
        }
        if (type == TransactionManager.class) {
            return (T)JaxbOpenejb.createTransactionManager();
        }
        if (type == Tomee.class) {
            return (T)JaxbOpenejb.createTomee();
        }
        throw new IllegalArgumentException("Unknown type " + type.getName());
    }

    public static <T> T create(String type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (type.equals("ConnectionManager")) {
            return (T)JaxbOpenejb.createConnectionManager();
        }
        if (type.equals("Connector")) {
            return (T)JaxbOpenejb.createConnector();
        }
        if (type.equals("Container")) {
            return (T)JaxbOpenejb.createContainer();
        }
        if (type.equals("Deployments")) {
            return (T)JaxbOpenejb.createDeployments();
        }
        if (type.equals("JndiProvider")) {
            return (T)JaxbOpenejb.createJndiProvider();
        }
        if (type.equals("Openejb")) {
            return (T)JaxbOpenejb.createOpenejb();
        }
        if (type.equals("Tomee")) {
            return (T)JaxbOpenejb.createTomee();
        }
        if (type.equals("ProxyFactory")) {
            return (T)JaxbOpenejb.createProxyFactory();
        }
        if (type.equals("Resource")) {
            return (T)JaxbOpenejb.createResource();
        }
        if (type.equals("SecurityService")) {
            return (T)JaxbOpenejb.createSecurityService();
        }
        if (type.equals("ServiceProvider")) {
            return (T)JaxbOpenejb.createServiceProvider();
        }
        if (type.equals("ServicesJar")) {
            return (T)JaxbOpenejb.createServicesJar();
        }
        if (type.equals("TransactionManager")) {
            return (T)JaxbOpenejb.createTransactionManager();
        }
        if (type.equals("Service")) {
            return (T)JaxbOpenejb.createService();
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static ServicesJar readServicesJar(String providerPath) throws OpenEJBException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> sources = new ArrayList<URL>();
        String path1 = "META-INF/" + providerPath + "/service-jar.xml";
        String path2 = providerPath.replace('.', '/') + "/service-jar.xml";
        List<String> paths = Arrays.asList(path1, path2);
        for (String p : paths) {
            try {
                Enumeration<URL> resources = loader.getResources(p);
                if (resources == null) continue;
                sources.addAll(Collections.list(resources));
            }
            catch (IOException e) {
                throw new OpenEJBException(String.format("Unable to scan for service-jar.xml file: getResource('%s')", p), e);
            }
        }
        if (sources.size() == 0) {
            throw new OpenEJBException("No service-jar.xml files found: searched " + Join.join(" and ", paths));
        }
        ServicesJar servicesJar = new ServicesJar();
        for (URL url : sources) {
            try {
                InputStream read = IO.read(url);
                try {
                    ServicesJar jar = JaxbOpenejb.parseServicesJar(read);
                    servicesJar.getServiceProvider().addAll(jar.getServiceProvider());
                }
                catch (Exception e) {
                    throw new OpenEJBException("Unable to parse service-jar.xml file for provider " + providerPath + " at " + url, e);
                }
                finally {
                    IO.close(read);
                }
            }
            catch (IOException e) {
                throw new OpenEJBException("Unable to read service-jar.xml file for provider " + providerPath + " at " + url, e);
            }
        }
        return servicesJar;
    }

    public static ServicesJar parseServicesJar(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(in);
        SAXParser parser = Saxs.namespaceAwareFactory().newSAXParser();
        ServicesJar servicesJar1 = new ServicesJar();
        parser.parse(inputSource, (DefaultHandler)new OpenEJBHandler(servicesJar1));
        ServicesJar servicesJar = servicesJar1;
        return servicesJar;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Openejb readConfig(String configFile) throws OpenEJBException {
        Object url;
        InputStream in;
        block10: {
            in = null;
            if (configFile.startsWith("jar:")) {
                url = new URL(configFile);
                in = IO.read((URL)url);
            } else if (configFile.startsWith("file:")) {
                url = new URL(configFile);
                in = IO.read((URL)url);
            } else {
                in = IO.read(new File(configFile));
            }
            if (!configFile.endsWith(".json")) break block10;
            url = JSonConfigReader.read(Openejb.class, in);
            IO.close(in);
            return url;
        }
        try {
            url = JaxbOpenejb.readConfig(new InputSource(in));
        }
        catch (MalformedURLException e) {
            try {
                throw new OpenEJBException("Unable to resolve location " + configFile, e);
                catch (Exception e2) {
                    throw new OpenEJBException("Unable to read OpenEJB configuration file at " + configFile, e2);
                }
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close(in);
        return url;
    }

    public static Openejb readConfig(InputSource in) throws IOException, SAXException, ParserConfigurationException {
        return SaxOpenejb.parse(in);
    }

    public static void writeConfig(String configFile, Openejb openejb) throws OpenEJBException {
        OutputStream out = null;
        try {
            File file = new File(configFile);
            out = IO.write(file);
            JaxbOpenejb.marshal(Openejb.class, openejb, out);
        }
        catch (IOException e) {
            throw new OpenEJBException(ConfigUtils.messages.format("conf.1040", configFile, e.getLocalizedMessage()), e);
        }
        catch (MarshalException e) {
            if (e.getCause() instanceof IOException) {
                throw new OpenEJBException(ConfigUtils.messages.format("conf.1040", configFile, e.getLocalizedMessage()), e);
            }
            throw new OpenEJBException(ConfigUtils.messages.format("conf.1050", configFile, e.getLocalizedMessage()), e);
        }
        catch (ValidationException e) {
            throw new OpenEJBException(ConfigUtils.messages.format("conf.1060", configFile, e.getLocalizedMessage()), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static <T> String marshal(Class<T> type, Object object) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JaxbOpenejb.marshal(type, object, baos);
        return new String(baos.toByteArray());
    }

    public static <T> void marshal(Class<T> type, Object object, OutputStream out) throws JAXBException {
        JAXBContext jaxbContext = JaxbOpenejb.getContext(type);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(object, out);
    }

    public static <T> JAXBContext getContext(Class<T> type) throws JAXBException {
        JAXBContext jaxbContext = jaxbContexts.get(type);
        if (jaxbContext == null) {
            jaxbContext = JAXBContextFactory.newInstance((Class[])new Class[]{type});
            jaxbContexts.put(type, jaxbContext);
        }
        return jaxbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshal(Class<T> type, InputStream in, boolean filter) throws ParserConfigurationException, SAXException, JAXBException {
        SAXSource source;
        InputSource inputSource = new InputSource(in);
        SAXParser parser = Saxs.namespaceAwareFactory().newSAXParser();
        JAXBContext ctx = JaxbOpenejb.getContext(type);
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                System.out.println(validationEvent);
                return false;
            }
        });
        if (filter) {
            NamespaceFilter xmlFilter = new NamespaceFilter(parser.getXMLReader());
            xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
            source = new SAXSource(xmlFilter, inputSource);
        } else {
            source = new SAXSource(inputSource);
        }
        currentPublicId.set(new TreeSet());
        try {
            Object object = unmarshaller.unmarshal((Source)source, type).getValue();
            return (T)object;
        }
        finally {
            currentPublicId.set(null);
        }
    }

    public static <T> T unmarshal(Class<T> type, InputStream in) throws ParserConfigurationException, SAXException, JAXBException {
        return JaxbOpenejb.unmarshal(type, in, true);
    }

    public static ConnectionManager createConnectionManager() {
        return new ConnectionManager();
    }

    public static Connector createConnector() {
        return new Connector();
    }

    public static Container createContainer() {
        return new Container();
    }

    public static Deployments createDeployments() {
        return new Deployments();
    }

    public static Service createService() {
        return new Service();
    }

    public static JndiProvider createJndiProvider() {
        return new JndiProvider();
    }

    public static Openejb createOpenejb() {
        return new Openejb();
    }

    private static Tomee createTomee() {
        return new Tomee();
    }

    public static ProxyFactory createProxyFactory() {
        return new ProxyFactory();
    }

    public static Resource createResource() {
        return new Resource();
    }

    public static SecurityService createSecurityService() {
        return new SecurityService();
    }

    public static ServiceProvider createServiceProvider() {
        return new ServiceProvider();
    }

    public static ServicesJar createServicesJar() {
        return new ServicesJar();
    }

    public static TransactionManager createTransactionManager() {
        return new TransactionManager();
    }

    private static class OpenEJBHandler
    extends DefaultHandler {
        private final PropertiesAdapter propertiesAdapter = new PropertiesAdapter();
        private final ServicesJar servicesJar;
        private ServiceProvider provider;
        private StringBuilder content;

        public OpenEJBHandler(ServicesJar servicesJar1) {
            this.servicesJar = servicesJar1;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
            if (!localName.equals("ServiceProvider")) {
                return;
            }
            this.provider = new ServiceProvider();
            this.provider.setId(att.getValue("", "id"));
            this.provider.setService(att.getValue("", "service"));
            this.provider.setFactoryName(att.getValue("", "factory-name"));
            this.provider.setConstructor(att.getValue("", "constructor"));
            this.provider.setClassName(att.getValue("", "class-name"));
            this.provider.setParent(att.getValue("", "parent"));
            String typesString = att.getValue("", "types");
            if (typesString != null) {
                ListAdapter listAdapter = new ListAdapter();
                List<String> types = listAdapter.unmarshal(typesString);
                this.provider.getTypes().addAll(types);
            }
            this.servicesJar.getServiceProvider().add(this.provider);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.content == null) {
                this.content = new StringBuilder();
            }
            this.content.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.provider == null || this.content == null) {
                return;
            }
            try {
                this.provider.getProperties().putAll((Map<?, ?>)this.propertiesAdapter.unmarshal(this.content.toString()));
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            this.provider = null;
            this.content = null;
        }
    }

    public static class NamespaceFilter
    extends XMLFilterImpl {
        public NamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Set<String> publicIds = currentPublicId.get();
            if (publicIds != null) {
                publicIds.add(publicId);
            }
            return super.resolveEntity(publicId, systemId);
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            super.startElement("http://www.openejb.org/System/Configuration", localName, qname, atts);
        }
    }
}

