/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Container;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public class CoreContainerSystem
implements ContainerSystem {
    private final Map<Object, AppContext> apps = new ConcurrentHashMap<Object, AppContext>();
    private final Map<Object, BeanContext> deployments = new ConcurrentHashMap<Object, BeanContext>();
    private final Map<Object, Container> containers = new ConcurrentHashMap<Object, Container>();
    private final Map<String, List<WebContext>> webDeployments = new ConcurrentHashMap<String, List<WebContext>>();
    private final Context jndiContext;

    public CoreContainerSystem(JndiFactory jndiFactory) {
        if (jndiFactory == null) {
            throw new NullPointerException("JndiFactory required");
        }
        this.jndiContext = jndiFactory.createRootContext();
        try {
            if (!(this.jndiContext.lookup("openejb/local") instanceof Context && this.jndiContext.lookup("openejb/remote") instanceof Context && this.jndiContext.lookup("openejb/client") instanceof Context && this.jndiContext.lookup("openejb/Deployment") instanceof Context && this.jndiContext.lookup("openejb/global") instanceof Context)) {
                throw new OpenEJBRuntimeException("core openejb naming context not properly initialized.  It must have subcontexts for openejb/local, openejb/remote, openejb/client, and openejb/Deployment already present");
            }
        }
        catch (NamingException exception) {
            throw new OpenEJBRuntimeException("core openejb naming context not properly initialized.  It must have subcontexts for openejb/local, openejb/remote, openejb/client, and openejb/Deployment already present", exception);
        }
        SystemInstance.get().setComponent(JndiFactory.class, jndiFactory);
    }

    @Override
    public BeanContext getBeanContext(Object deploymentID) {
        return this.deployments.get(deploymentID);
    }

    @Override
    public BeanContext[] deployments() {
        return this.deployments.values().toArray(new BeanContext[this.deployments.size()]);
    }

    public void addDeployment(BeanContext deployment) {
        this.deployments.put(deployment.getDeploymentID(), deployment);
    }

    public void removeBeanContext(BeanContext info) {
        this.deployments.remove(info.getDeploymentID());
    }

    @Override
    public Container getContainer(Object id) {
        return this.containers.get(id);
    }

    @Override
    public Container[] containers() {
        return this.containers.values().toArray(new Container[this.containers.size()]);
    }

    public void addContainer(Object id, Container c) {
        this.containers.put(id, c);
    }

    public void removeContainer(Object id) {
        this.containers.remove(id);
    }

    @Override
    public WebContext getWebContextByHost(String id, String host) {
        List<WebContext> webContexts = this.webDeployments.get(id);
        if (webContexts == null || webContexts.isEmpty()) {
            return null;
        }
        if (webContexts.size() == 1 && webContexts.get(0).getHost() == null) {
            return webContexts.get(0);
        }
        for (WebContext web : webContexts) {
            if (web.getHost() == null || !web.getHost().equals(host)) continue;
            return web;
        }
        return null;
    }

    @Override
    public WebContext getWebContext(String id) {
        List<WebContext> webContexts = this.webDeployments.get(id);
        return webContexts != null && !webContexts.isEmpty() ? webContexts.get(0) : null;
    }

    public WebContext[] WebDeployments() {
        ArrayList all = new ArrayList(this.webDeployments.size());
        for (Collection collection : this.webDeployments.values()) {
            all.addAll(collection);
        }
        return all.toArray(new WebContext[all.size()]);
    }

    public void addWebContext(WebContext webDeployment) {
        String id = webDeployment.getId();
        List<WebContext> list = this.webDeployments.get(id);
        if (list == null) {
            list = new ArrayList<WebContext>();
            this.webDeployments.put(id, list);
        }
        list.add(webDeployment);
    }

    public void removeWebContext(WebContext info) {
        this.webDeployments.remove(info.getId());
    }

    @Override
    public Context getJNDIContext() {
        return this.jndiContext;
    }

    @Override
    public List<AppContext> getAppContexts() {
        return new ArrayList<AppContext>(this.apps.values());
    }

    @Override
    public AppContext getAppContext(Object id) {
        AppContext context = this.apps.get(id);
        if (null == context && null != id) {
            context = this.apps.get(id.toString().toLowerCase());
        }
        return context;
    }

    public void addAppContext(AppContext appContext) {
        this.apps.put(appContext.getId().toLowerCase(), appContext);
    }

    public AppContext removeAppContext(Object id) {
        AppContext context = this.apps.remove(id);
        if (null == context && null != id) {
            context = this.apps.remove(id.toString().toLowerCase());
        }
        return context;
    }

    public synchronized Object[] getAppContextKeys() {
        return this.apps.keySet().toArray();
    }
}

