/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Request;
import org.apache.openejb.client.RequestType;

public class AuthenticationRequest
implements Request {
    private static final long serialVersionUID = 7009531340198948330L;
    private transient String realm;
    private transient String username;
    private transient String credentials;
    private transient long timeout;
    private transient ProtocolMetaData metaData;
    private transient Object logoutIdentity = null;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(String principal, String credentials) {
        this(null, principal, credentials, 0L);
    }

    public AuthenticationRequest(String principal, String credentials, long timeout) {
        this(null, principal, credentials, timeout);
    }

    public AuthenticationRequest(String securityRealm, String username, String password) {
        this(securityRealm, username, password, 0L);
    }

    public AuthenticationRequest(String realm, String principal, String credentials, long timeout) {
        this.realm = realm;
        this.username = principal;
        this.credentials = credentials;
        this.timeout = timeout;
    }

    @Override
    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.AUTH_REQUEST;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Object getLogoutIdentity() {
        return this.logoutIdentity;
    }

    public void setLogoutIdentity(Object logoutIdentity) {
        this.logoutIdentity = logoutIdentity;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.realm = (String)in.readObject();
        this.username = (String)in.readObject();
        this.credentials = (String)in.readObject();
        if (null == this.metaData || this.metaData.isAtLeast(4, 7)) {
            this.timeout = in.readLong();
            this.logoutIdentity = in.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.realm);
        out.writeObject(this.username);
        out.writeObject(this.credentials);
        out.writeLong(this.timeout);
        out.writeObject(this.logoutIdentity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(null != this.realm ? this.realm : "Undefined realm").append(':');
        sb.append(null != this.username ? this.username : "Undefined user").append(':');
        sb.append(null != this.credentials ? this.credentials : "Undefined credentials").append(':');
        sb.append(null != this.logoutIdentity ? this.logoutIdentity : "Undefined logoutIdentity").append(':');
        sb.append(this.timeout);
        return sb.toString();
    }
}

